/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.tostring;

import java.io.Externalizable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteTriConsumer;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.ClassDescriptor;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.FieldDescriptor;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.IgniteStringifier;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.SensitiveDataLoggingPolicy;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.StringBuilderLimitedLength;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.Stringifier;
import org.apache.ignite.shaded.org.apache.ignite.table.Tuple;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class IgniteToStringBuilder {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int COLLECTION_LIMIT = 100;
    private static final VarHandle SENSITIVE_DATA_POLICY;
    private static SensitiveDataLoggingPolicy sensitiveDataPolicy;
    private static final ThreadLocal<StringBuilderLimitedLength> threadLocSB;
    private static final ThreadLocal<IdentityHashMap<Object, EntryReference>> savedObjects;
    private static final Map<String, ClassDescriptor> classCache;

    public static SensitiveDataLoggingPolicy getSensitiveDataLogging() {
        return SENSITIVE_DATA_POLICY.getOpaque();
    }

    public static void setSensitiveDataPolicy(SensitiveDataLoggingPolicy policy) {
        assert (Objects.nonNull((Object)policy));
        SENSITIVE_DATA_POLICY.setOpaque(policy);
    }

    public static boolean includeSensitive() {
        return IgniteToStringBuilder.getSensitiveDataLogging() == SensitiveDataLoggingPolicy.PLAIN;
    }

    public static String identity(Object obj) {
        return "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4) {
        return IgniteToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false);
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4, String name5, Object val5) {
        return IgniteToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false, name5, val5, false);
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4, String name5, Object val5, String name6, Object val6) {
        return IgniteToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false, name5, val5, false, name6, val6, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        Object[] addNames = new Object[5];
        Object[] addVals = new Object[5];
        boolean[] addSens = new boolean[5];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 5);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4, String name5, Object val5, boolean sens5) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        Object[] addNames = new Object[6];
        Object[] addVals = new Object[6];
        boolean[] addSens = new boolean[6];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        addNames[5] = name5;
        addVals[5] = val5;
        addSens[5] = sens5;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 6);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4, String name5, Object val5, boolean sens5, String name6, Object val6, boolean sens6) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        assert (name6 != null);
        Object[] addNames = new Object[7];
        Object[] addVals = new Object[7];
        boolean[] addSens = new boolean[7];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        addNames[5] = name5;
        addVals[5] = val5;
        addSens[5] = sens5;
        addNames[6] = name6;
        addVals[6] = val6;
        addSens[6] = sens6;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 7);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3) {
        return IgniteToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        Object[] addNames = new Object[4];
        Object[] addVals = new Object[4];
        boolean[] addSens = new boolean[4];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 4);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2) {
        return IgniteToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        Object[] addNames = new Object[3];
        Object[] addVals = new Object[3];
        boolean[] addSens = new boolean[3];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 3);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, @Nullable Object val0, String name1, @Nullable Object val1) {
        return IgniteToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        Object[] addNames = new Object[2];
        Object[] addVals = new Object[2];
        boolean[] addSens = new boolean[2];
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 2);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name, @Nullable Object val) {
        return IgniteToStringBuilder.toString(cls, obj, name, val, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name, @Nullable Object val, boolean sens) {
        assert (cls != null);
        assert (obj != null);
        assert (name != null);
        Object[] addNames = new Object[1];
        Object[] addVals = new Object[1];
        boolean[] addSens = new boolean[1];
        addNames[0] = name;
        addVals[0] = val;
        addSens[0] = sens;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, addNames, addVals, addSens, 1);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj) {
        assert (cls != null);
        assert (obj != null);
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, EMPTY_ARRAY, EMPTY_ARRAY, null, 0);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(@Nullable Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> cls = obj.getClass();
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(cls, sb, obj, EMPTY_ARRAY, EMPTY_ARRAY, null, 0);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String parent) {
        return parent != null ? IgniteToStringBuilder.toString(cls, obj, "super", (Object)parent) : IgniteToStringBuilder.toString(cls, obj);
    }

    private static void toString(StringBuilderLimitedLength buf, Object val) {
        IgniteToStringBuilder.toString(buf, null, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toString(StringBuilderLimitedLength buf, @Nullable Class<?> cls, @Nullable Object val) {
        if (val == null) {
            buf.app("null");
            return;
        }
        if (cls == null) {
            cls = val.getClass();
        }
        if (cls.isPrimitive()) {
            buf.app(val);
            return;
        }
        IdentityHashMap<Object, EntryReference> svdObjs = savedObjects.get();
        if (IgniteToStringBuilder.handleRecursion(buf, val, cls, svdObjs)) {
            return;
        }
        svdObjs.put(val, new EntryReference(buf.length()));
        try {
            if (cls.isArray()) {
                IgniteToStringBuilder.addArray(buf, cls, val);
            } else if (val instanceof Collection) {
                IgniteToStringBuilder.addCollection(buf, (Collection)val);
            } else if (val instanceof Map) {
                IgniteToStringBuilder.addMap(buf, (Map)val);
            } else {
                buf.app(val);
            }
        }
        finally {
            svdObjs.remove(val);
        }
    }

    public static String toString(String str, String name, @Nullable Object val) {
        return IgniteToStringBuilder.toString(str, name, val, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name, @Nullable Object val, boolean sens) {
        assert (name != null);
        Object[] propNames = new Object[1];
        Object[] propVals = new Object[1];
        boolean[] propSens = new boolean[1];
        propNames[0] = name;
        propVals[0] = val;
        propSens[0] = sens;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 1);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static String toString(String str, String name0, @Nullable Object val0, String name1, @Nullable Object val1) {
        return IgniteToStringBuilder.toString(str, name0, val0, false, name1, val1, false);
    }

    public static String toString(String str, String name0, @Nullable Object val0, String name1, @Nullable Object val1, String name2, @Nullable Object val2) {
        return IgniteToStringBuilder.toString(str, name0, val0, false, name1, val1, false, name2, val2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1) {
        assert (name0 != null);
        assert (name1 != null);
        Object[] propNames = new Object[2];
        Object[] propVals = new Object[2];
        boolean[] propSens = new boolean[2];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 2);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        Object[] propNames = new Object[3];
        Object[] propVals = new Object[3];
        boolean[] propSens = new boolean[3];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 3);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        Object[] propNames = new Object[4];
        Object[] propVals = new Object[4];
        boolean[] propSens = new boolean[4];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 4);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        Object[] propNames = new Object[5];
        Object[] propVals = new Object[5];
        boolean[] propSens = new boolean[5];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 5);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4, String name5, @Nullable Object val5, boolean sens5) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        Object[] propNames = new Object[6];
        Object[] propVals = new Object[6];
        boolean[] propSens = new boolean[6];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        propNames[5] = name5;
        propVals[5] = val5;
        propSens[5] = sens5;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 6);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4, String name5, @Nullable Object val5, boolean sens5, String name6, @Nullable Object val6, boolean sens6) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        assert (name6 != null);
        Object[] propNames = new Object[7];
        Object[] propVals = new Object[7];
        boolean[] propSens = new boolean[7];
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        propNames[5] = name5;
        propVals[5] = val5;
        propSens[5] = sens5;
        propNames[6] = name6;
        propVals[6] = val6;
        propSens[6] = sens6;
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, 7);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, List<?> propNames, List<?> propVals) {
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            assert (propNames.size() == propVals.size());
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames.toArray(), propVals.toArray(), null, propNames.size());
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, Object ... triplets) {
        if (triplets.length % 3 != 0) {
            throw new IllegalArgumentException("Array length must be a multiple of 3");
        }
        int propCnt = triplets.length / 3;
        Object[] propNames = new Object[propCnt];
        Object[] propVals = new Object[propCnt];
        boolean[] propSens = new boolean[propCnt];
        for (int i = 0; i < propCnt; ++i) {
            Object name = triplets[i * 3];
            assert (name != null);
            propNames[i] = name;
            propVals[i] = triplets[i * 3 + 1];
            Object sens = triplets[i * 3 + 2];
            assert (sens instanceof Boolean);
            propSens[i] = (Boolean)sens;
        }
        StringBuilderLimitedLength sb = threadLocSB.get();
        boolean newStr = sb.length() == 0;
        try {
            String string = IgniteToStringBuilder.toStringImpl(str, sb, propNames, propVals, propSens, propCnt);
            return string;
        }
        finally {
            if (newStr) {
                sb.reset();
            }
        }
    }

    public static <T> String toString(List<T> list, IgniteTriConsumer<IgniteStringBuilder, T, Integer> elementToString) {
        int listSize = list.size();
        IgniteStringBuilder buf = new IgniteStringBuilder();
        buf.app(" [");
        int cnt = 0;
        boolean needHandleOverflow = true;
        try {
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    buf.app(',');
                }
                T el = list.get(i);
                elementToString.accept(buf, (IgniteStringBuilder)el, i);
                if (++cnt != 100 && cnt != listSize) {
                    continue;
                }
                break;
            }
        }
        catch (ConcurrentModificationException e) {
            IgniteToStringBuilder.handleConcurrentModification(buf, cnt, listSize);
            needHandleOverflow = false;
        }
        if (needHandleOverflow) {
            IgniteToStringBuilder.handleOverflow(buf, listSize);
        }
        buf.app(']');
        return buf.toString();
    }

    private static void addArray(StringBuilderLimitedLength buf, Class arrType, Object obj) {
        if (arrType.getComponentType().isPrimitive()) {
            buf.app(IgniteToStringBuilder.arrayToString(obj));
            return;
        }
        Object[] arr = (Object[])obj;
        buf.app(arrType.getSimpleName()).app(" [");
        for (int i = 0; i < arr.length; ++i) {
            IgniteToStringBuilder.toString(buf, arr[i]);
            if (i == 99 || i == arr.length - 1) break;
            buf.app(", ");
        }
        IgniteToStringBuilder.handleOverflow(buf, arr.length);
        buf.app(']');
    }

    private static void addCollection(StringBuilderLimitedLength buf, Collection<?> col) {
        buf.app(col.getClass().getSimpleName()).app(" [");
        int cnt = 0;
        boolean needHandleOverflow = true;
        Iterator<?> iter = col.iterator();
        int colSize = col.size();
        while (iter.hasNext()) {
            Object obj;
            try {
                obj = iter.next();
            }
            catch (ConcurrentModificationException e) {
                IgniteToStringBuilder.handleConcurrentModification(buf, cnt, colSize);
                needHandleOverflow = false;
                break;
            }
            IgniteToStringBuilder.toString(buf, obj);
            if (++cnt == 100 || cnt == colSize) break;
            buf.app(", ");
        }
        if (needHandleOverflow) {
            IgniteToStringBuilder.handleOverflow(buf, colSize);
        }
        buf.app(']');
    }

    private static <K, V> void addMap(StringBuilderLimitedLength buf, Map<K, V> map) {
        buf.app(map.getClass().getSimpleName()).app(" {");
        int cnt = 0;
        boolean needHandleOverflow = true;
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        int mapSize = map.size();
        while (iter.hasNext()) {
            V value;
            K key;
            try {
                Map.Entry<K, V> entry = iter.next();
                key = entry.getKey();
                value = entry.getValue();
            }
            catch (ConcurrentModificationException e) {
                IgniteToStringBuilder.handleConcurrentModification(buf, cnt, mapSize);
                needHandleOverflow = false;
                break;
            }
            IgniteToStringBuilder.toString(buf, key);
            buf.app('=');
            IgniteToStringBuilder.toString(buf, value);
            if (++cnt == 100 || cnt == mapSize) break;
            buf.app(", ");
        }
        if (needHandleOverflow) {
            IgniteToStringBuilder.handleOverflow(buf, mapSize);
        }
        buf.app('}');
    }

    private static void handleOverflow(IgniteStringBuilder buf, int size) {
        int overflow = size - 100;
        if (overflow > 0) {
            buf.app("... and ").app(overflow).app(" more");
        }
    }

    private static void handleConcurrentModification(IgniteStringBuilder buf, int writtenElements, int size) {
        buf.app("... concurrent modification was detected, ").app(writtenElements).app(" out of ").app(size).app(" were written");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> String toStringImpl(Class<T> cls, StringBuilderLimitedLength buf, T obj, Object[] addNames, Object[] addVals, @Nullable boolean[] addSens, int addLen) {
        assert (cls != null);
        assert (buf != null);
        assert (obj != null);
        assert (addNames != null);
        assert (addVals != null);
        assert (addNames.length == addVals.length);
        assert (addLen <= addNames.length);
        boolean newStr = buf.length() == 0;
        IdentityHashMap<Object, EntryReference> svdObjs = savedObjects.get();
        if (newStr) {
            svdObjs.put(obj, new EntryReference(buf.length()));
        }
        try {
            int len = buf.length();
            String s = IgniteToStringBuilder.toStringImpl0(cls, buf, obj, addNames, addVals, addSens, addLen);
            if (newStr) {
                String string = s;
                return string;
            }
            buf.setLength(len);
            String string = s.substring(len);
            return string;
        }
        finally {
            if (newStr) {
                svdObjs.remove(obj);
            }
        }
    }

    private static String toStringImpl(String str, StringBuilderLimitedLength buf, Object[] propNames, Object[] propVals, boolean[] propSens, int propCnt) {
        boolean newStr;
        boolean bl = newStr = buf.length() == 0;
        if (str != null) {
            buf.app(str).app(" ");
        }
        buf.app("[");
        IgniteToStringBuilder.appendVals(buf, true, propNames, propVals, propSens, propCnt);
        buf.app(']');
        if (newStr) {
            return buf.toString();
        }
        return "";
    }

    private static <T> String toStringImpl0(Class<T> cls, StringBuilderLimitedLength buf, T obj, Object[] addNames, Object[] addVals, @Nullable boolean[] addSens, int addLen) {
        try {
            ClassDescriptor cd = IgniteToStringBuilder.getClassDescriptor(cls);
            assert (cd != null) : cls;
            buf.app(cd.getName());
            EntryReference ref = savedObjects.get().get(obj);
            if (ref != null && ref.hashNeeded) {
                buf.app(IgniteToStringBuilder.identity(obj));
                ref.hashNeeded = false;
            }
            buf.app(" [");
            @Nullable Stringifier<?> classStringifier = cd.getStringifier();
            boolean first = true;
            if (classStringifier != null) {
                buf.app(classStringifier.toString(obj));
                first = false;
            } else {
                for (FieldDescriptor fd : cd.getFields()) {
                    if (!first) {
                        buf.app(", ");
                    } else {
                        first = false;
                    }
                    buf.app(fd.getName()).app('=');
                    @Nullable Object fieldValue = fd.varHandle().get(obj);
                    @Nullable Stringifier<?> fieldStringifier = fd.stringifier();
                    if (fieldStringifier != null && fieldValue != null) {
                        fieldValue = fieldStringifier.toString(fieldValue);
                    }
                    switch (fd.type()) {
                        case 0: {
                            try {
                                IgniteToStringBuilder.toString(buf, fd.fieldClass(), fieldValue);
                            }
                            catch (RuntimeException e) {
                                buf.app("Runtime exception was caught when building string representation: " + e.getMessage());
                            }
                            break;
                        }
                        case 1: {
                            buf.app(((Byte)fieldValue).byteValue());
                            break;
                        }
                        case 2: {
                            buf.app((Boolean)fieldValue);
                            break;
                        }
                        case 3: {
                            buf.app(((Character)fieldValue).charValue());
                            break;
                        }
                        case 4: {
                            buf.app(((Short)fieldValue).shortValue());
                            break;
                        }
                        case 5: {
                            buf.app((Integer)fieldValue);
                            break;
                        }
                        case 6: {
                            buf.app(((Float)fieldValue).floatValue());
                            break;
                        }
                        case 7: {
                            buf.app((Long)fieldValue);
                            break;
                        }
                        case 8: {
                            buf.app((Double)fieldValue);
                            break;
                        }
                    }
                }
            }
            IgniteToStringBuilder.appendVals(buf, first, addNames, addVals, addSens, addLen);
            buf.app(']');
            return buf.toString();
        }
        catch (Exception e) {
            classCache.remove(cls.getName() + System.identityHashCode(cls.getClassLoader()));
            throw new IgniteInternalException(e);
        }
    }

    public static String arrayToString(Object arr) {
        String res;
        int arrLen;
        if (arr == null) {
            return "null";
        }
        if (arr instanceof Object[]) {
            Object[] objArr = (Object[])arr;
            arrLen = objArr.length;
            if (arrLen > 100) {
                objArr = Arrays.copyOf(objArr, 100);
            }
            res = Arrays.toString(objArr);
        } else {
            res = IgniteToStringBuilder.toStringWithLimit(arr, 100);
            arrLen = Array.getLength(arr);
        }
        if (arrLen > 100) {
            StringBuilder sb = new StringBuilder(res);
            sb.deleteCharAt(sb.length() - 1);
            sb.append("... and ").append(arrLen - 100).append(" more]");
            res = sb.toString();
        }
        return res;
    }

    private static String toStringWithLimit(Object arr, int limit) {
        int arrIdxMax = Array.getLength(arr) - 1;
        if (arrIdxMax == -1) {
            return "[]";
        }
        int idxMax = Math.min(arrIdxMax, limit);
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i <= idxMax; ++i) {
            b.append(Array.get(arr, i));
            if (i == idxMax) {
                return b.append(']').toString();
            }
            b.append(", ");
        }
        return b.toString();
    }

    private static void appendVals(StringBuilderLimitedLength buf, boolean first, Object[] addNames, Object[] addVals, boolean[] addSens, int addLen) {
        if (addLen > 0) {
            for (int i = 0; i < addLen; ++i) {
                IgniteToStringInclude incAnn;
                Object addVal = addVals[i];
                if (addVal != null && (addSens != null && addSens[i] && !IgniteToStringBuilder.includeSensitive() || (incAnn = addVal.getClass().getAnnotation(IgniteToStringInclude.class)) != null && incAnn.sensitive() && !IgniteToStringBuilder.includeSensitive())) continue;
                if (!first) {
                    buf.app(", ");
                } else {
                    first = false;
                }
                buf.app(addNames[i]).app('=');
                IgniteToStringBuilder.toString(buf, addVal);
            }
        }
    }

    private static <T> ClassDescriptor getClassDescriptor(Class<T> cls) throws IllegalAccessException {
        assert (cls != null);
        String key = cls.getName() + System.identityHashCode(cls.getClassLoader());
        ClassDescriptor cd = classCache.get(key);
        if (cd != null) {
            return cd;
        }
        cd = new ClassDescriptor(cls);
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(cls, MethodHandles.lookup());
        for (Field f : cls.getDeclaredFields()) {
            boolean add = false;
            Class<?> type = f.getType();
            IgniteToStringInclude incFld = f.getAnnotation(IgniteToStringInclude.class);
            IgniteToStringInclude incType = type.getAnnotation(IgniteToStringInclude.class);
            IgniteStringifier stringifierField = f.getAnnotation(IgniteStringifier.class);
            IgniteStringifier stringifierType = type.getAnnotation(IgniteStringifier.class);
            if (stringifierField != null || stringifierType != null) {
                add = true;
            } else if (incFld != null || incType != null) {
                boolean notSens = !(incFld != null && incFld.sensitive() || incType != null && incType.sensitive());
                add = notSens || IgniteToStringBuilder.includeSensitive();
            } else if (!(f.isAnnotationPresent(IgniteToStringExclude.class) || type.isAnnotationPresent(IgniteToStringExclude.class) || Modifier.isStatic(f.getModifiers()) || Object.class == type || Serializable.class == type || Externalizable.class == type || type.isArray() || EventListener.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || OutputStream.class.isAssignableFrom(type) || Thread.class.isAssignableFrom(type) || Runnable.class.isAssignableFrom(type) || Lock.class.isAssignableFrom(type) || ReadWriteLock.class.isAssignableFrom(type) || Condition.class.isAssignableFrom(type))) {
                add = true;
            }
            if (!add) continue;
            cd.addField(new FieldDescriptor(f, lookup.unreflectVarHandle(f)));
        }
        cd.sortFields();
        classCache.putIfAbsent(key, cd);
        return cd;
    }

    public static String compact(Collection<Integer> col) {
        return IgniteToStringBuilder.compact(col, i -> i + 1);
    }

    public static <T extends Number> String compact(Collection<T> col, Function<T, T> nextValFun) {
        Number left;
        assert (Objects.nonNull(col));
        assert (Objects.nonNull(nextValFun));
        if (col.isEmpty()) {
            return "[]";
        }
        IgniteStringBuilder sb = new IgniteStringBuilder();
        sb.app('[');
        ArrayList<T> l = new ArrayList<T>(col);
        Collections.sort(l);
        Number right = left = (Number)l.get(0);
        for (int i = 1; i < l.size(); ++i) {
            Number val = (Number)l.get(i);
            if (((Comparable)((Object)right)).compareTo(val) == 0 || ((Comparable)((Object)((Number)nextValFun.apply(right)))).compareTo(val) == 0) {
                right = val;
                continue;
            }
            if (((Comparable)((Object)left)).compareTo(right) == 0) {
                sb.app(left);
            } else {
                sb.app(left).app('-').app(right);
            }
            sb.app(',').app(' ');
            left = right = val;
        }
        if (((Comparable)((Object)left)).compareTo(right) == 0) {
            sb.app(left);
        } else {
            sb.app(left).app('-').app(right);
        }
        sb.app(']');
        return sb.toString();
    }

    private static boolean handleRecursion(StringBuilderLimitedLength buf, Object obj, Class<?> cls, IdentityHashMap<Object, EntryReference> svdObjs) {
        EntryReference ref = svdObjs.get(obj);
        if (ref == null) {
            return false;
        }
        int pos = ref.pos;
        String name = cls.getSimpleName();
        String hash = IgniteToStringBuilder.identity(obj);
        String savedName = name + hash;
        String charsAtPos = buf.impl().substring(pos, pos + savedName.length());
        if (!buf.isOverflowed() && !savedName.equals(charsAtPos)) {
            if (charsAtPos.startsWith(cls.getSimpleName())) {
                buf.ins(pos + name.length(), hash);
                IgniteToStringBuilder.incValues(svdObjs, obj, hash.length());
            } else {
                ref.hashNeeded = true;
            }
        }
        buf.app(savedName);
        return true;
    }

    private static void incValues(IdentityHashMap<Object, EntryReference> svdObjs, Object obj, int hashLen) {
        int baseline = svdObjs.get((Object)obj).pos;
        for (Map.Entry<Object, EntryReference> entry : svdObjs.entrySet()) {
            EntryReference ref = entry.getValue();
            int pos = ref.pos;
            if (pos <= baseline) continue;
            ref.pos = pos + hashLen;
        }
    }

    public static String tupleToString(Tuple tuple) {
        StringBuilder b = new StringBuilder();
        b.append(tuple.getClass().getSimpleName()).append(" [");
        for (int i = 0; i < tuple.columnCount(); ++i) {
            if (i > 0) {
                b.append(", ");
            }
            Object value = tuple.value(i);
            b.append(tuple.columnName(i)).append('=').append(value);
        }
        b.append(']');
        return b.toString();
    }

    protected IgniteToStringBuilder() {
    }

    static {
        sensitiveDataPolicy = SensitiveDataLoggingPolicy.HASH;
        try {
            SENSITIVE_DATA_POLICY = MethodHandles.lookup().findStaticVarHandle(IgniteToStringBuilder.class, "sensitiveDataPolicy", SensitiveDataLoggingPolicy.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        threadLocSB = ThreadLocal.withInitial(() -> new StringBuilderLimitedLength(256));
        savedObjects = ThreadLocal.withInitial(IdentityHashMap::new);
        classCache = new ConcurrentHashMap<String, ClassDescriptor>();
    }

    private static class EntryReference {
        int pos;
        boolean hashNeeded;

        private EntryReference(int pos) {
            this.pos = pos;
            this.hashNeeded = false;
        }
    }
}

