/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryConfigurations;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryDependentConfiguration;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.boot.autoconfigure.sql.init.SqlInitializationAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={DataSourceAutoConfiguration.class, SqlInitializationAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class})
@ConditionalOnResource(resources={"classpath:META-INF/services/io.r2dbc.spi.ConnectionFactoryProvider"})
@EnableConfigurationProperties(value={R2dbcProperties.class})
@Import(value={ConnectionFactoryConfigurations.PoolConfiguration.class, ConnectionFactoryConfigurations.GenericConfiguration.class, ConnectionFactoryDependentConfiguration.class})
public class R2dbcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={R2dbcConnectionDetails.class})
    @ConditionalOnProperty(value={"spring.r2dbc.url"})
    PropertiesR2dbcConnectionDetails propertiesR2dbcConnectionDetails(R2dbcProperties properties) {
        return new PropertiesR2dbcConnectionDetails(properties);
    }

    static class PropertiesR2dbcConnectionDetails
    implements R2dbcConnectionDetails {
        private final R2dbcProperties properties;

        PropertiesR2dbcConnectionDetails(R2dbcProperties properties) {
            this.properties = properties;
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            ConnectionFactoryOptions urlOptions = ConnectionFactoryOptions.parse((CharSequence)this.properties.getUrl());
            ConnectionFactoryOptions.Builder optionsBuilder = urlOptions.mutate();
            this.configureIf(optionsBuilder, urlOptions, ConnectionFactoryOptions.USER, this.properties::getUsername, StringUtils::hasText);
            this.configureIf(optionsBuilder, urlOptions, ConnectionFactoryOptions.PASSWORD, this.properties::getPassword, StringUtils::hasText);
            this.configureIf(optionsBuilder, urlOptions, ConnectionFactoryOptions.DATABASE, () -> this.determineDatabaseName(this.properties), StringUtils::hasText);
            if (this.properties.getProperties() != null) {
                this.properties.getProperties().forEach((key, value) -> optionsBuilder.option(Option.valueOf((String)key), value));
            }
            return optionsBuilder.build();
        }

        private <T extends CharSequence> void configureIf(ConnectionFactoryOptions.Builder optionsBuilder, ConnectionFactoryOptions originalOptions, Option<T> option, Supplier<T> valueSupplier, Predicate<T> setIf) {
            if (originalOptions.hasOption(option)) {
                return;
            }
            CharSequence value = (CharSequence)valueSupplier.get();
            if (setIf.test(value)) {
                optionsBuilder.option(option, (Object)value);
            }
        }

        private String determineDatabaseName(R2dbcProperties properties) {
            if (properties.isGenerateUniqueName()) {
                return properties.determineUniqueName();
            }
            if (StringUtils.hasLength(properties.getName())) {
                return properties.getName();
            }
            return null;
        }
    }
}

