/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.lang.reflect.Array;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.classgen.asm.util.TypeUtil;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.wrappers.Wrapper;

public class ParameterTypes {
    protected volatile CachedClass[] parameterTypes;
    protected volatile Class[] nativeParamTypes;
    protected boolean isVargsMethod;

    public ParameterTypes() {
    }

    public ParameterTypes(Class[] pt) {
        this.nativeParamTypes = pt;
    }

    public ParameterTypes(String[] pt) {
        this.nativeParamTypes = new Class[pt.length];
        for (int i2 = 0; i2 != pt.length; ++i2) {
            try {
                this.nativeParamTypes[i2] = Class.forName(pt[i2]);
                continue;
            }
            catch (ClassNotFoundException e) {
                NoClassDefFoundError err = new NoClassDefFoundError();
                err.initCause(e);
                throw err;
            }
        }
    }

    public ParameterTypes(CachedClass[] pt) {
        this.setParametersTypes(pt);
    }

    protected final void setParametersTypes(CachedClass[] pt) {
        this.parameterTypes = pt;
        this.isVargsMethod = pt.length > 0 && pt[pt.length - 1].isArray;
    }

    public CachedClass[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.getParametersTypes0();
        }
        return this.parameterTypes;
    }

    private synchronized void getParametersTypes0() {
        if (this.parameterTypes == null) {
            Class[] npt;
            Class[] classArray = npt = this.nativeParamTypes == null ? this.getPT() : this.nativeParamTypes;
            if (npt.length == 0) {
                this.nativeParamTypes = MetaClassHelper.EMPTY_TYPE_ARRAY;
                this.setParametersTypes(CachedClass.EMPTY_ARRAY);
            } else {
                CachedClass[] pt = new CachedClass[npt.length];
                for (int i2 = 0; i2 != npt.length; ++i2) {
                    pt[i2] = ReflectionCache.getCachedClass(npt[i2]);
                }
                this.nativeParamTypes = npt;
                this.setParametersTypes(pt);
            }
        }
    }

    public Class[] getNativeParameterTypes() {
        if (this.nativeParamTypes == null) {
            this.getNativeParameterTypes0();
        }
        return this.nativeParamTypes;
    }

    private synchronized void getNativeParameterTypes0() {
        if (this.nativeParamTypes == null) {
            Class[] npt;
            if (this.parameterTypes == null) {
                npt = this.getPT();
            } else {
                npt = new Class[this.parameterTypes.length];
                for (int i2 = 0; i2 != this.parameterTypes.length; ++i2) {
                    npt[i2] = this.parameterTypes[i2].getTheClass();
                }
            }
            this.nativeParamTypes = npt;
        }
    }

    protected Class[] getPT() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean isVargsMethod() {
        if (this.parameterTypes == null) {
            this.getParametersTypes0();
        }
        return this.isVargsMethod;
    }

    public boolean isVargsMethod(Object[] arguments) {
        if (this.isVargsMethod()) {
            int aCount = arguments.length;
            int pCount = this.parameterTypes.length;
            if (aCount > pCount || aCount == pCount - 1) {
                return true;
            }
            if (aCount == pCount) {
                Object last = arguments[aCount - 1];
                return last == null || !last.getClass().equals(this.parameterTypes[pCount - 1].getTheClass());
            }
        }
        return false;
    }

    public final Object[] coerceArgumentsToClasses(Object[] arguments) {
        arguments = this.correctArguments(arguments);
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            Object argument = arguments[i2];
            if (argument == null) continue;
            arguments[i2] = this.parameterTypes[i2].coerceArgument(argument);
        }
        return arguments;
    }

    public Object[] correctArguments(Object[] arguments) {
        CachedClass[] pt;
        if (arguments == null) {
            arguments = MetaClassHelper.EMPTY_ARRAY;
        }
        if ((pt = this.getParameterTypes()).length == 1 && arguments.length == 0) {
            if (!this.isVargsMethod()) {
                return MetaClassHelper.ARRAY_WITH_NULL;
            }
            return new Object[]{Array.newInstance(pt[0].getTheClass().getComponentType(), 0)};
        }
        if (this.isVargsMethod(arguments)) {
            return ParameterTypes.fitToVargs(arguments, pt);
        }
        return arguments;
    }

    private static Object[] fitToVargs(Object[] argumentArrayOrig, CachedClass[] paramTypes) {
        Class<?> vargsClassOrig = paramTypes[paramTypes.length - 1].getTheClass().getComponentType();
        Class vargsClass = TypeUtil.autoboxType(vargsClassOrig);
        Object[] argumentArray = (Object[])argumentArrayOrig.clone();
        MetaClassHelper.unwrap(argumentArray);
        if (argumentArray.length == paramTypes.length - 1) {
            Object vargs;
            Object[] newArgs = new Object[paramTypes.length];
            System.arraycopy(argumentArray, 0, newArgs, 0, argumentArray.length);
            newArgs[newArgs.length - 1] = vargs = Array.newInstance(vargsClass, 0);
            return newArgs;
        }
        if (argumentArray.length == paramTypes.length) {
            Object lastArgument = argumentArray[argumentArray.length - 1];
            if (lastArgument != null && !lastArgument.getClass().isArray()) {
                Object wrapped = ParameterTypes.makeCommonArray(argumentArray, paramTypes.length - 1, vargsClass);
                Object[] newArgs = new Object[paramTypes.length];
                System.arraycopy(argumentArray, 0, newArgs, 0, paramTypes.length - 1);
                newArgs[newArgs.length - 1] = wrapped;
                return newArgs;
            }
            return argumentArray;
        }
        if (argumentArray.length > paramTypes.length) {
            Object vargs;
            Object[] newArgs = new Object[paramTypes.length];
            System.arraycopy(argumentArray, 0, newArgs, 0, paramTypes.length - 1);
            newArgs[newArgs.length - 1] = vargs = ParameterTypes.makeCommonArray(argumentArray, paramTypes.length - 1, vargsClass);
            return newArgs;
        }
        throw new GroovyBugError("trying to call a vargs method without enough arguments");
    }

    private static Object makeCommonArray(Object[] arguments, int offset, Class<?> baseType) {
        Object[] result = (Object[])Array.newInstance(baseType, arguments.length - offset);
        for (int i2 = offset; i2 < arguments.length; ++i2) {
            Object v = arguments[i2];
            result[i2 - offset] = v = DefaultTypeTransformation.castToType(v, baseType);
        }
        return result;
    }

    public boolean isValidMethod(Class[] argumentTypes) {
        if (argumentTypes == null) {
            return true;
        }
        CachedClass[] pt = this.getParameterTypes();
        int nArguments = argumentTypes.length;
        int nParameters = pt.length;
        int nthParameter = nParameters - 1;
        if (this.isVargsMethod() && nArguments >= nthParameter) {
            return ParameterTypes.isValidVargsMethod(argumentTypes, pt, nthParameter);
        }
        if (nArguments == nParameters) {
            return ParameterTypes.isValidExactMethod(argumentTypes, pt);
        }
        return nArguments == 0 && nParameters == 1 && !pt[0].isPrimitive;
    }

    private static boolean isValidExactMethod(Class[] arguments, CachedClass[] pt) {
        int size = pt.length;
        for (int i2 = 0; i2 < size; ++i2) {
            if (pt[i2].isAssignableFrom(arguments[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean isValidExactMethod(Object[] args) {
        this.getParametersTypes0();
        int size = args.length;
        if (size != this.parameterTypes.length) {
            return false;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            Object arg = args[i2];
            if (arg == null || this.parameterTypes[i2].isAssignableFrom(arg.getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean isValidExactMethod(Class[] args) {
        this.getParametersTypes0();
        int size = args.length;
        if (size != this.parameterTypes.length) {
            return false;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            Class arg = args[i2];
            if (arg == null || this.parameterTypes[i2].isAssignableFrom(arg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidVargsMethod(Class[] argumentTypes, CachedClass[] parameterTypes, int nthParameter) {
        Class argumentType;
        for (int i2 = 0; i2 < nthParameter; ++i2) {
            if (parameterTypes[i2].isAssignableFrom(argumentTypes[i2])) continue;
            return false;
        }
        CachedClass arrayType = parameterTypes[nthParameter];
        CachedClass componentType = ReflectionCache.getCachedClass(arrayType.getTheClass().getComponentType());
        if (argumentTypes.length == parameterTypes.length && (arrayType.isAssignableFrom(argumentType = argumentTypes[nthParameter]) || argumentType.isArray() && componentType.isAssignableFrom(argumentType.getComponentType()))) {
            return true;
        }
        for (int i3 = nthParameter; i3 < argumentTypes.length; ++i3) {
            if (componentType.isAssignableFrom(argumentTypes[i3])) continue;
            return false;
        }
        return true;
    }

    public boolean isValidMethod(Object[] arguments) {
        if (arguments == null) {
            return true;
        }
        CachedClass[] parameterTypes = this.getParameterTypes();
        int nArguments = arguments.length;
        int nParameters = parameterTypes.length;
        int nthParameter = nParameters - 1;
        if (nParameters > 0 && parameterTypes[nthParameter].isArray && nArguments >= nthParameter) {
            Class<?> argumentType;
            for (int i2 = 0; i2 < nthParameter; ++i2) {
                if (parameterTypes[i2].isAssignableFrom(ParameterTypes.getArgClass(arguments[i2]))) continue;
                return false;
            }
            CachedClass arrayType = parameterTypes[nthParameter];
            CachedClass componentType = ReflectionCache.getCachedClass(arrayType.getTheClass().getComponentType());
            if (nArguments == parameterTypes.length && (arrayType.isAssignableFrom(argumentType = ParameterTypes.getArgClass(arguments[nthParameter])) || argumentType.isArray() && componentType.isAssignableFrom(argumentType.getComponentType()))) {
                return true;
            }
            for (int i3 = nthParameter; i3 < nArguments; ++i3) {
                if (componentType.isAssignableFrom(ParameterTypes.getArgClass(arguments[i3]))) continue;
                return false;
            }
            return true;
        }
        if (nArguments == nParameters) {
            for (int i4 = 0; i4 < nArguments; ++i4) {
                if (parameterTypes[i4].isAssignableFrom(ParameterTypes.getArgClass(arguments[i4]))) continue;
                return false;
            }
            return true;
        }
        return nArguments == 0 && nParameters == 1 && !parameterTypes[0].isPrimitive;
    }

    private static Class<?> getArgClass(Object arg) {
        return arg == null ? null : (arg instanceof Wrapper ? ((Wrapper)arg).getType() : arg.getClass());
    }
}

