/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth.oidc.token;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.proc.JWKSecurityContext;
import com.nimbusds.jose.proc.JWSKeySelector;
import java.security.Key;
import java.util.Collections;
import java.util.List;

public class KidKeySelector
implements JWSKeySelector<JWKSecurityContext> {
    public List<? extends Key> selectJWSKeys(JWSHeader header, JWKSecurityContext ctx) {
        for (JWK key : ctx.getKeys()) {
            if (key.getKeyUse() != KeyUse.SIGNATURE || !key.getKeyID().equals(header.getKeyID())) continue;
            if (JWSAlgorithm.Family.RSA.contains((Object)header.getAlgorithm())) {
                try {
                    return Collections.singletonList(key.toRSAKey().toPublicKey());
                }
                catch (JOSEException jOSEException) {
                    // empty catch block
                }
            }
            if (!JWSAlgorithm.Family.EC.contains((Object)header.getAlgorithm())) continue;
            try {
                return Collections.singletonList(key.toECKey().toPublicKey());
            }
            catch (JOSEException jOSEException) {
            }
        }
        return Collections.emptyList();
    }
}

