/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.annotation.ManagedBean;
import jakarta.ejb.TimerService;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.openejb.JndiConstants;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.ContainerUtils;
import org.apache.openejb.config.ContextRef;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.PersistenceUnitLinkResolver;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ActivationConfigProperty;
import org.apache.openejb.jee.AdminObject;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.ConnectionDefinition;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.InboundResourceadapter;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.MessageDestination;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.MessageListener;
import org.apache.openejb.jee.OutboundResourceAdapter;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceRef;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.jee.ResourceAdapter;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.jpa.unit.TransactionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.jee.oejb3.ResourceLink;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.DataSourceFactory;
import org.apache.openejb.util.IntrospectionSupport;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LinkResolver;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URISupport;
import org.apache.openejb.util.URLs;

public class AutoConfig
implements DynamicDeployer,
JndiConstants {
    public static final String ORIGIN_ANNOTATION = "Annotation";
    public static final String ORIGIN_FLAG = "Origin";
    public static final String ORIGINAL_ID = "OriginalId";
    private static final AppResources EMPTY_APP_RESOURCES = new AppResources();
    public static Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, AutoConfig.class);
    private static final int MAX_IMPLICIT_POOL_SIZE = 5;
    private static final Set<String> ignoredReferenceTypes = new TreeSet<String>();
    public static final String AUTOCREATE_JTA_DATASOURCE_FROM_NON_JTA_ONE_KEY = "openejb.autocreate.jta-datasource-from-non-jta-one";
    private final ConfigurationFactory configFactory;
    private boolean autoCreateContainers = true;
    private boolean autoCreateResources = true;

    public AutoConfig(ConfigurationFactory configFactory) {
        this.configFactory = configFactory;
    }

    public synchronized boolean autoCreateResources() {
        return this.autoCreateResources;
    }

    public synchronized void autoCreateResources(boolean autoCreateResources) {
        this.autoCreateResources = autoCreateResources;
    }

    public synchronized boolean autoCreateContainers() {
        return this.autoCreateContainers;
    }

    public synchronized void autoCreateContainers(boolean autoCreateContainers) {
        this.autoCreateContainers = autoCreateContainers;
    }

    public void init() throws OpenEJBException {
    }

    @Override
    public synchronized AppModule deploy(AppModule appModule) throws OpenEJBException {
        List<ContainerInfo> containerInfos = ContainerUtils.getContainerInfos(appModule, this.configFactory);
        AppResources appResources = new AppResources(appModule, containerInfos);
        appResources.dump();
        this.processApplicationResources(appModule);
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.processActivationConfig(ejbModule);
        }
        this.resolveDestinationLinks(appModule);
        this.resolvePersistenceRefs(appModule);
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.deploy(ejbModule, appResources);
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            this.deploy(clientModule, appResources);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.deploy(webModule, appResources);
        }
        for (PersistenceModule persistenceModule : appModule.getPersistenceModules()) {
            this.deploy(appModule, persistenceModule);
        }
        return appModule;
    }

    private void resolvePersistenceRefs(AppModule appModule) {
        URI moduleURI;
        PersistenceUnitLinkResolver persistenceUnits = new PersistenceUnitLinkResolver(appModule);
        for (PersistenceModule module : appModule.getPersistenceModules()) {
            String rootUrl = module.getRootUrl();
            for (PersistenceUnit unit : module.getPersistence().getPersistenceUnit()) {
                unit.setId(appModule.persistenceUnitId(rootUrl, unit.getName()));
                persistenceUnits.add(rootUrl, unit.getName(), unit);
            }
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            moduleURI = ejbModule.getModuleUri();
            for (EnterpriseBean component : ejbModule.getEjbJar().getEnterpriseBeans()) {
                this.processPersistenceRefs((JndiConsumer)component, ejbModule, persistenceUnits, moduleURI);
            }
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            moduleURI = URLs.uri(clientModule.getModuleId());
            this.processPersistenceRefs((JndiConsumer)clientModule.getApplicationClient(), clientModule, persistenceUnits, moduleURI);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            moduleURI = URLs.uri(webModule.getModuleId());
            this.processPersistenceRefs((JndiConsumer)webModule.getWebApp(), webModule, persistenceUnits, moduleURI);
        }
    }

    private void processPersistenceRefs(JndiConsumer component, DeploymentModule module, LinkResolver<PersistenceUnit> persistenceUnits, URI moduleURI) {
        String componentName = component.getJndiConsumerName();
        ValidationContext validation = module.getValidation();
        for (PersistenceRef ref : component.getPersistenceUnitRef()) {
            this.processPersistenceRef(persistenceUnits, ref, moduleURI, componentName, validation);
        }
        for (PersistenceRef ref : component.getPersistenceContextRef()) {
            this.processPersistenceRef(persistenceUnits, ref, moduleURI, componentName, validation);
        }
    }

    private PersistenceUnit processPersistenceRef(LinkResolver<PersistenceUnit> persistenceUnits, PersistenceRef ref, URI moduleURI, String componentName, ValidationContext validation) {
        if (ref.getMappedName() != null && ref.getMappedName().startsWith("jndi:")) {
            return null;
        }
        PersistenceUnit unit = persistenceUnits.resolveLink(ref.getPersistenceUnitName(), moduleURI);
        Collection<PersistenceUnit> cmpUnits = persistenceUnits.values("cmp");
        if (unit == null && cmpUnits.size() > 0 && persistenceUnits.values().size() - cmpUnits.size() == 1) {
            for (PersistenceUnit persistenceUnit : persistenceUnits.values()) {
                if (persistenceUnit.getName().equals("cmp")) continue;
                unit = persistenceUnit;
                break;
            }
        }
        if (unit == null) {
            unit = persistenceUnits.resolveLink(ref.getName(), moduleURI);
        }
        if (unit == null) {
            String shortName = ref.getName().replaceFirst(".*/", "");
            unit = persistenceUnits.resolveLink(shortName, moduleURI);
        }
        if (unit != null) {
            ref.setPersistenceUnitName(unit.getName());
            ref.setMappedName(unit.getId());
        } else {
            Object refType = "persistence";
            refType = ref instanceof PersistenceContextRef ? (String)refType + "ContextRef" : (String)refType + "UnitRef";
            String refShortName = ref.getName();
            if (refShortName.matches(".*\\..*/.*")) {
                refShortName = refShortName.replaceFirst(".*/", "");
            }
            ArrayList<String> availableUnits = new ArrayList<String>();
            for (PersistenceUnit persistenceUnit : persistenceUnits.values()) {
                availableUnits.add(persistenceUnit.getName());
            }
            Collections.sort(availableUnits);
            String unitName = ref.getPersistenceUnitName();
            if (availableUnits.size() == 0) {
                if (unitName == null) {
                    unitName = refShortName;
                }
                validation.fail(componentName, (String)refType + ".noPersistenceUnits", refShortName, unitName);
            } else if ((ref.getPersistenceUnitName() == null || ref.getPersistenceUnitName().length() == 0) && availableUnits.size() > 1) {
                String sampleUnitName = (String)availableUnits.get(0);
                validation.fail(componentName, (String)refType + ".noUnitName", refShortName, Join.join(", ", availableUnits), sampleUnitName);
            } else {
                Collection<PersistenceUnit> vagueMatches = persistenceUnits.values(ref.getPersistenceUnitName());
                if (vagueMatches.size() != 0) {
                    ArrayList<String> possibleUnits = new ArrayList<String>();
                    for (PersistenceUnit persistenceUnit : persistenceUnits.values()) {
                        try {
                            URI unitURI = URLs.uri(persistenceUnit.getId());
                            unitURI = URISupport.relativize(moduleURI, unitURI);
                            possibleUnits.add(unitURI.toString());
                        }
                        catch (Exception e) {
                            possibleUnits.add(persistenceUnit.getId());
                        }
                    }
                    Collections.sort(possibleUnits);
                    validation.fail(componentName, (String)refType + ".vagueMatches", refShortName, unitName, possibleUnits.size(), Join.join("\n", possibleUnits));
                } else {
                    validation.fail(componentName, (String)refType + ".noMatches", refShortName, unitName, Join.join(", ", availableUnits));
                }
            }
        }
        return unit;
    }

    private void processActivationConfig(EjbModule ejbModule) throws OpenEJBException {
        OpenejbJar openejbJar;
        if (ejbModule.getOpenejbJar() != null) {
            openejbJar = ejbModule.getOpenejbJar();
        } else {
            openejbJar = new OpenejbJar();
            ejbModule.setOpenejbJar(openejbJar);
        }
        Map deployments = openejbJar.getDeploymentsByEjbName();
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            String destinationType;
            ResourceLink link;
            if (!(bean instanceof MessageDrivenBean)) continue;
            MessageDrivenBean mdb = (MessageDrivenBean)bean;
            if (mdb.getActivationConfig() == null) {
                mdb.setActivationConfig(new ActivationConfig());
            }
            if (!this.isJms(mdb)) continue;
            EjbDeployment ejbDeployment = (EjbDeployment)deployments.get(bean.getEjbName());
            if (ejbDeployment == null) {
                throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
            }
            Properties properties = mdb.getActivationConfig().toProperties();
            String destination = properties.getProperty("destinationName", properties.getProperty("destinationLookup"));
            if (destination != null) {
                if (destination.startsWith("openejb:Resource/")) {
                    destination = destination.substring("openejb:Resource/".length());
                }
                if (destination.startsWith("java:openejb/Resource/")) {
                    destination = destination.substring("java:openejb/Resource/".length());
                }
                mdb.getActivationConfig().addProperty("destination", destination);
                List list = mdb.getActivationConfig().getActivationConfigProperty();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ActivationConfigProperty configProperty = (ActivationConfigProperty)iterator.next();
                    String activationConfigPropertyName = configProperty.getActivationConfigPropertyName();
                    if (!activationConfigPropertyName.equals("destinationName") && !activationConfigPropertyName.equals("destinationLookup")) continue;
                    iterator.remove();
                    break;
                }
            } else {
                destination = properties.getProperty("destination");
            }
            if (destination == null) {
                destination = properties.getProperty("destinationLookup");
            }
            if (destination == null) {
                destination = ejbDeployment.getDeploymentId();
                mdb.getActivationConfig().addProperty("destination", destination);
            }
            if ((link = ejbDeployment.getResourceLink("openejb/destination")) == null && mdb.getMessageDestinationLink() == null) {
                link = new ResourceLink();
                link.setResId(destination);
                link.setResRefName("openejb/destination");
                ejbDeployment.addResourceLink(link);
            }
            if ((destinationType = properties.getProperty("destinationType")) == null && mdb.getMessageDestinationType() != null) {
                destinationType = mdb.getMessageDestinationType();
                mdb.getActivationConfig().addProperty("destinationType", destinationType);
            }
            if (mdb.getMessageDestinationType() == null) {
                mdb.setMessageDestinationType(destinationType);
            }
            if (!"jakarta.jms.Topic".equals(destinationType)) continue;
            if (Boolean.parseBoolean(SystemInstance.get().getProperty("openejb.activemq.deploymentId-as-clientId", ejbModule.getProperties().getProperty("openejb.activemq.deploymentId-as-clientId", "true"))) && !properties.containsKey("clientId")) {
                mdb.getActivationConfig().addProperty("clientId", ejbDeployment.getDeploymentId());
            }
            if (properties.containsKey("subscriptionName")) continue;
            mdb.getActivationConfig().addProperty("subscriptionName", ejbDeployment.getDeploymentId() + "_subscription");
        }
    }

    private boolean isJms(MessageDrivenBean mdb) {
        String messagingType = mdb.getMessagingType();
        return messagingType != null && messagingType.startsWith("jakarta.jms");
    }

    private void resolveDestinationLinks(AppModule appModule) throws OpenEJBException {
        String destinationId;
        URI moduleUri;
        Object ejbDeployment;
        MessageDrivenBean mdb;
        OpenejbJar openejbJar;
        Object moduleUri2;
        AssemblyDescriptor assembly;
        LinkResolver<MessageDestination> destinationResolver = new LinkResolver<MessageDestination>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            AssemblyDescriptor assembly2 = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assembly2 == null) continue;
            for (MessageDestination destination : assembly2.getMessageDestination()) {
                destinationResolver.add(ejbModule.getModuleUri(), destination.getMessageDestinationName(), destination);
            }
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            for (MessageDestination destination : clientModule.getApplicationClient().getMessageDestination()) {
                destinationResolver.add(appModule.getModuleUri(), destination.getMessageDestinationName(), destination);
            }
        }
        for (WebModule webModule : appModule.getWebModules()) {
            for (MessageDestination destination : webModule.getWebApp().getMessageDestination()) {
                destinationResolver.add(appModule.getModuleUri(), destination.getMessageDestinationName(), destination);
            }
        }
        HashMap<MessageDestination, String> destinationTypes = new HashMap<MessageDestination, String>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            assembly = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assembly == null) continue;
            moduleUri2 = ejbModule.getModuleUri();
            openejbJar = ejbModule.getOpenejbJar();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                ResourceLink resourceLink;
                if (!(bean instanceof MessageDrivenBean)) continue;
                mdb = (MessageDrivenBean)bean;
                ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
                if (ejbDeployment == null) {
                    throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
                }
                String link = mdb.getMessageDestinationLink();
                if (link == null || link.length() == 0) continue;
                MessageDestination destination = destinationResolver.resolveLink(link, (URI)moduleUri2);
                if (destination == null) {
                    throw new OpenEJBException("Message destination " + link + " for message driven bean " + mdb.getEjbName() + " not found");
                }
                String destinationId2 = destination.getMappedName();
                if (destinationId2 == null) {
                    Properties properties = mdb.getActivationConfig().toProperties();
                    destinationId2 = properties.getProperty("destination");
                    destination.setMappedName(destinationId2);
                }
                if (mdb.getMessageDestinationType() != null && !destinationTypes.containsKey(destination)) {
                    destinationTypes.put(destination, mdb.getMessageDestinationType());
                }
                if ((resourceLink = ejbDeployment.getResourceLink("openejb/destination")) == null) {
                    resourceLink = new ResourceLink();
                    resourceLink.setResRefName("openejb/destination");
                    ejbDeployment.addResourceLink(resourceLink);
                }
                resourceLink.setResId(destinationId2);
            }
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            assembly = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assembly == null) continue;
            moduleUri2 = ejbModule.getModuleUri();
            openejbJar = ejbModule.getOpenejbJar();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                EjbDeployment ejbDeployment2 = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
                if (ejbDeployment2 == null) {
                    throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
                }
                for (MessageDestinationRef ref : bean.getMessageDestinationRef()) {
                    String destinationId3;
                    if (ref.getMappedName() != null || ejbDeployment2.getResourceLink(ref.getName()) != null || (destinationId3 = this.resolveDestinationId(ref, appModule, (URI)moduleUri2, destinationResolver, destinationTypes)) == null) continue;
                    ResourceLink resourceLink = new ResourceLink();
                    resourceLink.setResId(destinationId3);
                    resourceLink.setResRefName(ref.getName());
                    ejbDeployment2.addResourceLink(resourceLink);
                }
            }
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            moduleUri = clientModule.getModuleUri();
            for (MessageDestinationRef ref : clientModule.getApplicationClient().getMessageDestinationRef()) {
                destinationId = this.resolveDestinationId(ref, appModule, moduleUri, destinationResolver, destinationTypes);
                if (destinationId == null) continue;
                ref.setMappedName(destinationId);
            }
        }
        for (WebModule webModule : appModule.getWebModules()) {
            moduleUri = URLs.uri(webModule.getModuleId());
            for (MessageDestinationRef ref : webModule.getWebApp().getMessageDestinationRef()) {
                destinationId = this.resolveDestinationId(ref, appModule, moduleUri, destinationResolver, destinationTypes);
                if (destinationId == null) continue;
                ref.setMappedName(destinationId);
            }
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            assembly = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assembly == null) continue;
            moduleUri2 = URLs.uri(ejbModule.getModuleId());
            openejbJar = ejbModule.getOpenejbJar();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                Properties properties;
                if (!(bean instanceof MessageDrivenBean) || !this.isJms(mdb = (MessageDrivenBean)bean)) continue;
                ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
                if (ejbDeployment == null) {
                    throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
                }
                String destinationType = mdb.getMessageDestinationType();
                if (destinationType != null) continue;
                String link = mdb.getMessageDestinationLink();
                if (link != null && link.length() != 0) {
                    MessageDestination destination = destinationResolver.resolveLink(link, (URI)moduleUri2);
                    if (destination == null) {
                        throw new OpenEJBException("Message destination " + link + " for message driven bean " + mdb.getEjbName() + " not found");
                    }
                    destinationType = (String)destinationTypes.get(destination);
                }
                if (destinationType == null) {
                    properties = mdb.getActivationConfig().toProperties();
                    String destination = properties.getProperty("destination").toLowerCase();
                    destinationType = destination.contains("queue") ? Queue.class.getName() : (destination.contains("topic") ? Topic.class.getName() : Queue.class.getName());
                    logger.info("Auto-configuring a message driven bean " + ejbDeployment.getDeploymentId() + " destination " + properties.getProperty("destination") + " to be destinationType " + destinationType);
                }
                if (destinationType == null) continue;
                mdb.getActivationConfig().addProperty("destinationType", destinationType);
                mdb.setMessageDestinationType(destinationType);
                if (!"jakarta.jms.Topic".equals(destinationType)) continue;
                properties = mdb.getActivationConfig().toProperties();
                if (!properties.containsKey("clientId")) {
                    mdb.getActivationConfig().addProperty("clientId", ejbDeployment.getDeploymentId());
                }
                if (properties.containsKey("subscriptionName")) continue;
                mdb.getActivationConfig().addProperty("subscriptionName", ejbDeployment.getDeploymentId() + "_subscription");
            }
        }
    }

    private String resolveDestinationId(MessageDestinationRef ref, AppModule appModule, URI moduleUri, LinkResolver<MessageDestination> destinationResolver, Map<MessageDestination, String> destinationTypes) throws OpenEJBException {
        String destinationId;
        String link = ref.getMessageDestinationLink();
        if (link == null || link.length() == 0) {
            return null;
        }
        MessageDestination destination = destinationResolver.resolveLink(link, moduleUri);
        if (destination == null && link.contains("#")) {
            List<EjbModule> ejbModules = appModule.getEjbModules();
            for (EjbModule ejbModule : ejbModules) {
                String appModuleLink;
                String shortModuleName = link.substring(0, link.indexOf("#"));
                if (!ejbModule.getModuleUri().toString().endsWith(shortModuleName) || (destination = destinationResolver.resolveLink(appModuleLink = String.valueOf(ejbModule.getModuleUri()) + "#" + link.substring(link.indexOf("#") + 1), moduleUri)) == null) continue;
                break;
            }
        }
        if (destination == null) {
            throw new OpenEJBException("Message destination " + link + " for message-destination-ref " + ref.getMessageDestinationRefName() + " not found");
        }
        if (ref.getMessageDestinationType() != null && !destinationTypes.containsKey(destination)) {
            destinationTypes.put(destination, ref.getMessageDestinationType());
        }
        if ((destinationId = destination.getMappedName()) == null) {
            destination.getMessageDestinationName();
        }
        return destinationId;
    }

    private void deploy(ClientModule clientModule, AppResources appResources) throws OpenEJBException {
        this.processJndiRefs(clientModule.getModuleId(), (JndiConsumer)clientModule.getApplicationClient(), appResources, clientModule.getClassLoader());
    }

    private void deploy(WebModule webModule, AppResources appResources) throws OpenEJBException {
        this.processJndiRefs(webModule.getModuleId(), (JndiConsumer)webModule.getWebApp(), appResources, webModule.getClassLoader());
    }

    private void processJndiRefs(String moduleId, JndiConsumer jndiConsumer, AppResources appResources, ClassLoader classLoader) throws OpenEJBException {
        String destinationId;
        String refType;
        String mappedName;
        for (ResourceRef ref : jndiConsumer.getResourceRef()) {
            if (ref.getLookupName() != null || (mappedName = ref.getMappedName() == null ? "" : ref.getMappedName()).startsWith("jndi:") || this.isIgnoredReferenceType(refType = this.getType((JndiReference)ref, classLoader), classLoader)) continue;
            destinationId = mappedName.length() == 0 ? ref.getName() : mappedName;
            try {
                destinationId = this.getResourceId(moduleId, destinationId, refType, appResources);
            }
            catch (OpenEJBException ex) {
                if (ref instanceof ContextRef) continue;
                throw ex;
            }
            ref.setMappedName(destinationId);
        }
        for (ResourceRef ref : jndiConsumer.getResourceEnvRef()) {
            if (ref.getLookupName() != null || (mappedName = ref.getMappedName() == null ? "" : ref.getMappedName()).startsWith("jndi:") || this.isIgnoredReferenceType(refType = this.getType((JndiReference)ref, classLoader), classLoader)) continue;
            destinationId = mappedName.length() == 0 ? ref.getName() : mappedName;
            destinationId = this.getResourceEnvId(moduleId, destinationId, refType, appResources);
            ref.setMappedName(destinationId);
        }
        for (ResourceRef ref : jndiConsumer.getMessageDestinationRef()) {
            if (ref.getLookupName() != null || (mappedName = ref.getMappedName() == null ? "" : ref.getMappedName()).startsWith("jndi:")) continue;
            String destinationId2 = mappedName.length() == 0 ? ref.getName() : mappedName;
            destinationId2 = this.getResourceEnvId(moduleId, destinationId2, ref.getType(), appResources);
            ref.setMappedName(destinationId2);
        }
    }

    private boolean isIgnoredReferenceType(String typeName, ClassLoader loader) {
        if (ignoredReferenceTypes.contains(typeName)) {
            return true;
        }
        if (loader != null) {
            try {
                Class<?> type = loader.loadClass(typeName);
                return type.isAnnotationPresent(ManagedBean.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private void deploy(EjbModule ejbModule, AppResources appResources) throws OpenEJBException {
        OpenejbJar openejbJar;
        if (ejbModule.getOpenejbJar() != null) {
            openejbJar = ejbModule.getOpenejbJar();
        } else {
            openejbJar = new OpenejbJar();
            ejbModule.setOpenejbJar(openejbJar);
        }
        Map deployments = openejbJar.getDeploymentsByEjbName();
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            EjbDeployment ejbDeployment = (EjbDeployment)deployments.get(bean.getEjbName());
            if (ejbDeployment == null) {
                throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
            }
            String beanType = AutoConfig.getType(bean);
            Class<? extends ContainerInfo> containerInfoType = ConfigurationFactory.getContainerInfoType(beanType);
            logger.debug("Bean type of bean {0} is {1}", bean.getEjbName(), beanType);
            if (ejbDeployment.getContainerId() == null && !AutoConfig.skipMdb(bean)) {
                logger.debug("Container for bean {0} is not set, looking for a suitable container", bean.getEjbName());
                String containerId = this.getUsableContainer(containerInfoType, bean, appResources);
                if (containerId == null) {
                    logger.debug("Suitable container for bean {0} not found, creating one", bean.getEjbName());
                    containerId = this.createContainer(containerInfoType, ejbDeployment, bean);
                }
                logger.debug("Setting container ID {0} for bean {1}", containerId, bean.getEjbName());
                ejbDeployment.setContainerId(containerId);
            }
            logger.debug("Container ID for bean {0} is {1}", bean.getEjbName(), ejbDeployment.getContainerId());
            List<String> containerIds = this.configFactory.getContainerIds();
            Collection<ContainerInfo> containerInfos = appResources.getContainerInfos();
            for (ContainerInfo containerInfo : containerInfos) {
                containerIds.add(containerInfo.id);
            }
            if (!containerIds.contains(ejbDeployment.getContainerId()) && !AutoConfig.skipMdb(bean)) {
                logger.debug("Desired container {0} not found. Containers available: {1}. Creating a new container.", ejbDeployment.getContainerId(), Join.join(", ", containerIds));
                this.createContainer(containerInfoType, ejbDeployment, bean);
            }
            for (ResourceRef ref : bean.getResourceRef()) {
                this.processResourceRef(ref, ejbDeployment, appResources, ejbModule);
            }
            for (ResourceRef ref : bean.getResourceEnvRef()) {
                this.processResourceEnvRef((JndiReference)ref, ejbDeployment, appResources, ejbModule.getClassLoader());
            }
            for (ResourceRef ref : bean.getMessageDestinationRef()) {
                this.processResourceEnvRef((JndiReference)ref, ejbDeployment, appResources, ejbModule.getClassLoader());
            }
            if (!this.autoCreateResources || !(bean instanceof MessageDrivenBean)) continue;
            MessageDrivenBean mdb = (MessageDrivenBean)bean;
            ResourceLink resourceLink = ejbDeployment.getResourceLink("openejb/destination");
            if (resourceLink == null) continue;
            try {
                String destinationId = this.getResourceEnvId(bean.getEjbName(), resourceLink.getResId(), mdb.getMessageDestinationType(), appResources);
                resourceLink.setResId(destinationId);
            }
            catch (OpenEJBException e) {
                ejbDeployment.removeResourceLink("openejb/destination");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processApplicationResources(AppModule module) throws OpenEJBException {
        Collection<Resource> resources = module.getResources();
        if (resources.size() == 0) {
            return;
        }
        ArrayList<WebApp> jndiConsumers = new ArrayList<WebApp>();
        for (WebModule webModule : module.getWebModules()) {
            WebApp consumer = webModule.getWebApp();
            jndiConsumers.add(consumer);
        }
        for (EjbModule ejbModule : module.getEjbModules()) {
            Collections.addAll(jndiConsumers, ejbModule.getEjbJar().getEnterpriseBeans());
        }
        List<ResourceInfo> resourceInfos = new ArrayList<ResourceInfo>();
        HashMap<ResourceInfo, Resource> resourcesMap = new HashMap<ResourceInfo, Resource>(resources.size());
        for (Resource resource : resources) {
            String url;
            boolean shouldGenerateJdbcUrl;
            String originalId = PropertyPlaceHolderHelper.value(resource.getId());
            String modulePrefix = module.getModuleId() + "/";
            if ("/".equals(modulePrefix) || originalId.startsWith("global") || originalId.startsWith("/global")) {
                resource.setId(this.replaceJavaAndSlash(originalId));
            } else {
                resource.getProperties().setProperty(ORIGINAL_ID, originalId);
                resource.setId(modulePrefix + this.replaceJavaAndSlash(originalId));
            }
            resource.setJndi(PropertyPlaceHolderHelper.value(resource.getJndi()));
            Thread thread = Thread.currentThread();
            ClassLoader oldCl = thread.getContextClassLoader();
            thread.setContextClassLoader(module.getClassLoader());
            try {
                resource.getProperties().putAll((Map<?, ?>)PropertyPlaceHolderHelper.holds(resource.getProperties()));
            }
            finally {
                thread.setContextClassLoader(oldCl);
            }
            List<String> aliases = resource.getAliases();
            if (!aliases.isEmpty()) {
                ArrayList<CallSite> newAliases = new ArrayList<CallSite>();
                for (String s : aliases) {
                    newAliases.add((CallSite)((Object)(module.getModuleId() + "/" + s)));
                }
                resource.getAliases().clear();
                resource.getAliases().addAll(newAliases);
            }
            Properties properties = resource.getProperties();
            if (DataSource.class.getName().equals(resource.getType()) || DataSource.class.getSimpleName().equals(resource.getType())) {
                DataSourceFactory.trimNotSupportedDataSourceProperties(properties);
            }
            boolean bl = shouldGenerateJdbcUrl = DataSource.class.getName().equals(resource.getType()) && resource.getProperties().containsKey(ORIGIN_FLAG) && resource.getProperties().getProperty(ORIGIN_FLAG).equals(ORIGIN_ANNOTATION);
            if (shouldGenerateJdbcUrl && properties.get("JdbcUrl") == null && (url = AutoConfig.getVendorUrl(properties)) != null) {
                properties.put("JdbcUrl", url);
            }
            ResourceInfo resourceInfo = this.configFactory.configureService(resource, ResourceInfo.class);
            resourceInfo.originAppName = module.getModuleId();
            ResourceRef resourceRef = new ResourceRef();
            resourceRef.setResType(AutoConfig.chooseType(module.getClassLoader(), resourceInfo, resource.getType()));
            if (shouldGenerateJdbcUrl) {
                properties.remove(ORIGIN_FLAG);
                resourceRef.setResRefName(this.dataSourceLookupName(resource));
            } else {
                resourceRef.setResRefName("openejb/Resource/" + resourceInfo.id);
            }
            resourceRef.setMappedName(resourceInfo.id);
            ResourceRef strictRef = new ResourceRef("openejb/Resource/" + originalId, resourceRef.getResType(), resourceRef.getResAuth(), resourceRef.getResSharingScope());
            strictRef.setMappedName(resourceInfo.id);
            for (JndiConsumer jndiConsumer : jndiConsumers) {
                AutoConfig.addResource(jndiConsumer, resourceRef);
                if ("/".equals(modulePrefix)) continue;
                AutoConfig.addResource(jndiConsumer, strictRef);
            }
            resourceInfos.add(resourceInfo);
            resourcesMap.put(resourceInfo, resource);
        }
        resourceInfos = ConfigurationFactory.sort(resourceInfos, module.getModuleId() + "/");
        for (ResourceInfo resourceInfo : resourceInfos) {
            int originalSize = resourceInfo.aliases.size();
            String id = this.installResource(module.getModuleId(), resourceInfo);
            Resource resource = (Resource)resourcesMap.remove(resourceInfo);
            resource.setId(id);
            if (resourceInfo.aliases.size() <= originalSize) continue;
            resource.getAliases().add(resourceInfo.aliases.get(resourceInfo.aliases.size() - 1));
        }
        resourceInfos.clear();
    }

    private static void addResource(JndiConsumer consumer, ResourceRef resourceRef) {
        ResourceRef existing = (ResourceRef)consumer.getResourceRefMap().get(resourceRef.getKey());
        if (existing != null) {
            existing.setMappedName(resourceRef.getMappedName());
        } else {
            consumer.getResourceRef().add(resourceRef);
        }
    }

    private static String chooseType(ClassLoader classLoader, ResourceInfo info, String defaultType) {
        if (info.types != null) {
            for (String type : info.types) {
                if (!AutoConfig.canLoad(classLoader, type)) continue;
                return type;
            }
        }
        return info.className != null ? (AutoConfig.canLoad(classLoader, info.className) ? info.className : defaultType) : defaultType;
    }

    private static boolean canLoad(ClassLoader classLoader, String type) {
        try {
            classLoader.loadClass(type);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String dataSourceLookupName(Resource datasource) {
        String jndi = datasource.getJndi();
        if (jndi.startsWith("java:")) {
            return jndi.startsWith("/") ? jndi.substring(1) : jndi;
        }
        if (jndi.startsWith("comp/env/")) {
            return "java:" + jndi;
        }
        if (jndi.startsWith("module/")) {
            return "java:" + jndi;
        }
        if (jndi.startsWith("global/")) {
            return "java:" + jndi;
        }
        if (jndi.startsWith("app/")) {
            return "java:" + jndi;
        }
        return "java:comp/env/" + jndi;
    }

    private static String getVendorUrl(Properties properties) {
        String driver = properties.getProperty("JdbcDriver");
        String serverName = properties.getProperty("ServerName");
        int port = AutoConfig.getInt(properties.get("PortNumber"));
        boolean remote = port != -1;
        String databaseName = properties.getProperty("DatabaseName");
        if (driver == null || driver.equals("org.hsqldb.jdbcDriver")) {
            if (remote) {
                return String.format("jdbc:hsqldb:hsql://%s:%s/%s", serverName, port, databaseName);
            }
            return String.format("jdbc:hsqldb:mem:%s", databaseName);
        }
        if (driver.startsWith("org.apache.derby.jdbc.Embedded")) {
            return String.format("jdbc:derby:%s%s", databaseName, properties.getProperty("connectionAttributes", ";create=true"));
        }
        if (driver.equals("org.apache.derby.jdbc.ClientDriver")) {
            return String.format("jdbc:derby://%s:%s/%s%s", serverName, port, databaseName, properties.getProperty("connectionAttributes", ";create=true"));
        }
        if (driver.equals("com.mysql.jdbc.Driver")) {
            return String.format("jdbc:mysql://%s:%s/%s", serverName, port, databaseName);
        }
        if (driver.startsWith("com.postgresql") || driver.startsWith("org.postgresql")) {
            return String.format("jdbc:postgresql://%s:%s/%s", serverName, port, databaseName);
        }
        if (driver.equals("oracle.jdbc.OracleDriver")) {
            return String.format("jdbc:oracle:thin:@//%s:%s/%s", serverName, port, databaseName);
        }
        return null;
    }

    private static int getInt(Object number) {
        try {
            return (Integer)number;
        }
        catch (Exception e) {
            try {
                return Integer.parseInt(String.valueOf(number));
            }
            catch (NumberFormatException e1) {
                return -1;
            }
        }
    }

    private String createContainer(Class<? extends ContainerInfo> containerInfoType, EjbDeployment ejbDeployment, EnterpriseBean bean) throws OpenEJBException {
        String newResourceId;
        if (!this.autoCreateContainers) {
            throw new OpenEJBException("A container of type " + AutoConfig.getType(bean) + " must be declared in the configuration file for bean: " + bean.getEjbName());
        }
        ContainerInfo containerInfo = this.configFactory.configureService(containerInfoType);
        logger.info("Auto-creating a container for bean " + ejbDeployment.getDeploymentId() + ": Container(type=" + AutoConfig.getType(bean) + ", id=" + containerInfo.id + ")");
        String resourceAdapterId = containerInfo.properties.getProperty("ResourceAdapter");
        if (resourceAdapterId != null && resourceAdapterId.equals(newResourceId = this.getResourceId(ejbDeployment.getDeploymentId(), resourceAdapterId, null, null))) {
            containerInfo.properties.setProperty("ResourceAdapter", newResourceId);
        }
        this.configFactory.install(containerInfo);
        return containerInfo.id;
    }

    private void processResourceRef(ResourceRef ref, EjbDeployment ejbDeployment, AppResources appResources, EjbModule ejbModule) throws OpenEJBException {
        block14: {
            String mappedName;
            if (ref.getLookupName() != null) {
                return;
            }
            String string = mappedName = ref.getMappedName() == null ? "" : ref.getMappedName();
            if (mappedName.startsWith("jndi:")) {
                return;
            }
            String refName = ref.getName();
            String refType = this.getType((JndiReference)ref, ejbModule.getClassLoader());
            if (ignoredReferenceTypes.contains(refType)) {
                ResourceInfo resourceInfo = this.configFactory.getResourceInfo(refName.replace("java:", "").replace("comp/env/", ""));
                if (resourceInfo != null) {
                    ref.setMappedName("jndi:" + (String)(resourceInfo.id.startsWith("java:") ? resourceInfo.id : "openejb:Resource/" + resourceInfo.id));
                }
                return;
            }
            try {
                Class<?> clazz = ejbModule.getClassLoader().loadClass(refType);
                if (clazz.isAnnotationPresent(ManagedBean.class)) {
                    return;
                }
            }
            catch (Throwable clazz) {
                // empty catch block
            }
            try {
                ResourceLink link = ejbDeployment.getResourceLink(refName);
                if (link == null) {
                    String id;
                    String string2 = id = mappedName.length() == 0 ? ref.getName() : mappedName;
                    if (id.startsWith("java:")) {
                        id = id.substring("java:".length());
                    }
                    if (id.startsWith("/")) {
                        id = id.substring(1);
                    }
                    try {
                        String newId;
                        AppModule appModule = ejbModule.getAppModule();
                        id = appModule != null ? ((newId = this.findResourceId(appModule.getModuleId() + "/" + id.replace("java:", "").replaceAll("^comp/env/", ""), refType, new Properties(), appResources)) != null ? this.getResourceId(ejbModule.getModuleId(), newId, refType, appResources) : this.getResourceId(ejbDeployment.getDeploymentId(), id, refType, appResources)) : this.getResourceId(ejbDeployment.getDeploymentId(), id, refType, appResources);
                    }
                    catch (OpenEJBException e) {
                        throw new OpenEJBException("Can't find resource for " + ref.getOrigin() + ". (" + e.getMessage() + ")", e.getCause());
                    }
                    logger.info("Auto-linking resource-ref '" + refName + "' in bean " + ejbDeployment.getDeploymentId() + " to Resource(id=" + id + ")");
                    link = new ResourceLink();
                    link.setResId(id);
                    link.setResRefName(refName);
                    ejbDeployment.addResourceLink(link);
                    break block14;
                }
                String id = this.getResourceId(ejbDeployment.getDeploymentId(), link.getResId(), refType, appResources);
                link.setResId(id);
                link.setResRefName(refName);
            }
            catch (OpenEJBException ex) {
                if (ref instanceof ContextRef) break block14;
                throw ex;
            }
        }
    }

    private void processResourceEnvRef(JndiReference ref, EjbDeployment ejbDeployment, AppResources appResources, ClassLoader classLoader) throws OpenEJBException {
        String mappedName;
        if (ref.getLookupName() != null) {
            return;
        }
        String string = mappedName = ref.getMappedName() == null ? "" : ref.getMappedName();
        if (mappedName.startsWith("jndi:")) {
            return;
        }
        String refName = ref.getName();
        String refType = this.getType(ref, classLoader);
        if (this.isIgnoredReferenceType(refType, classLoader)) {
            return;
        }
        ResourceLink link = ejbDeployment.getResourceLink(refName);
        if (link == null) {
            String id = mappedName.length() == 0 ? refName : mappedName;
            id = this.getResourceEnvId(ejbDeployment.getDeploymentId(), id, refType, appResources);
            if (id == null) {
                return;
            }
            logger.info("Auto-linking resource-env-ref '" + refName + "' in bean " + ejbDeployment.getDeploymentId() + " to Resource(id=" + id + ")");
            link = new ResourceLink();
            link.setResId(id);
            link.setResRefName(refName);
            ejbDeployment.addResourceLink(link);
        } else {
            String id = this.getResourceEnvId(ejbDeployment.getDeploymentId(), link.getResId(), refType, appResources);
            link.setResId(id);
            link.setResRefName(refName);
        }
    }

    private String getType(JndiReference ref, ClassLoader classLoader) throws OpenEJBException {
        String refType = ref.getType();
        if (refType != null) {
            return refType;
        }
        if (classLoader != null) {
            Set injections = ref.getInjectionTarget();
            for (InjectionTarget injection : injections) {
                try {
                    Class<?> target = classLoader.loadClass(injection.getInjectionTargetClass().trim());
                    Class type = IntrospectionSupport.getPropertyType(target, injection.getInjectionTargetName().trim());
                    return type.getName();
                }
                catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
                }
            }
        }
        throw new OpenEJBException("Unable to infer type for " + (String)ref.getKey());
    }

    private static boolean skipMdb(Object bean) {
        return bean instanceof MessageDrivenBean && SystemInstance.get().hasProperty("openejb.geronimo");
    }

    private static String getType(EnterpriseBean enterpriseBean) throws OpenEJBException {
        if (enterpriseBean instanceof EntityBean) {
            if (((EntityBean)enterpriseBean).getPersistenceType() == PersistenceType.CONTAINER) {
                return "CMP_ENTITY";
            }
            return "BMP_ENTITY";
        }
        if (enterpriseBean instanceof SessionBean) {
            if (((SessionBean)enterpriseBean).getSessionType() == SessionType.STATEFUL) {
                return "STATEFUL";
            }
            if (((SessionBean)enterpriseBean).getSessionType() == SessionType.SINGLETON) {
                return "SINGLETON";
            }
            if (((SessionBean)enterpriseBean).getSessionType() == SessionType.MANAGED) {
                return "MANAGED";
            }
            return "STATELESS";
        }
        if (enterpriseBean instanceof MessageDrivenBean) {
            return "MESSAGE";
        }
        throw new OpenEJBException("Unknown enterprise bean type " + enterpriseBean.getClass().getName());
    }

    private void deploy(AppModule app, PersistenceModule persistenceModule) throws OpenEJBException {
        if (!this.autoCreateResources) {
            return;
        }
        Persistence persistence = persistenceModule.getPersistence();
        for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
            Object potentialName2;
            boolean resourceLocal;
            if (unit.getProvider() != null) {
                logger.info("Configuring PersistenceUnit(name=" + unit.getName() + ", provider=" + unit.getProvider() + ")");
            } else {
                logger.info("Configuring PersistenceUnit(name=" + unit.getName() + ")");
            }
            if (unit.getJtaDataSource() == null && unit.getNonJtaDataSource() == null && "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.force-unit-type", unit.getProperty("openejb.force-unit-type", "true")))) {
                unit.setTransactionType(TransactionType.JTA);
            }
            boolean bl = resourceLocal = TransactionType.RESOURCE_LOCAL.equals((Object)unit.getTransactionType()) && unit.getJtaDataSource() == null;
            if (resourceLocal && unit.getNonJtaDataSource() == null && this.isDataSourcePropertiesConfigured(unit.getProperties())) continue;
            Properties required = new Properties();
            if ("org.apache.openjpa.persistence.PersistenceProviderImpl".equals(unit.getProvider())) {
                if (unit.getJtaDataSource() == null) {
                    unit.setJtaDataSource(unit.getProperty("openjpa.ConnectionFactoryName"));
                }
                if (unit.getNonJtaDataSource() == null) {
                    unit.setNonJtaDataSource(unit.getProperty("openjpa.ConnectionFactory2Name"));
                }
            }
            logger.debug("raw <jta-data-source>" + unit.getJtaDataSource() + "</jta-datasource>");
            logger.debug("raw <non-jta-data-source>" + unit.getNonJtaDataSource() + "</non-jta-datasource>");
            String originalJtaDataSource = unit.getJtaDataSource();
            unit.setJtaDataSource(AutoConfig.normalizeResourceId(originalJtaDataSource));
            String originalNonJtaDataSource = unit.getNonJtaDataSource();
            unit.setNonJtaDataSource(AutoConfig.normalizeResourceId(originalNonJtaDataSource));
            logger.debug("normalized <jta-data-source>" + unit.getJtaDataSource() + "</jta-datasource>");
            logger.debug("normalized <non-jta-data-source>" + unit.getNonJtaDataSource() + "</non-jta-datasource>");
            if (logger.isDebugEnabled()) {
                required.put("JtaManaged", "true");
                List<String> managed = this.configFactory.getResourceIds("DataSource", required);
                required.put("JtaManaged", "false");
                List<String> unmanaged = this.configFactory.getResourceIds("DataSource", required);
                required.clear();
                List<String> unknown = this.configFactory.getResourceIds("DataSource", required);
                logger.debug("Available DataSources");
                for (String string : managed) {
                    logger.debug("DataSource(name=" + string + ", JtaManaged=true)");
                }
                for (String string : unmanaged) {
                    logger.debug("DataSource(name=" + string + ", JtaManaged=false)");
                }
                for (String string : unknown) {
                    if (managed.contains(string) || unmanaged.contains(string)) continue;
                    logger.debug("DataSource(name=" + string + ", JtaManaged=<unknown>)");
                }
            }
            String prefix = app.getModuleId() + "/";
            String jtaDataSourceId = null;
            String nonJtaDataSourceId = null;
            String jtaWithJavaAndSlash = this.replaceJavaAndSlash(unit.getJtaDataSource());
            for (Object potentialName2 : Arrays.asList(prefix + jtaWithJavaAndSlash, originalJtaDataSource, jtaWithJavaAndSlash)) {
                ResourceInfo jtaInfo;
                if (potentialName2 == null || (jtaInfo = this.configFactory.getResourceInfo((String)potentialName2)) == null) continue;
                if (!"false".equalsIgnoreCase(jtaInfo.properties.getProperty("JtaManaged")) && (jtaInfo.types.contains("DataSource") || jtaInfo.types.contains(DataSource.class.getName()))) {
                    jtaDataSourceId = jtaInfo.id;
                    break;
                }
                logger.warning("Found matching datasource: " + jtaInfo.id + " but this one is not a JTA datasource");
            }
            String string = this.replaceJavaAndSlash(unit.getNonJtaDataSource());
            potentialName2 = Arrays.asList(prefix + string, originalNonJtaDataSource, string).iterator();
            while (potentialName2.hasNext()) {
                ResourceInfo info;
                String potentialName3 = (String)potentialName2.next();
                if (potentialName3 == null || (info = this.configFactory.getResourceInfo(potentialName3)) == null) continue;
                if (!"true".equalsIgnoreCase(info.properties.getProperty("JtaManaged")) && (info.types.contains("DataSource") || info.types.contains(DataSource.class.getName()))) {
                    nonJtaDataSourceId = info.id;
                    break;
                }
                logger.warning("Found matching datasource: " + info.id + " but this one is a JTA datasource");
            }
            if (jtaDataSourceId == null && !resourceLocal) {
                required.put("JtaManaged", "true");
                jtaDataSourceId = this.findResourceId(prefix + jtaWithJavaAndSlash, "DataSource", required, null);
                if (jtaDataSourceId == null) {
                    jtaDataSourceId = this.findResourceId(jtaWithJavaAndSlash, "javax.sql.DataSource", required, null);
                }
            }
            if (nonJtaDataSourceId == null) {
                required.put("JtaManaged", "false");
                nonJtaDataSourceId = this.findResourceId(prefix + string, "DataSource", required, null);
                if (nonJtaDataSourceId == null) {
                    nonJtaDataSourceId = this.findResourceId(string, "DataSource", required, null);
                }
            }
            if ((jtaDataSourceId != null || resourceLocal) && nonJtaDataSourceId != null) {
                if (jtaDataSourceId != null) {
                    this.setJtaDataSource(unit, jtaDataSourceId);
                }
                this.setNonJtaDataSource(unit, nonJtaDataSourceId);
                continue;
            }
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                required.put("JtaManaged", ServiceUtils.NONE);
                if (!resourceLocal) {
                    jtaDataSourceId = this.findResourceId(unit.getJtaDataSource(), "DataSource", required, null);
                }
                nonJtaDataSourceId = this.findResourceId(unit.getNonJtaDataSource(), "DataSource", required, null);
                if (jtaDataSourceId != null || nonJtaDataSourceId != null) {
                    if (jtaDataSourceId != null) {
                        this.setJtaDataSource(unit, jtaDataSourceId);
                    }
                    if (nonJtaDataSourceId == null) continue;
                    this.setNonJtaDataSource(unit, nonJtaDataSourceId);
                    continue;
                }
            }
            required.put("JtaManaged", ServiceUtils.ANY);
            String possibleJta = this.findResourceId(jtaWithJavaAndSlash, "DataSource", required, null);
            String possibleNonJta = this.findResourceId(string, "DataSource", required, null);
            if (possibleJta != null && possibleJta.equals(possibleNonJta)) {
                ResourceInfo dataSource = this.configFactory.getResourceInfo(possibleJta);
                String jtaManaged = (String)dataSource.properties.get("JtaManaged");
                logger.warning("PeristenceUnit(name=" + unit.getName() + ") invalidly refers to Resource(id=" + dataSource.id + ") as both its <jta-data-source> and <non-jta-data-source>.");
                if ("true".equalsIgnoreCase(jtaManaged)) {
                    nonJtaDataSourceId = null;
                    unit.setNonJtaDataSource(null);
                } else if ("false".equalsIgnoreCase(jtaManaged)) {
                    jtaDataSourceId = null;
                    unit.setJtaDataSource(null);
                }
            }
            this.checkUnitDataSourceRefs(unit);
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                jtaDataSourceId = this.findResourceProviderId(unit.getJtaDataSource());
                nonJtaDataSourceId = this.findResourceProviderId(unit.getNonJtaDataSource());
                if (jtaDataSourceId != null || nonJtaDataSourceId != null) {
                    Resource jtaResource = new Resource(jtaDataSourceId, "DataSource", jtaDataSourceId);
                    jtaResource.getProperties().setProperty("JtaManaged", "true");
                    Resource nonJtaResource = new Resource(nonJtaDataSourceId, "DataSource", nonJtaDataSourceId);
                    nonJtaResource.getProperties().setProperty("JtaManaged", "false");
                    if (jtaDataSourceId == null) {
                        jtaResource.setId(nonJtaDataSourceId + "Jta");
                        jtaResource.setProvider(nonJtaDataSourceId);
                    } else if (nonJtaDataSourceId == null) {
                        nonJtaResource.setId(jtaDataSourceId + "NonJta");
                        nonJtaResource.setProvider(jtaDataSourceId);
                    }
                    ResourceInfo resourceInfo = this.configFactory.configureService(jtaResource, ResourceInfo.class);
                    ResourceInfo nonJtaResourceInfo = this.configFactory.configureService(nonJtaResource, ResourceInfo.class);
                    if (jtaDataSourceId != null && nonJtaDataSourceId == null) {
                        nonJtaResourceInfo.originAppName = resourceInfo.originAppName;
                    }
                    this.logAutoCreateResource(resourceInfo, "DataSource", unit.getName());
                    jtaDataSourceId = this.installResource(unit.getName(), resourceInfo);
                    this.logAutoCreateResource(nonJtaResourceInfo, "DataSource", unit.getName());
                    nonJtaDataSourceId = this.installResource(unit.getName(), nonJtaResourceInfo);
                    this.setJtaDataSource(unit, jtaDataSourceId);
                    this.setNonJtaDataSource(unit, nonJtaDataSourceId);
                    continue;
                }
            }
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(unit.getName());
                for (WebModule webModule : app.getWebModules()) {
                    ids.add(webModule.getModuleId());
                    ids.add(webModule.getContextRoot());
                }
                ids.add(app.getModuleId());
                for (String string2 : ids) {
                    required.put("JtaManaged", "true");
                    jtaDataSourceId = this.findResourceId(string2, "DataSource", required, null);
                    if (jtaDataSourceId == null) {
                        required.clear();
                        required.put("JtaManaged", "false");
                        nonJtaDataSourceId = this.findResourceId(string2, "DataSource", required, null);
                    }
                    if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                        required.clear();
                        required.put("JtaManaged", ServiceUtils.NONE);
                        jtaDataSourceId = this.findResourceId(string2, "DataSource", required, null);
                    }
                    if (jtaDataSourceId == null && nonJtaDataSourceId == null) continue;
                    break;
                }
            }
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                required.clear();
                required.put("JtaManaged", "true");
                jtaDataSourceId = this.firstMatching(prefix, "DataSource", required, null);
                if (jtaDataSourceId == null) {
                    required.clear();
                    required.put("JtaManaged", "false");
                    nonJtaDataSourceId = this.firstMatching(prefix, "DataSource", required, null);
                }
            }
            if (jtaDataSourceId != null && nonJtaDataSourceId == null) {
                ResourceInfo jtaResourceInfo = this.configFactory.getResourceInfo(jtaDataSourceId);
                Properties jtaProperties = jtaResourceInfo.properties;
                if (jtaProperties.containsKey("JtaManaged")) {
                    required.clear();
                    required.put("JtaManaged", "false");
                    for (String key : Arrays.asList("JdbcDriver", "JdbcUrl")) {
                        if (!jtaProperties.containsKey(key)) continue;
                        required.put(key, jtaProperties.get(key));
                    }
                    nonJtaDataSourceId = this.firstMatching(prefix, "DataSource", required, null);
                    if (nonJtaDataSourceId == null) {
                        ResourceInfo resourceInfo = this.copy(jtaResourceInfo);
                        resourceInfo.id = jtaResourceInfo.id + "NonJta";
                        resourceInfo.originAppName = jtaResourceInfo.originAppName;
                        AutoConfig.suffixAliases(resourceInfo, "NonJta");
                        AutoConfig.configureImplicitDataSource(resourceInfo);
                        Properties overrides = ConfigurationFactory.getSystemProperties(resourceInfo.id, resourceInfo.service);
                        resourceInfo.properties.putAll((Map<?, ?>)overrides);
                        resourceInfo.properties.setProperty("JtaManaged", "false");
                        resourceInfo.properties.remove("Definition");
                        this.logAutoCreateResource(resourceInfo, "DataSource", unit.getName());
                        logger.info("configureService.configuring", resourceInfo.id, resourceInfo.service, jtaResourceInfo.id);
                        nonJtaDataSourceId = this.installResource(unit.getName(), resourceInfo);
                    }
                }
            }
            String deduceJtaFromNonJta = unit.getProperty(AUTOCREATE_JTA_DATASOURCE_FROM_NON_JTA_ONE_KEY, SystemInstance.get().getOptions().get(AUTOCREATE_JTA_DATASOURCE_FROM_NON_JTA_ONE_KEY, (String)null));
            if (nonJtaDataSourceId != null && jtaDataSourceId == null && (!resourceLocal || deduceJtaFromNonJta != null) && (deduceJtaFromNonJta == null || deduceJtaFromNonJta != null && Boolean.parseBoolean(deduceJtaFromNonJta))) {
                ResourceInfo nonJtaResourceInfo = this.configFactory.getResourceInfo(nonJtaDataSourceId);
                Properties properties = nonJtaResourceInfo.properties;
                if (properties.containsKey("JtaManaged")) {
                    required.clear();
                    required.put("JtaManaged", "true");
                    for (String key : Arrays.asList("JdbcDriver", "JdbcUrl")) {
                        if (!properties.containsKey(key)) continue;
                        required.put(key, properties.get(key));
                    }
                    jtaDataSourceId = this.firstMatching(prefix, "DataSource", required, null);
                    if (jtaDataSourceId == null) {
                        ResourceInfo jtaResourceInfo = this.copy(nonJtaResourceInfo);
                        jtaResourceInfo.id = nonJtaResourceInfo.id + "Jta";
                        AutoConfig.suffixAliases(jtaResourceInfo, "Jta");
                        AutoConfig.configureImplicitDataSource(jtaResourceInfo);
                        Properties overrides = ConfigurationFactory.getSystemProperties(jtaResourceInfo.id, jtaResourceInfo.service);
                        jtaResourceInfo.properties.putAll((Map<?, ?>)overrides);
                        jtaResourceInfo.properties.setProperty("JtaManaged", "true");
                        jtaResourceInfo.properties.remove("Definition");
                        this.logAutoCreateResource(jtaResourceInfo, "DataSource", unit.getName());
                        logger.info("configureService.configuring", jtaResourceInfo.id, jtaResourceInfo.service, nonJtaResourceInfo.id);
                        jtaDataSourceId = this.installResource(unit.getName(), jtaResourceInfo);
                    }
                }
            }
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                if (!resourceLocal) {
                    required.put("JtaManaged", "true");
                    jtaDataSourceId = this.autoCreateResource("DataSource", required, unit.getName());
                }
                required.put("JtaManaged", "false");
                nonJtaDataSourceId = this.autoCreateResource("DataSource", required, unit.getName());
            }
            if (jtaDataSourceId != null) {
                this.setJtaDataSource(unit, jtaDataSourceId);
            }
            if (nonJtaDataSourceId == null) continue;
            this.setNonJtaDataSource(unit, nonJtaDataSourceId);
        }
    }

    private boolean isDataSourcePropertiesConfigured(Properties properties) {
        return "true".equals(SystemInstance.get().getProperty("openejb.guess.resource-local-datasource-properties-configured", "true")) && (properties.containsKey("jakarta.persistence.jdbc.driver") || properties.containsKey("jakarta.persistence.jdbc.url"));
    }

    private static void suffixAliases(ResourceInfo ri, String suffix) {
        List<String> aliases = ri.aliases;
        ArrayList<String> newAliases = new ArrayList<String>();
        for (String alias : aliases) {
            newAliases.add(alias + suffix);
        }
        ri.aliases = newAliases;
    }

    private static void configureImplicitDataSource(ResourceInfo copy) {
        if (copy != null && copy.properties != null) {
            for (String key : copy.properties.stringPropertyNames()) {
                if (!"InitialSize".equalsIgnoreCase(key)) continue;
                try {
                    int value = Integer.parseInt(copy.properties.getProperty("InitialSize"));
                    if (5 >= value) continue;
                    copy.properties.setProperty(key, Integer.toString(5));
                    logger.warning("Adjusting " + key + " to 5 for " + copy.id + " DataSource to avoid too much network bandwidth usage. If you want to keep it please define the DataSource explicitely.");
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    private String replaceJavaAndSlash(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("java:")) {
            return this.replaceJavaAndSlash(name.substring("java:".length()));
        }
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private void setNonJtaDataSource(PersistenceUnit unit, String current) {
        String previous = unit.getNonJtaDataSource();
        if (!current.equals(previous)) {
            logger.info("Adjusting PersistenceUnit " + unit.getName() + " <non-jta-data-source> to Resource ID '" + current + "' from '" + previous + "'");
        }
        unit.setNonJtaDataSource(current);
    }

    private void setJtaDataSource(PersistenceUnit unit, String current) {
        String previous = unit.getJtaDataSource();
        if (!current.equals(previous)) {
            logger.info("Adjusting PersistenceUnit " + unit.getName() + " <jta-data-source> to Resource ID '" + current + "' from '" + previous + "'");
        }
        unit.setJtaDataSource(current);
    }

    private ResourceInfo copy(ResourceInfo a) {
        ResourceInfo b = new ResourceInfo();
        b.id = a.id;
        b.service = a.service;
        b.className = a.className;
        b.codebase = a.codebase;
        b.displayName = a.displayName;
        b.description = a.description;
        b.factoryMethod = a.factoryMethod;
        b.constructorArgs.addAll(a.constructorArgs);
        b.originAppName = a.originAppName;
        b.types.addAll(a.types);
        b.properties = new SuperProperties();
        b.properties.putAll((Map<?, ?>)a.properties);
        if (a.classpath != null) {
            b.classpath = new URI[a.classpath.length];
            System.arraycopy(a.classpath, 0, b.classpath, 0, a.classpath.length);
        }
        return b;
    }

    private void checkUnitDataSourceRefs(PersistenceUnit unit) throws OpenEJBException {
        Properties required = new Properties();
        required.put("JtaManaged", "true");
        String invalidNonJta = this.findResourceId(unit.getNonJtaDataSource(), "DataSource", required, null);
        if (invalidNonJta != null) {
            throw new OpenEJBException("PeristenceUnit " + unit.getName() + " <non-jta-data-source> points to a jta managed Resource.  Update Resource \"" + invalidNonJta + "\" to \"JtaManaged=false\", use a different Resource, or delete the <non-jta-data-source> element and a default will be supplied if possible.");
        }
        required.put("JtaManaged", "false");
        String invalidJta = this.findResourceId(unit.getJtaDataSource(), "DataSource", required, null);
        if (invalidJta != null) {
            throw new OpenEJBException("PeristenceUnit " + unit.getName() + " <jta-data-source> points to a non jta managed Resource.  Update Resource \"" + invalidJta + "\" to \"JtaManaged=true\", use a different Resource, or delete the <jta-data-source> element and a default will be supplied if possible.");
        }
    }

    private String findResourceProviderId(String resourceId) throws OpenEJBException {
        if (resourceId == null) {
            return null;
        }
        if (ServiceUtils.hasServiceProvider(resourceId)) {
            return resourceId;
        }
        if (resourceId.startsWith("java:")) {
            String jndi = resourceId.substring("java:".length());
            if (jndi.startsWith("/")) {
                jndi = jndi.substring(1);
            }
            if (ServiceUtils.hasServiceProvider(jndi)) {
                return jndi;
            }
        }
        if (ServiceUtils.hasServiceProvider(resourceId = AutoConfig.toShortName(resourceId))) {
            return resourceId;
        }
        return null;
    }

    private String getResourceId(String beanName, String resourceId, String type, AppResources appResources) throws OpenEJBException {
        return this.getResourceId(beanName, resourceId, type, null, appResources);
    }

    private String getResourceId(String beanName, String resourceId, String type, Properties required, AppResources appResources) throws OpenEJBException {
        if ((resourceId = AutoConfig.normalizeResourceId(resourceId)) == null) {
            return null;
        }
        if (appResources == null) {
            appResources = EMPTY_APP_RESOURCES;
        }
        if (type != null && ignoredReferenceTypes.contains(type)) {
            return null;
        }
        String id = this.findResourceId(beanName + "/" + resourceId, type, required, appResources);
        if (id != null) {
            return id;
        }
        id = this.findResourceId(resourceId, type, required, appResources);
        if (id != null) {
            return id;
        }
        id = this.findResourceId(resourceId, null, required, appResources);
        if (id != null) {
            return id;
        }
        if (appResources.appId != null && !appResources.appId.isEmpty() && resourceId.startsWith(appResources.appId + "/") && (id = this.findResourceId(resourceId.substring(appResources.appId.length() + 1), type, required, appResources)) != null) {
            return id;
        }
        String shortName = AutoConfig.toShortName(resourceId);
        String message = "No existing resource found while attempting to Auto-link unmapped resource-ref '" + resourceId + "' of type '" + type + "' for '" + beanName + "'.  Looked for Resource(id=" + resourceId + ") and Resource(id=" + shortName + ")";
        if (!this.autoCreateResources) {
            throw new OpenEJBException(message);
        }
        logger.debug(message);
        if (ServiceUtils.hasServiceProvider(resourceId)) {
            ResourceInfo resourceInfo = this.configFactory.configureService(resourceId, ResourceInfo.class);
            return this.installResource(beanName, resourceInfo);
        }
        if (ServiceUtils.hasServiceProvider(shortName)) {
            ResourceInfo resourceInfo = this.configFactory.configureService(shortName, ResourceInfo.class);
            return this.installResource(beanName, resourceInfo);
        }
        id = this.firstMatching(beanName, type, required, appResources);
        if (id != null) {
            return id;
        }
        return this.autoCreateResource(type, required, beanName);
    }

    private String autoCreateResource(String type, Properties required, String beanName) throws OpenEJBException {
        String resourceId = ServiceUtils.getServiceProviderId(type, required);
        if (resourceId == null) {
            throw new OpenEJBException("No provider available for resource-ref '" + resourceId + "' of type '" + type + "' for '" + beanName + "'.");
        }
        ResourceInfo resourceInfo = this.configFactory.configureService(resourceId, ResourceInfo.class);
        this.logAutoCreateResource(resourceInfo, type, beanName);
        return this.installResource(beanName, resourceInfo);
    }

    private void logAutoCreateResource(ResourceInfo resourceInfo, String type, String beanName) {
        logger.info("Auto-creating a Resource with id '" + resourceInfo.id + "' of type '" + type + "' for '" + beanName + "'.");
    }

    private String firstMatching(final String prefix, String type, Properties required, AppResources appResources) {
        final List<String> resourceIds = this.getResourceIds(appResources, type, required);
        if (resourceIds.isEmpty()) {
            return null;
        }
        return Collections.min(resourceIds, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.startsWith(prefix) && o2.startsWith(prefix)) {
                    return resourceIds.indexOf(o1) - resourceIds.indexOf(o2);
                }
                if (o1.startsWith(prefix)) {
                    return -1;
                }
                if (o2.startsWith(prefix)) {
                    return 1;
                }
                return resourceIds.indexOf(o1) - resourceIds.indexOf(o2);
            }
        });
    }

    private String findResourceId(String resourceId, String type, Properties required, AppResources appResources) {
        if (resourceId == null) {
            return null;
        }
        return AutoConfig.findResourceId(this.getResourceIds(appResources, type, required), resourceId);
    }

    public static String findResourceId(Collection<String> resourceIds, String inId) {
        if (inId == null) {
            return null;
        }
        String resourceId = AutoConfig.normalizeResourceId(inId);
        for (String id : resourceIds) {
            if (!id.equalsIgnoreCase(resourceId)) continue;
            return id;
        }
        String shortName = AutoConfig.toShortName(resourceId);
        for (String id : resourceIds) {
            if (!id.equalsIgnoreCase(shortName)) continue;
            return id;
        }
        if (resourceId.startsWith("osgi:")) {
            return resourceId;
        }
        return null;
    }

    private List<String> getResourceIds(AppResources appResources, String type, Properties required) {
        ArrayList<String> resourceIds = new ArrayList<String>();
        if (appResources != null) {
            resourceIds.addAll(appResources.getResourceIds(type));
        }
        resourceIds.addAll(this.configFactory.getResourceIds(type, required));
        return resourceIds;
    }

    private static String toShortName(String resourceId) {
        return resourceId.replaceFirst(".*/", "");
    }

    private static String normalizeResourceId(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        if (resourceId.startsWith("java:") && (resourceId = resourceId.substring("java:".length())).startsWith("/")) {
            resourceId = resourceId.substring(1);
        }
        if (resourceId.startsWith("comp/env/")) {
            resourceId = resourceId.substring("comp/env/".length());
        }
        if (resourceId.startsWith("openejb/Resource/")) {
            resourceId = resourceId.substring("openejb/Resource/".length());
        }
        if (resourceId.startsWith("openejb/Connector/")) {
            resourceId = resourceId.substring("openejb/Connector/".length());
        }
        return resourceId;
    }

    private String installResource(String beanName, ResourceInfo resourceInfo) throws OpenEJBException {
        String newResourceId;
        String contextId;
        String newResourceId2;
        String dataSourceId;
        String newResourceId3;
        String resourceAdapterId = resourceInfo.properties.getProperty("ResourceAdapter");
        if (resourceAdapterId != null && !resourceAdapterId.equals(newResourceId3 = this.getResourceId(beanName, resourceAdapterId, null, null))) {
            resourceInfo.properties.setProperty("ResourceAdapter", newResourceId3);
        }
        if ((dataSourceId = resourceInfo.properties.getProperty("DataSource")) != null && !dataSourceId.isEmpty() && !dataSourceId.equals(newResourceId2 = this.getResourceId(beanName, dataSourceId, null, null))) {
            resourceInfo.properties.setProperty("DataSource", newResourceId2);
        }
        if (!((contextId = resourceInfo.properties.getProperty("Context")) == null || contextId.isEmpty() || "[automatic]".equals(contextId) || contextId.equals(newResourceId = this.getResourceId(beanName, contextId, null, null)))) {
            resourceInfo.properties.setProperty("Context", newResourceId);
        }
        this.configFactory.install(resourceInfo);
        return resourceInfo.id;
    }

    private String getResourceEnvId(String beanName, String resourceId, String type, AppResources appResources) throws OpenEJBException {
        if (resourceId == null) {
            return null;
        }
        if (appResources == null) {
            appResources = EMPTY_APP_RESOURCES;
        }
        if (ignoredReferenceTypes.contains(type)) {
            return null;
        }
        resourceId = AutoConfig.normalizeResourceId(resourceId);
        List<String> resourceEnvIds = this.getResourceIds(appResources, type, null);
        for (String id : resourceEnvIds) {
            if (!id.equalsIgnoreCase(resourceId)) continue;
            return id;
        }
        String message = "No existing resource found while attempting to Auto-link unmapped resource-env-ref '" + resourceId + "' of type '" + type + "' for '" + beanName + "'.  Looked for Resource(id=" + resourceId + ")";
        if (!this.autoCreateResources) {
            throw new OpenEJBException(message);
        }
        logger.debug(message);
        String providerId = ServiceUtils.getServiceProviderId(type);
        if (providerId == null) {
            if (resourceEnvIds.size() > 0) {
                return resourceEnvIds.get(0);
            }
            throw new OpenEJBException("No provider available for resource-env-ref '" + resourceId + "' of type '" + type + "' for '" + beanName + "'.");
        }
        Resource resource = new Resource(resourceId, null, providerId);
        resource.getProperties().setProperty("destination", resourceId);
        ResourceInfo resourceInfo = this.configFactory.configureService(resource, ResourceInfo.class);
        this.logAutoCreateResource(resourceInfo, type, beanName);
        return this.installResource(beanName, resourceInfo);
    }

    private String getUsableContainer(Class<? extends ContainerInfo> containerInfoType, EnterpriseBean bean, AppResources appResources) {
        String containerInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("Searching for usable container for bean: {0}. Available application containers: {1}, available system containers {2}", bean.getEjbName(), this.getContainerIds(appResources.getContainerInfos()), this.getContainerIds(this.configFactory.getContainerInfos()));
        }
        if (MessageDrivenBean.class.isInstance(bean)) {
            MessageDrivenBean messageDrivenBean = (MessageDrivenBean)bean;
            String messagingType = messageDrivenBean.getMessagingType();
            List<String> containerIds = appResources.containerIdsByType.get(messagingType);
            if (logger.isDebugEnabled()) {
                logger.debug("Searching for usable container for bean: {0} by messaging type: {1}. Potential application containers: {2}", bean.getEjbName(), messagingType, containerIds == null ? "" : Join.join(",", containerIds));
            }
            if (containerIds != null && !containerIds.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Returning first application container matching by type: {0} - {1}", messagingType, containerIds.get(0));
                }
                return containerIds.get(0);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting to find a matching container for bean: {0} from application containers {1}", bean.getEjbName(), this.getContainerIds(appResources.getContainerInfos()));
        }
        if ((containerInfo = this.matchContainer(containerInfoType, bean, appResources.getContainerInfos())) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Matching application container not found. Attempting to find a matching container for bean: {0} from system containers {1}", bean.getEjbName(), this.getContainerIds(appResources.getContainerInfos()));
            }
            containerInfo = this.matchContainer(containerInfoType, bean, this.configFactory.getContainerInfos());
        }
        if (containerInfo != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using container {0} for bean {1}", containerInfo, bean.getEjbName());
            }
            return containerInfo;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("No suitable existing container found for bean {0}", bean.getEjbName());
        }
        return null;
    }

    private String getContainerIds(Collection<ContainerInfo> containerInfos) {
        HashSet<String> containerIds = new HashSet<String>();
        for (ContainerInfo containerInfo : containerInfos) {
            containerIds.add(containerInfo.id);
        }
        return Join.join(", ", containerIds);
    }

    private String matchContainer(Class<? extends ContainerInfo> containerInfoType, EnterpriseBean bean, Collection<ContainerInfo> list) {
        for (ContainerInfo containerInfo : list) {
            if (containerInfo.getClass().equals(containerInfoType)) {
                if (MessageDrivenBean.class.isInstance(bean)) {
                    MessageDrivenBean messageDrivenBean = (MessageDrivenBean)bean;
                    String messagingType = messageDrivenBean.getMessagingType();
                    if (containerInfo.properties.get("MessageListenerInterface").equals(messagingType)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Container {0} matches container type {1} and MessageListenerInterface {2} for bean {3}, this container will be used.", containerInfo.id, containerInfoType.getName(), messagingType, bean.getEjbName());
                        }
                        return containerInfo.id;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Container {0} of type {1} does not have the matching MessageListenerInterface. Bean listener interface is {2}, container listener interface is {3} for bean {4}. Skipping.", containerInfo.id, containerInfoType.getName(), messagingType, containerInfo.properties.get("MessageListenerInterface"), bean.getEjbName());
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Container {0} matches container type {1} for bean {2}, this container will be used.", containerInfo.id, containerInfoType.getName(), bean.getEjbName());
                    }
                    return containerInfo.id;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Skipping container {0} of type {1}", containerInfo.id, containerInfoType.getName());
        }
        return null;
    }

    static {
        ignoredReferenceTypes.add("jakarta.ejb.SessionContext");
        ignoredReferenceTypes.add("jakarta.ejb.EntityContext");
        ignoredReferenceTypes.add("jakarta.ejb.MessageDrivenContext");
        ignoredReferenceTypes.add("jakarta.ejb.EJBContext");
        ignoredReferenceTypes.add("jakarta.xml.ws.WebServiceContext");
        ignoredReferenceTypes.add("java.net.URL");
        ignoredReferenceTypes.add(UserTransaction.class.getName());
        ignoredReferenceTypes.add(TransactionManager.class.getName());
        ignoredReferenceTypes.add(TransactionSynchronizationRegistry.class.getName());
        ignoredReferenceTypes.add(TimerService.class.getName());
        ignoredReferenceTypes.add(Validator.class.getName());
        ignoredReferenceTypes.add(ValidatorFactory.class.getName());
        ignoredReferenceTypes.add(BeanManager.class.getName());
        ignoredReferenceTypes.add(Request.class.getName());
        ignoredReferenceTypes.add(UriInfo.class.getName());
        ignoredReferenceTypes.add(HttpHeaders.class.getName());
        ignoredReferenceTypes.add(SecurityContext.class.getName());
        ignoredReferenceTypes.add(ContextResolver.class.getName());
        ignoredReferenceTypes.add(Application.class.getName());
        ignoredReferenceTypes.add(Providers.class.getName());
        ignoredReferenceTypes.add(ServletRequest.class.getName());
        ignoredReferenceTypes.add(HttpServletRequest.class.getName());
        ignoredReferenceTypes.add(ServletConfig.class.getName());
        ignoredReferenceTypes.add(ServletContext.class.getName());
        ignoredReferenceTypes.add(HttpServletResponse.class.getName());
    }

    static class AppResources {
        private String appId;
        private final Set<String> resourceAdapterIds = new TreeSet<String>();
        private final Map<String, List<String>> resourceIdsByType = new TreeMap<String, List<String>>();
        private final Map<String, List<String>> resourceEnvIdsByType = new TreeMap<String, List<String>>();
        private final Map<String, List<String>> containerIdsByType = new TreeMap<String, List<String>>();
        private final Collection<ContainerInfo> containerInfos = new HashSet<ContainerInfo>();

        public void dump() {
            if (!logger.isDebugEnabled()) {
                return;
            }
            for (String string : this.resourceAdapterIds) {
                logger.debug(this.appId + " module contains resource adapter id: " + string);
            }
            for (Map.Entry entry : this.resourceIdsByType.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    logger.debug(this.appId + " module contains resource type: " + (String)entry.getKey() + " --> " + value);
                }
            }
            for (Map.Entry entry : this.resourceEnvIdsByType.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    logger.debug(this.appId + " module contains resource env type: " + (String)entry.getKey() + " --> " + value);
                }
            }
            for (Map.Entry entry : this.containerIdsByType.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    logger.debug(this.appId + " module contains container type: " + (String)entry.getKey() + " --> " + value);
                }
            }
        }

        public AppResources() {
        }

        public AppResources(AppModule appModule, List<ContainerInfo> containerInfos) {
            this.containerInfos.addAll(containerInfos);
            this.appId = appModule.getModuleId();
            for (ContainerInfo containerInfo : containerInfos) {
                if (!MdbContainerInfo.class.isInstance(containerInfo)) continue;
                MdbContainerInfo mdbContainerInfo = (MdbContainerInfo)MdbContainerInfo.class.cast(containerInfo);
                String messageListenerInterface = mdbContainerInfo.properties.getProperty("MessageListenerInterface");
                if (messageListenerInterface == null) continue;
                List containerIds = this.containerIdsByType.computeIfAbsent(messageListenerInterface, k -> new ArrayList());
                containerIds.add(containerInfo.id);
            }
            for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
                String type;
                InboundResourceadapter inbound;
                OutboundResourceAdapter outbound;
                Connector connector = connectorModule.getConnector();
                ResourceAdapter resourceAdapter = connector.getResourceAdapter();
                if (resourceAdapter.getResourceAdapterClass() != null) {
                    Object resourceAdapterId = resourceAdapter.getId() != null ? resourceAdapter.getId() : connectorModule.getModuleId() + "RA";
                    this.resourceAdapterIds.add((String)resourceAdapterId);
                }
                if ((outbound = resourceAdapter.getOutboundResourceAdapter()) != null) {
                    for (ConnectionDefinition connection : outbound.getConnectionDefinition()) {
                        String type2 = connection.getConnectionFactoryInterface();
                        Object resourceId = connection.getId() != null ? connection.getId() : (outbound.getConnectionDefinition().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + type2);
                        List resourceIds = this.resourceIdsByType.computeIfAbsent(type2, k -> new ArrayList());
                        resourceIds.add(resourceId);
                    }
                }
                if ((inbound = resourceAdapter.getInboundResourceAdapter()) != null) {
                    for (MessageListener messageListener : inbound.getMessageAdapter().getMessageListener()) {
                        type = messageListener.getMessageListenerType();
                        Object containerId = messageListener.getId() != null ? messageListener.getId() : (inbound.getMessageAdapter().getMessageListener().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + type);
                        List containerIds = this.containerIdsByType.computeIfAbsent(type, k -> new ArrayList());
                        containerIds.add(containerId);
                    }
                }
                for (AdminObject adminObject : resourceAdapter.getAdminObject()) {
                    type = adminObject.getAdminObjectInterface();
                    Object resourceEnvId = adminObject.getId() != null ? adminObject.getId() : (resourceAdapter.getAdminObject().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + type);
                    List resourceEnvIds = this.resourceEnvIdsByType.computeIfAbsent(type, k -> new ArrayList());
                    resourceEnvIds.add(resourceEnvId);
                }
            }
            for (Resource r : appModule.getResources()) {
                String[] types;
                String type = r.getType();
                if (type == null) continue;
                for (String t : types = type.trim().split(",")) {
                    List ids = this.resourceIdsByType.computeIfAbsent(t, k -> new ArrayList());
                    ids.add(r.getId());
                    if (r.getJndi() == null) continue;
                    ids.add(r.getJndi());
                }
            }
        }

        public Collection<ContainerInfo> getContainerInfos() {
            return this.containerInfos;
        }

        private void addContainer(ContainerInfo container) {
            this.containerInfos.add(container);
        }

        public List<String> getResourceIds(String type) {
            if (type == null) {
                ArrayList<String> allResourceIds = new ArrayList<String>();
                for (List<String> resourceIds : this.resourceIdsByType.values()) {
                    allResourceIds.addAll(resourceIds);
                }
                return allResourceIds;
            }
            List<String> resourceIds = this.resourceIdsByType.get(type);
            if (resourceIds != null) {
                return resourceIds;
            }
            return Collections.emptyList();
        }

        public List<String> getResourceEnvIds(String type) {
            List<String> resourceIds;
            if (type != null && (resourceIds = this.resourceEnvIdsByType.get(type)) != null) {
                return resourceIds;
            }
            return Collections.emptyList();
        }

        public List<String> getContainerIds() {
            ArrayList<String> ids = new ArrayList<String>();
            for (List<String> list : this.containerIdsByType.values()) {
                ids.addAll(list);
            }
            return ids;
        }
    }
}

