/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public final class CxfCatalogUtils {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.CXF, CxfCatalogUtils.class);

    public static void loadOASISCatalog(Bus bus, URL baseURL, String catalogName) {
        if (baseURL == null) {
            logger.debug("baseUrl is not valid for catalog '" + catalogName + "'");
            return;
        }
        URL catalogURL = null;
        try {
            catalogURL = new URL(baseURL, catalogName);
            if (catalogURL != null) {
                logger.debug("Checking for " + catalogURL + " catalog.");
                catalogURL.openStream().close();
                CxfCatalogUtils.loadOASISCatalog(bus, catalogURL);
            } else {
                logger.info("catalog '" + catalogName + "' not found");
            }
        }
        catch (MalformedURLException e) {
            logger.warning("Error constructing catalog URL: " + baseURL + " " + catalogName);
        }
        catch (FileNotFoundException e) {
            logger.debug("Catalog " + catalogURL + " is not present in the module");
        }
        catch (IOException e) {
            logger.warning("Failed to load catalog file: " + catalogURL, (Throwable)e);
        }
    }

    private static void loadOASISCatalog(Bus bus, URL catalogURL) {
        OASISCatalogManager catalog = new OASISCatalogManager();
        try {
            catalog.loadCatalog(catalogURL);
            logger.debug("Loaded " + catalogURL + " catalog.");
            bus.setExtension((Object)catalog, OASISCatalogManager.class);
        }
        catch (IOException e) {
            logger.warning("Failed to load catalog file: " + catalogURL, (Throwable)e);
        }
    }
}

