/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.datasync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.datasync.StoreProvider;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.RealRawData;
import org.directwebremoting.io.Item;
import org.directwebremoting.io.MatchedItems;
import org.directwebremoting.io.QueryOptions;
import org.directwebremoting.io.RawData;
import org.directwebremoting.io.StoreChangeListener;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Pair;

public abstract class AbstractStoreProvider<T>
implements StoreProvider<T> {
    private final Map<String, Collection<StoreChangeListener<T>>> watchers = new HashMap<String, Collection<StoreChangeListener<T>>>();
    private final Map<StoreChangeListener<T>, Collection<String>> watched = new HashMap<StoreChangeListener<T>, Collection<String>>();
    protected final Class<T> type;
    protected ConverterManager converterManager;
    private static final Log log = LogFactory.getLog(AbstractStoreProvider.class);

    public AbstractStoreProvider(Class<T> type) {
        this.type = type;
    }

    @Override
    public void put(String itemId, RawData rawData) {
        T value = this.convert(rawData);
        this.put(itemId, value);
    }

    @Override
    public Item viewItem(String itemId) {
        T object = this.getObject(itemId);
        return new Item(itemId, object);
    }

    protected abstract T getObject(String var1);

    protected static boolean passesFilter(Object pojo, Map<String, String> query, QueryOptions options) {
        if (query == null || query.isEmpty()) {
            return true;
        }
        try {
            Iterator<Map.Entry<String, String>> i$ = query.entrySet().iterator();
            if (i$.hasNext()) {
                Map.Entry<String, String> entry = i$.next();
                String testProperty = entry.getKey();
                String testValue = entry.getValue();
                String realValue = LocalUtil.getProperty(pojo, testProperty, String.class);
                return AbstractStoreProvider.testPattern(testValue, realValue, options.isIgnoreCase());
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to introspect: " + pojo.getClass() + ". Filters will fail."));
            return false;
        }
        return true;
    }

    protected static boolean testPattern(String pattern, String value, boolean caseInsensitive) {
        boolean result = pattern.equals(value);
        if (!result && LocalUtil.hasText(value)) {
            String javaPattern = pattern.replace("?", ".").replace("*", ".*");
            if (LocalUtil.hasText(pattern)) {
                Pattern p = caseInsensitive ? Pattern.compile(javaPattern, 66) : Pattern.compile(javaPattern);
                result = p.matcher(value).matches();
            } else {
                result = true;
            }
        }
        return result;
    }

    protected static <U> MatchedItems selectMatchedItems(SortedSet<Pair<String, U>> sortedData, int start, int count) {
        log.debug((Object)("Selecting data from " + sortedData.size() + " items, starting at " + start + " for " + count + " items."));
        ArrayList<Item> matches = new ArrayList<Item>();
        int i = 0;
        for (Pair pair : sortedData) {
            if (i >= start + count && count != -1) break;
            if (i >= start) {
                matches.add(new Item((String)pair.left, pair.right));
            }
            ++i;
        }
        return new MatchedItems(matches, sortedData.size());
    }

    protected T convert(RawData rawData) {
        if (rawData == null) {
            return null;
        }
        if (this.converterManager == null) {
            this.converterManager = ServerContextFactory.get().getContainer().getBean(ConverterManager.class);
        }
        RealRawData realRawData = (RealRawData)rawData;
        InboundVariable inboundVariable = realRawData.getInboundVariable();
        T value = this.converterManager.convertInbound(this.type, inboundVariable, null);
        return value;
    }

    protected Object convert(RawData rawData, Class<?> toType) {
        if (rawData == null || toType == null) {
            return null;
        }
        if (this.converterManager == null) {
            this.converterManager = ServerContextFactory.get().getContainer().getBean(ConverterManager.class);
        }
        RealRawData realRawData = (RealRawData)rawData;
        InboundVariable inboundVariable = realRawData.getInboundVariable();
        Object value = this.converterManager.convertInbound(toType, inboundVariable, null);
        return value;
    }

    protected synchronized void setWatchedSet(StoreChangeListener<T> listener, Collection<String> itemIds) {
        this.clearWatchedSet(listener);
        this.addWatchedSet(listener, itemIds);
    }

    protected synchronized void addWatched(StoreChangeListener<T> listener, String itemId) {
        Collection<String> ids = this.watched.get(listener);
        Collection<StoreChangeListener<T>> listeners = this.watchers.get(itemId);
        if (ids == null) {
            ids = new HashSet<String>();
            this.watched.put(listener, ids);
        }
        ids.add(itemId);
        if (listeners == null) {
            listeners = new HashSet<StoreChangeListener<T>>();
            this.watchers.put(itemId, listeners);
        }
        listeners.add(listener);
    }

    protected synchronized void addWatchedSet(StoreChangeListener<T> listener, Collection<String> itemIds) {
        if (itemIds == null || itemIds.isEmpty()) {
            return;
        }
        this.watched.put(listener, itemIds);
        for (String itemId : itemIds) {
            Collection<StoreChangeListener<T>> listeners = this.watchers.get(itemId);
            if (listeners == null) {
                listeners = new HashSet<StoreChangeListener<T>>();
                this.watchers.put(itemId, listeners);
            }
            listeners.add(listener);
        }
    }

    protected synchronized void clearWatchedSet(StoreChangeListener<T> listener) {
        Collection<String> itemIds = this.watched.get(listener);
        if (itemIds != null) {
            for (String itemId : itemIds) {
                Collection<StoreChangeListener<T>> listeners = this.watchers.get(itemId);
                if (listeners == null) continue;
                listeners.remove(listener);
                if (!listeners.isEmpty()) continue;
                this.watchers.remove(itemId);
            }
            this.watched.remove(listener);
        }
    }

    protected synchronized void updateWatcherSets(String itemId) {
        for (StoreChangeListener<T> listener : this.watched.keySet()) {
            this.addWatched(listener, itemId);
        }
    }

    protected synchronized void fireItemChanged(Item item, Collection<String> attributes) {
        Collection<StoreChangeListener<T>> listeners = this.watchers.get(item.getItemId());
        if (listeners != null) {
            log.debug((Object)("Firing item changed to " + listeners.size() + " listeners. Changed: " + item));
            for (StoreChangeListener<T> listener : listeners) {
                listener.itemChanged(this, item, attributes);
            }
        }
    }

    protected synchronized void fireItemAdded(Item item) {
        this.updateWatcherSets(item.getItemId());
        Collection<StoreChangeListener<T>> listeners = this.watchers.get(item.getItemId());
        if (listeners != null) {
            log.debug((Object)("Firing item added to " + listeners.size() + " listeners. Changed: " + item));
            for (StoreChangeListener<T> listener : listeners) {
                listener.itemAdded(this, item);
            }
        }
    }

    protected synchronized void fireItemRemoved(String itemId) {
        Collection<StoreChangeListener<T>> listeners = this.watchers.get(itemId);
        if (listeners != null) {
            log.debug((Object)("Firing item removed to " + listeners.size() + " listeners. Changed: " + itemId));
            for (StoreChangeListener<T> listener : listeners) {
                listener.itemRemoved(this, itemId);
            }
        }
    }

    protected static class PairComparator<T>
    implements Comparator<Pair<String, T>> {
        private final Comparator<T> proxy;

        protected PairComparator(Comparator<T> proxy) {
            this.proxy = proxy;
        }

        @Override
        public int compare(Pair<String, T> p1, Pair<String, T> p2) {
            return this.proxy.compare(p1.right, p2.right);
        }
    }
}

