/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.io.Serializable;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import org.apache.sis.pending.geoapi.temporal.IndeterminateValue;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.pending.geoapi.temporal.TemporalOperatorName;
import org.apache.sis.temporal.TimeMethods;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.shared.Strings;

abstract class TemporalOperation<T>
implements Serializable {
    private static final long serialVersionUID = -5304814915639460679L;
    private static final WeakHashSet<TemporalOperation<?>> POOL = new WeakHashSet(TemporalOperation.class);
    protected final TimeMethods<T> comparators;

    protected TemporalOperation(TimeMethods<T> comparators) {
        this.comparators = comparators;
    }

    public final TemporalOperation<T> unique() {
        return (TemporalOperation)POOL.unique((Object)this);
    }

    public final int hashCode() {
        return this.getClass().hashCode() + 31 * this.comparators.type.hashCode();
    }

    public final boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((TemporalOperation)other).comparators.type == this.comparators.type;
    }

    public final String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"operator", this.getOperatorType().identifier(), "type", this.comparators.type.getSimpleName()});
    }

    public abstract TemporalOperatorName getOperatorType();

    protected char symbol() {
        return '\u0000';
    }

    protected boolean evaluate(T self, T other) {
        return false;
    }

    protected boolean evaluate(T self, Period other) {
        return false;
    }

    protected boolean evaluate(Period self, T other) {
        return false;
    }

    protected abstract boolean evaluate(Period var1, Period var2);

    protected final boolean compare(int test, T self, Instant other) {
        if (other != null) {
            Temporal position;
            Optional p = other.getIndeterminatePosition();
            if (p.isPresent()) {
                if (p.get() == IndeterminateValue.NOW) {
                    position = this.comparators.now();
                } else {
                    switch (test) {
                        case 1: {
                            if (p.get() == IndeterminateValue.AFTER) break;
                            return false;
                        }
                        case 2: {
                            if (p.get() == IndeterminateValue.BEFORE) break;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    position = other.getPosition();
                }
            } else {
                position = other.getPosition();
            }
            if (position != null) {
                return this.comparators.compare(test, self, (TemporalAccessor)position);
            }
        }
        return false;
    }

    protected static boolean compare(int test, Instant self, Instant other) {
        if (self == null || other == null) {
            return false;
        }
        IndeterminateValue p1 = self.getIndeterminatePosition().orElse(null);
        IndeterminateValue p2 = other.getIndeterminatePosition().orElse(null);
        if (p1 != null || p2 != null) {
            if (p1 == p2) {
                return test == 0 && p1 == IndeterminateValue.NOW;
            }
            switch (test) {
                case 1: {
                    if (!TemporalOperation.isAmbiguous(p1, IndeterminateValue.BEFORE) && !TemporalOperation.isAmbiguous(p2, IndeterminateValue.AFTER)) break;
                    return false;
                }
                case 2: {
                    if (!TemporalOperation.isAmbiguous(p1, IndeterminateValue.AFTER) && !TemporalOperation.isAmbiguous(p2, IndeterminateValue.BEFORE)) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return TimeMethods.compareAny((int)test, (Temporal)self.getPosition(), (Temporal)other.getPosition());
    }

    private static boolean isAmbiguous(IndeterminateValue p, IndeterminateValue required) {
        return p != null && p != IndeterminateValue.NOW && p != required;
    }

    static final class AnyInteracts<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 5972351564286442392L;

        AnyInteracts(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ANY_INTERACTS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            Instant otherBegin;
            Instant selfEnd;
            Instant otherEnd;
            Instant selfBegin = self.getBeginning();
            return selfBegin != null && (otherEnd = other.getEnding()) != null && AnyInteracts.compare(1, selfBegin, otherEnd) && (selfEnd = self.getEnding()) != null && (otherBegin = other.getBeginning()) != null && AnyInteracts.compare(2, selfEnd, otherBegin);
        }
    }

    static final class OverlappedBy<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 2228673820507226463L;

        OverlappedBy(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.OVERLAPPED_BY;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            Instant selfEnd;
            Instant otherEnd;
            Instant otherBegin;
            Instant selfBegin = self.getBeginning();
            return selfBegin != null && (otherBegin = other.getBeginning()) != null && OverlappedBy.compare(2, selfBegin, otherBegin) && (otherEnd = other.getEnding()) != null && OverlappedBy.compare(1, selfBegin, otherEnd) && (selfEnd = self.getEnding()) != null && OverlappedBy.compare(2, selfEnd, otherEnd);
        }
    }

    static final class Overlaps<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 1517443045593389773L;

        Overlaps(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.OVERLAPS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            Instant otherEnd;
            Instant selfEnd;
            Instant selfBegin;
            Instant otherBegin = other.getBeginning();
            return otherBegin != null && (selfBegin = self.getBeginning()) != null && Overlaps.compare(1, selfBegin, otherBegin) && (selfEnd = self.getEnding()) != null && Overlaps.compare(2, selfEnd, otherBegin) && (otherEnd = other.getEnding()) != null && Overlaps.compare(1, selfEnd, otherEnd);
        }
    }

    static final class Contains<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 9107531246948034411L;

        Contains(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.CONTAINS;
        }

        @Override
        protected char symbol() {
            return '\u228b';
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(2, other, self.getBeginning()) && this.compare(1, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Contains.compare(1, self.getBeginning(), other.getBeginning()) && Contains.compare(2, self.getEnding(), other.getEnding());
        }
    }

    static final class During<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -4674319635076886196L;

        During(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.DURING;
        }

        @Override
        protected char symbol() {
            return '\u228a';
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return During.compare(2, self.getBeginning(), other.getBeginning()) && During.compare(1, self.getEnding(), other.getEnding());
        }
    }

    static final class MetBy<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 5358059498707330482L;

        MetBy(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.MET_BY;
        }

        @Override
        public boolean evaluate(T self, T other) {
            return this.comparators.isEqual.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(0, self, other.getEnding());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(0, other, self.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return MetBy.compare(0, self.getBeginning(), other.getEnding());
        }
    }

    static final class Meets<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -3534843269384858443L;

        Meets(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.MEETS;
        }

        @Override
        public boolean evaluate(T self, T other) {
            return this.comparators.isEqual.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(0, self, other.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(0, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Meets.compare(0, self.getEnding(), other.getBeginning());
        }
    }

    static final class EndedBy<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 8586566103462153666L;

        EndedBy(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ENDED_BY;
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(0, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return EndedBy.compare(0, self.getEnding(), other.getEnding()) && EndedBy.compare(1, self.getBeginning(), other.getBeginning());
        }
    }

    static final class BegunBy<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -7212413827394364384L;

        BegunBy(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEGUN_BY;
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(0, other, self.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return BegunBy.compare(0, self.getBeginning(), other.getBeginning()) && BegunBy.compare(2, self.getEnding(), other.getEnding());
        }
    }

    static final class Ends<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -5508229966320563437L;

        Ends(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.ENDS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Ends.compare(0, self.getEnding(), other.getEnding()) && Ends.compare(2, self.getBeginning(), other.getBeginning());
        }
    }

    static final class Begins<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -7880699329127762233L;

        Begins(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEGINS;
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Begins.compare(0, self.getBeginning(), other.getBeginning()) && Begins.compare(1, self.getEnding(), other.getEnding());
        }
    }

    static final class After<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = 5410476260417497682L;

        After(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.AFTER;
        }

        @Override
        protected char symbol() {
            return '>';
        }

        @Override
        protected boolean evaluate(T self, T other) {
            return this.comparators.isAfter.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(2, self, other.getEnding());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(1, other, self.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return After.compare(2, self.getBeginning(), other.getEnding());
        }
    }

    static final class Before<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -3422629447456003982L;

        Before(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.BEFORE;
        }

        @Override
        protected char symbol() {
            return '<';
        }

        @Override
        protected boolean evaluate(T self, T other) {
            return this.comparators.isBefore.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(1, self, other.getBeginning());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(2, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Before.compare(1, self.getEnding(), other.getBeginning());
        }
    }

    static final class Equals<T>
    extends TemporalOperation<T> {
        private static final long serialVersionUID = -6060822291802339424L;

        Equals(TimeMethods<T> comparators) {
            super(comparators);
        }

        @Override
        public TemporalOperatorName getOperatorType() {
            return TemporalOperatorName.EQUALS;
        }

        @Override
        protected char symbol() {
            return '=';
        }

        @Override
        protected boolean evaluate(T self, T other) {
            return this.comparators.isEqual.test(self, other);
        }

        @Override
        public boolean evaluate(T self, Period other) {
            return this.compare(0, self, other.getBeginning()) && this.compare(0, self, other.getEnding());
        }

        @Override
        public boolean evaluate(Period self, T other) {
            return this.compare(0, other, self.getBeginning()) && this.compare(0, other, self.getEnding());
        }

        @Override
        public boolean evaluate(Period self, Period other) {
            return Equals.compare(0, self.getBeginning(), other.getBeginning()) && Equals.compare(0, self.getEnding(), other.getEnding());
        }
    }

    @FunctionalInterface
    static interface Factory {
        public <T> TemporalOperation<T> create(TimeMethods<T> var1);
    }
}

