/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.sis.metadata.sql.internal.shared.SQLUtilities;
import org.apache.sis.metadata.sql.internal.shared.ScriptRunner;
import org.apache.sis.referencing.factory.sql.InstallationScriptProvider;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.system.Fallback;
import org.apache.sis.util.logging.PerformanceLevel;
import org.apache.sis.util.resources.Messages;

final class EPSGInstaller
extends ScriptRunner {
    private final Map<String, String> identifierReplacements;
    private boolean applyReplacements;

    public EPSGInstaller(Connection connection, String schema) throws SQLException {
        super(connection, (String)(schema == null ? "EPSG" : (schema.isEmpty() ? null : schema)), 100);
        this.identifierReplacements = this.isEnumTypeSupported ? Map.of() : Map.of("Datum Kind", "VARCHAR(16)", "CRS Kind", "VARCHAR(13)", "CS Kind", "VARCHAR(15)", "Supersession Type", "VARCHAR(12)", "Table Name", "VARCHAR(36)");
    }

    protected void editText(StringBuilder sql, int lower, int upper) {
        switch (upper - lower) {
            default: {
                return;
            }
            case 2: 
        }
        String replacement = "Null";
        sql.replace(lower, upper, replacement);
    }

    protected void editQuotedIdentifier(StringBuilder sql, int lower, int upper) {
        int n;
        String r;
        if (this.applyReplacements && (r = this.identifierReplacements.get(sql.substring(lower + (n = this.identifierQuote.length()), upper - n))) != null) {
            sql.replace(lower, upper, r);
        }
    }

    public boolean run(InstallationResources scriptProvider, Locale locale) throws SQLException, IOException {
        long time = System.nanoTime();
        if (scriptProvider == null && (scriptProvider = EPSGInstaller.lookupProvider(locale)) == null) {
            return false;
        }
        InstallationScriptProvider.log(Messages.forLocale((Locale)locale).createLogRecord(Level.INFO, (short)11, (Object)"EPSG", (Object)SQLUtilities.getSimplifiedURL((DatabaseMetaData)this.getConnection().getMetaData())));
        int numRows = 0;
        String[] scripts = scriptProvider.getResourceNames("EPSG");
        for (int i = 0; i < scripts.length; ++i) {
            String script = scripts[i];
            this.applyReplacements = i != 0 && !this.identifierReplacements.isEmpty();
            try (BufferedReader in = scriptProvider.openScript("EPSG", i);){
                numRows += this.run(script, in);
                continue;
            }
        }
        time = System.nanoTime() - time;
        InstallationScriptProvider.log(Messages.forLocale((Locale)locale).createLogRecord(PerformanceLevel.forDuration((long)time, (TimeUnit)TimeUnit.NANOSECONDS), (short)23, (Object)numRows, (Object)Float.valueOf((float)time / 1.0E9f)));
        return true;
    }

    private static InstallationResources lookupProvider(Locale locale) throws IOException {
        InstallationResources fallback = null;
        for (InstallationResources provider : InstallationResources.load()) {
            if (!provider.getAuthorities().contains("EPSG")) continue;
            if (!provider.getClass().isAnnotationPresent(Fallback.class)) {
                return provider;
            }
            fallback = provider;
        }
        return fallback;
    }

    final String failure(Locale locale) {
        Object message = Messages.forLocale((Locale)locale).getString((short)2, (Object)"EPSG");
        String status = this.status(locale);
        if (status != null) {
            message = (String)message + " " + status;
        }
        return message;
    }
}

