/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public abstract class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");

    public boolean load() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName);
            if (null == jsonString || jsonString.length() == 0) {
                Files.deleteIfExists(Paths.get(fileName, new String[0]));
                return this.loadBak();
            }
            this.decode(jsonString);
            log.info("load " + fileName + " OK");
            return true;
        }
        catch (Exception e) {
            log.error("load " + fileName + " failed, and try to load backup file", (Throwable)e);
            try {
                if (fileName != null) {
                    Files.deleteIfExists(Paths.get(fileName, new String[0]));
                }
            }
            catch (Throwable t) {
                log.error("load " + fileName + " failed, and delete invalid file errr", (Throwable)e);
            }
            return this.loadBak();
        }
    }

    private boolean loadBak() {
        String fileName = null;
        try {
            fileName = this.configFilePath() + ".bak";
            String jsonString = MixAll.file2String(fileName);
            if (jsonString != null && jsonString.length() > 0) {
                this.decode(jsonString);
                log.info("load " + fileName + " OK");
                return true;
            }
        }
        catch (Exception e) {
            log.error("load " + fileName + " Failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized <T> void persist(String topicName, T t) {
        this.persist();
    }

    public synchronized <T> void persist(Map<String, T> m) {
        this.persist();
    }

    public synchronized void persist() {
        String jsonString = this.encode(true);
        if (jsonString != null) {
            try {
                File dir;
                String config = this.configFilePath();
                String backup = config + ".bak";
                File configFile = new File(config);
                File bakFile = new File(backup);
                if (configFile.exists()) {
                    Files.move(configFile.toPath(), bakFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    MixAll.fsyncDirectory(Paths.get(bakFile.getParent(), new String[0]));
                }
                if (!(dir = new File(configFile.getParent())).exists()) {
                    Files.createDirectories(dir.toPath(), new FileAttribute[0]);
                }
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(config, "rw");){
                    randomAccessFile.write(jsonString.getBytes(StandardCharsets.UTF_8));
                    randomAccessFile.getChannel().force(true);
                    MixAll.fsyncDirectory(Paths.get(configFile.getParent(), new String[0]));
                }
            }
            catch (Throwable t) {
                log.error("Failed to persist", t);
            }
        }
    }

    public boolean stop() {
        return true;
    }

    public void shutdown() {
        this.stop();
    }

    public abstract String configFilePath();

    public abstract String encode();

    public abstract String encode(boolean var1);

    public abstract void decode(String var1);
}

