/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.aggregation;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.qpid.server.query.engine.parsing.collector.CollectorType;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AbstractAggregationExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class MinExpression<T, R>
extends AbstractAggregationExpression<T, T> {
    private final FunctionParameterTypePredicate<Object> _typeValidator = FunctionParameterTypePredicate.builder().allowNumbers().allowStrings().allowDateTimeTypes().allowComparables().build();

    public MinExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(1, args, this);
    }

    @Override
    public CollectorType getCollectorType() {
        return CollectorType.MINIMIZING;
    }

    @Override
    public T aggregate(List<T> items) {
        List<?> args = this.getArguments(items, this._typeValidator);
        Comparator comparator = Comparator.naturalOrder();
        Optional<Comparable> optResult = args.stream().map(result -> (Comparable)result).min(comparator);
        T result2 = optResult.orElse(null);
        if (result2 instanceof Number) {
            return (T)NumberConverter.narrow((Number)result2);
        }
        return result2;
    }
}

