/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.topic;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.server.exchange.topic.TopicWord;

public class TopicWordDictionary {
    private final ConcurrentMap<String, TopicWord> _dictionary = new ConcurrentHashMap<String, TopicWord>();

    public TopicWordDictionary() {
        this._dictionary.put("*", TopicWord.ANY_WORD);
        this._dictionary.put("#", TopicWord.WILDCARD_WORD);
    }

    public TopicWord getOrCreateWord(String name) {
        TopicWord word = this._dictionary.putIfAbsent(name, new TopicWord(name));
        if (word == null) {
            word = (TopicWord)this._dictionary.get(name);
        }
        return word;
    }

    public TopicWord getWord(String name) {
        TopicWord word = (TopicWord)this._dictionary.get(name);
        if (word == null) {
            word = TopicWord.ANY_WORD;
        }
        return word;
    }
}

