/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.pfb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PfbParser {
    private static final Log LOG = LogFactory.getLog(PfbParser.class);
    private static final int PFB_HEADER_LENGTH = 18;
    private static final int START_MARKER = 128;
    private static final int ASCII_MARKER = 1;
    private static final int BINARY_MARKER = 2;
    private static final int EOF_MARKER = 3;
    private static final int BUFFER_SIZE = 65535;
    private byte[] pfbdata;
    private final int[] lengths = new int[3];

    public PfbParser(String filename) throws IOException {
        this(Files.readAllBytes(Paths.get(filename, new String[0])));
    }

    public PfbParser(InputStream in) throws IOException {
        byte[] pfb = this.readFully(in);
        this.parsePfb(pfb);
    }

    public PfbParser(byte[] bytes) throws IOException {
        this.parsePfb(bytes);
    }

    private void parsePfb(byte[] pfb) throws IOException {
        int i;
        byte[] ar;
        long total;
        int r;
        int size;
        if (pfb.length < 18) {
            throw new IOException("PFB header missing");
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>(3);
        ArrayList<byte[]> barrList = new ArrayList<byte[]>(3);
        ByteArrayInputStream in = new ByteArrayInputStream(pfb);
        for (total = 0L; (r = in.read()) != -1 || total <= 0L; total += (long)size) {
            if (r != 128) {
                throw new IOException("Start marker missing");
            }
            int recordType = in.read();
            if (recordType == 3) break;
            if (recordType != 1 && recordType != 2) {
                throw new IOException("Incorrect record type: " + recordType);
            }
            size = in.read();
            size += in.read() << 8;
            size += in.read() << 16;
            size += in.read() << 24;
            if (LOG.isDebugEnabled()) {
                LOG.debug("record type: " + recordType + ", segment size: " + size);
            }
            if (size > pfb.length) {
                throw new IOException("record size " + size + " would be larger than the input");
            }
            ar = new byte[size];
            int got = in.read(ar);
            if (got != size) {
                throw new EOFException("EOF while reading PFB font");
            }
            typeList.add(recordType);
            barrList.add(ar);
        }
        if (total > (long)pfb.length) {
            throw new IOException("total record size " + total + " would be larger than the input");
        }
        this.pfbdata = new byte[(int)total];
        byte[] cleartomarkSegment = null;
        int dstPos = 0;
        for (i = 0; i < typeList.size(); ++i) {
            if ((Integer)typeList.get(i) != 1) continue;
            ar = (byte[])barrList.get(i);
            if (i == typeList.size() - 1 && ar.length < 600 && new String(ar, StandardCharsets.US_ASCII).contains("cleartomark")) {
                cleartomarkSegment = ar;
                continue;
            }
            System.arraycopy(ar, 0, this.pfbdata, dstPos, ar.length);
            dstPos += ar.length;
        }
        this.lengths[0] = dstPos;
        for (i = 0; i < typeList.size(); ++i) {
            if ((Integer)typeList.get(i) != 2) continue;
            ar = (byte[])barrList.get(i);
            System.arraycopy(ar, 0, this.pfbdata, dstPos, ar.length);
            dstPos += ar.length;
        }
        this.lengths[1] = dstPos - this.lengths[0];
        if (cleartomarkSegment != null) {
            System.arraycopy(cleartomarkSegment, 0, this.pfbdata, dstPos, cleartomarkSegment.length);
            this.lengths[2] = cleartomarkSegment.length;
        }
    }

    private byte[] readFully(InputStream in) throws IOException {
        int amountRead;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] tmpbuf = new byte[65535];
        while ((amountRead = in.read(tmpbuf)) != -1) {
            out.write(tmpbuf, 0, amountRead);
        }
        return out.toByteArray();
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public byte[] getPfbdata() {
        return this.pfbdata;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.pfbdata);
    }

    public int size() {
        return this.pfbdata.length;
    }

    public byte[] getSegment1() {
        return Arrays.copyOfRange(this.pfbdata, 0, this.lengths[0]);
    }

    public byte[] getSegment2() {
        return Arrays.copyOfRange(this.pfbdata, this.lengths[0], this.lengths[0] + this.lengths[1]);
    }
}

