/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="exportfdf", header={"Exports AcroForm form data to FDF"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class ExportFDF
implements Callable<Integer> {
    private final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file to export"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the FDF data file"}, required=true)
    private File outfile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new ExportFDF()).execute(args);
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() {
        try (PDDocument pdf = Loader.loadPDF(this.infile);){
            PDAcroForm form = pdf.getDocumentCatalog().getAcroForm();
            if (form == null) {
                this.SYSERR.println("Error: This PDF does not contain a form.");
                Integer n = 1;
                return n;
            }
            if (this.outfile == null) {
                String outPath = FilenameUtils.removeExtension(this.infile.getAbsolutePath()) + ".fdf";
                this.outfile = new File(outPath);
            }
            try (FDFDocument fdf = form.exportFDF();){
                fdf.save(this.outfile);
                return 0;
            }
        }
        catch (IOException ioe) {
            this.SYSERR.println("Error exporting FDF data [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
    }
}

