/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

public final class VariableDescriptor
implements Comparable<VariableDescriptor> {
    private final String name;
    private final String description;
    private final boolean sensitive;

    public VariableDescriptor(String name) {
        this(new Builder(name));
    }

    protected VariableDescriptor(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.sensitive = builder.sensitive;
    }

    @Override
    public int compareTo(VariableDescriptor o) {
        if (o == null) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariableDescriptor)) {
            return false;
        }
        VariableDescriptor desc = (VariableDescriptor)other;
        return this.name.equals(desc.name);
    }

    public int hashCode() {
        return 797 + this.name.hashCode() * 97;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    public static final class Builder {
        private String name = null;
        private String description = "";
        private boolean sensitive = false;

        public Builder(String name) {
            if (null == name || name.isBlank()) {
                throw new IllegalArgumentException("Name must not be null or empty");
            }
            this.name = name.trim();
        }

        public Builder description(String description) {
            if (null != description) {
                this.description = description;
            }
            return this;
        }

        public Builder sensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public VariableDescriptor build() {
            return new VariableDescriptor(this);
        }
    }
}

