/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultResourcesFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRpEntity;
import org.springframework.security.web.webauthn.authentication.PublicKeyCredentialRequestOptionsFilter;
import org.springframework.security.web.webauthn.authentication.WebAuthnAuthenticationFilter;
import org.springframework.security.web.webauthn.authentication.WebAuthnAuthenticationProvider;
import org.springframework.security.web.webauthn.management.MapPublicKeyCredentialUserEntityRepository;
import org.springframework.security.web.webauthn.management.MapUserCredentialRepository;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialUserEntityRepository;
import org.springframework.security.web.webauthn.management.UserCredentialRepository;
import org.springframework.security.web.webauthn.management.WebAuthnRelyingPartyOperations;
import org.springframework.security.web.webauthn.management.Webauthn4JRelyingPartyOperations;
import org.springframework.security.web.webauthn.registration.DefaultWebAuthnRegistrationPageGeneratingFilter;
import org.springframework.security.web.webauthn.registration.PublicKeyCredentialCreationOptionsFilter;
import org.springframework.security.web.webauthn.registration.PublicKeyCredentialCreationOptionsRepository;
import org.springframework.security.web.webauthn.registration.WebAuthnRegistrationFilter;
import org.springframework.util.Assert;

public class WebAuthnConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<WebAuthnConfigurer<H>, H> {
    private String rpId;
    private String rpName;
    private Set<String> allowedOrigins = new HashSet<String>();
    private boolean disableDefaultRegistrationPage = false;
    private PublicKeyCredentialCreationOptionsRepository creationOptionsRepository;
    private HttpMessageConverter<Object> converter;

    public WebAuthnConfigurer<H> rpId(String rpId) {
        Assert.hasText((String)rpId, (String)"rpId be null or empty");
        this.rpId = rpId;
        return this;
    }

    public WebAuthnConfigurer<H> rpName(String rpName) {
        Assert.hasText((String)rpName, (String)"rpName can't be null or empty");
        this.rpName = rpName;
        return this;
    }

    public WebAuthnConfigurer<H> allowedOrigins(String ... allowedOrigins) {
        return this.allowedOrigins(Set.of(allowedOrigins));
    }

    public WebAuthnConfigurer<H> allowedOrigins(Set<String> allowedOrigins) {
        Assert.notNull(allowedOrigins, (String)"allowedOrigins can't be null");
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public WebAuthnConfigurer<H> disableDefaultRegistrationPage(boolean disable) {
        this.disableDefaultRegistrationPage = disable;
        return this;
    }

    public WebAuthnConfigurer<H> messageConverter(HttpMessageConverter<Object> converter) {
        Assert.notNull(converter, (String)"converter can't be null");
        this.converter = converter;
        return this;
    }

    public WebAuthnConfigurer<H> creationOptionsRepository(PublicKeyCredentialCreationOptionsRepository creationOptionsRepository) {
        Assert.notNull((Object)creationOptionsRepository, (String)"creationOptionsRepository can't be null");
        this.creationOptionsRepository = creationOptionsRepository;
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        boolean isLoginPageEnabled;
        UserDetailsService userDetailsService = this.getSharedOrBean(http, UserDetailsService.class).orElseThrow(() -> new IllegalStateException("Missing UserDetailsService Bean"));
        PublicKeyCredentialUserEntityRepository userEntities = this.getSharedOrBean(http, PublicKeyCredentialUserEntityRepository.class).orElse(this.userEntityRepository());
        UserCredentialRepository userCredentials = this.getSharedOrBean(http, UserCredentialRepository.class).orElse((UserCredentialRepository)this.userCredentialRepository());
        WebAuthnRelyingPartyOperations rpOperations = this.webAuthnRelyingPartyOperations(userEntities, userCredentials);
        PublicKeyCredentialCreationOptionsRepository creationOptionsRepository = this.creationOptionsRepository();
        WebAuthnAuthenticationFilter webAuthnAuthnFilter = new WebAuthnAuthenticationFilter();
        webAuthnAuthnFilter.setAuthenticationManager((AuthenticationManager)new ProviderManager(new AuthenticationProvider[]{new WebAuthnAuthenticationProvider(rpOperations, userDetailsService)}));
        WebAuthnRegistrationFilter webAuthnRegistrationFilter = new WebAuthnRegistrationFilter(userCredentials, rpOperations);
        PublicKeyCredentialCreationOptionsFilter creationOptionsFilter = new PublicKeyCredentialCreationOptionsFilter(rpOperations);
        if (creationOptionsRepository != null) {
            webAuthnRegistrationFilter.setCreationOptionsRepository(creationOptionsRepository);
            creationOptionsFilter.setCreationOptionsRepository(creationOptionsRepository);
        }
        if (this.converter != null) {
            webAuthnRegistrationFilter.setConverter(this.converter);
            creationOptionsFilter.setConverter(this.converter);
        }
        http.addFilterBefore((Filter)webAuthnAuthnFilter, BasicAuthenticationFilter.class);
        http.addFilterAfter((Filter)webAuthnRegistrationFilter, AuthorizationFilter.class);
        http.addFilterBefore((Filter)creationOptionsFilter, AuthorizationFilter.class);
        http.addFilterBefore((Filter)new PublicKeyCredentialRequestOptionsFilter(rpOperations), AuthorizationFilter.class);
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        boolean bl = isLoginPageEnabled = loginPageGeneratingFilter != null && loginPageGeneratingFilter.isEnabled();
        if (isLoginPageEnabled) {
            loginPageGeneratingFilter.setPasskeysEnabled(true);
            loginPageGeneratingFilter.setResolveHeaders(request -> {
                CsrfToken csrfToken = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
                return Map.of(csrfToken.getHeaderName(), csrfToken.getToken());
            });
        }
        if (!this.disableDefaultRegistrationPage) {
            http.addFilterAfter((Filter)new DefaultWebAuthnRegistrationPageGeneratingFilter(userEntities, userCredentials), AuthorizationFilter.class);
            if (!isLoginPageEnabled) {
                http.addFilter((Filter)DefaultResourcesFilter.css());
            }
        }
        if (isLoginPageEnabled || !this.disableDefaultRegistrationPage) {
            http.addFilter((Filter)DefaultResourcesFilter.webauthn());
        }
    }

    private PublicKeyCredentialCreationOptionsRepository creationOptionsRepository() {
        if (this.creationOptionsRepository != null) {
            return this.creationOptionsRepository;
        }
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        return (PublicKeyCredentialCreationOptionsRepository)context.getBeanProvider(PublicKeyCredentialCreationOptionsRepository.class).getIfUnique();
    }

    private <C> Optional<C> getSharedOrBean(H http, Class<C> type) {
        C shared = http.getSharedObject(type);
        return Optional.ofNullable(shared).or(() -> this.getBeanOrNull(type));
    }

    private <T> Optional<T> getBeanOrNull(Class<T> type) {
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        if (context == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(context.getBean(type));
        }
        catch (NoSuchBeanDefinitionException ex) {
            return Optional.empty();
        }
    }

    private MapUserCredentialRepository userCredentialRepository() {
        return new MapUserCredentialRepository();
    }

    private PublicKeyCredentialUserEntityRepository userEntityRepository() {
        return new MapPublicKeyCredentialUserEntityRepository();
    }

    private WebAuthnRelyingPartyOperations webAuthnRelyingPartyOperations(PublicKeyCredentialUserEntityRepository userEntities, UserCredentialRepository userCredentials) {
        Optional<WebAuthnRelyingPartyOperations> webauthnOperationsBean = this.getBeanOrNull(WebAuthnRelyingPartyOperations.class);
        String rpName = this.rpName != null ? this.rpName : this.rpId;
        return webauthnOperationsBean.orElseGet(() -> new Webauthn4JRelyingPartyOperations(userEntities, userCredentials, PublicKeyCredentialRpEntity.builder().id(this.rpId).name(rpName).build(), this.allowedOrigins));
    }
}

