/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.annotations;

import java.util.Objects;
import org.eclipse.jetty.ee10.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee10.annotations.DeclareRolesAnnotationHandler;
import org.eclipse.jetty.ee10.annotations.MultiPartConfigAnnotationHandler;
import org.eclipse.jetty.ee10.annotations.PostConstructAnnotationHandler;
import org.eclipse.jetty.ee10.annotations.PreDestroyAnnotationHandler;
import org.eclipse.jetty.ee10.annotations.ResourceAnnotationHandler;
import org.eclipse.jetty.ee10.annotations.ResourcesAnnotationHandler;
import org.eclipse.jetty.ee10.annotations.RunAsAnnotationHandler;
import org.eclipse.jetty.ee10.annotations.ServletSecurityAnnotationHandler;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;

public class AnnotationDecorator
implements Decorator {
    protected AnnotationIntrospector _introspector;
    protected WebAppContext _context;

    public AnnotationDecorator(WebAppContext context) {
        this._context = Objects.requireNonNull(context);
        this._introspector = new AnnotationIntrospector(this._context);
        this.registerHandlers();
    }

    private void registerHandlers() {
        this._introspector.registerHandler(new ResourceAnnotationHandler(this._context));
        this._introspector.registerHandler(new ResourcesAnnotationHandler(this._context));
        this._introspector.registerHandler(new RunAsAnnotationHandler(this._context));
        this._introspector.registerHandler(new PostConstructAnnotationHandler(this._context));
        this._introspector.registerHandler(new PreDestroyAnnotationHandler(this._context));
        this._introspector.registerHandler(new DeclareRolesAnnotationHandler(this._context));
        this._introspector.registerHandler(new MultiPartConfigAnnotationHandler(this._context));
        this._introspector.registerHandler(new ServletSecurityAnnotationHandler(this._context));
    }

    protected void introspect(Object o, Object metaInfo) {
        if (o == null) {
            return;
        }
        this._introspector.introspect(o, metaInfo);
    }

    public <T> T decorate(T o) {
        this.introspect(o, DecoratedObjectFactory.getAssociatedInfo());
        return o;
    }

    public void destroy(Object o) {
    }
}

