/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.processor.DataUnit;

public class MaxLengthInputStream
extends InputStream {
    private static final String ERROR_MESSAGE_FORMAT = "Unable to read past maximum allowed length of %s %s";
    private final InputStream in;
    private final long limit;
    private long bytesRead = 0L;
    private long markOffset = -1L;
    private final String errorMessage;

    public MaxLengthInputStream(InputStream in, long limit) {
        this.in = in;
        this.limit = limit + 1L;
        this.errorMessage = (double)limit >= DataUnit.MB.toB(1.0) ? ERROR_MESSAGE_FORMAT.formatted(DataUnit.B.toMB((double)limit), "MB") : ERROR_MESSAGE_FORMAT.formatted(limit, "B");
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead >= this.limit) {
            throw new IOException(this.errorMessage);
        }
        int val = this.in.read();
        if (val > -1) {
            ++this.bytesRead;
        }
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRead >= this.limit) {
            throw new IOException(this.errorMessage);
        }
        int maxToRead = (int)Math.min((long)len, this.limit - this.bytesRead);
        int val = this.in.read(b, off, maxToRead);
        if (val > 0) {
            this.bytesRead += (long)val;
            if (this.bytesRead >= this.limit) {
                throw new IOException(this.errorMessage);
            }
        }
        return val;
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkip = Math.min(n, this.limit - this.bytesRead);
        long skipped = this.in.skip(toSkip);
        this.bytesRead += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markOffset = this.bytesRead;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        if (this.markOffset >= 0L) {
            this.bytesRead = this.markOffset;
        }
        this.markOffset = -1L;
    }

    public long getLimit() {
        return this.limit;
    }
}

