/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.ArrayType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ArrayStringConversions {
    static boolean canContainArrays(CompilationInfo ci, TreePath tp) {
        TypeMirror tm = ci.getTrees().getTypeMirror(tp);
        if (!Utilities.isValidType(tm)) {
            return false;
        }
        tm = ci.getTypes().erasure(tm);
        if (tm == null || tm.getKind() != TypeKind.ARRAY) {
            return false;
        }
        ArrayType arrayType = (ArrayType)tm;
        TypeMirror ct = arrayType.getComponentType();
        boolean enableDeep = false;
        if (ct.getKind() == TypeKind.ARRAY) {
            enableDeep = true;
        } else if (ct.getKind() == TypeKind.DECLARED) {
            TypeElement obj = ci.getElements().getTypeElement("java.lang.Object");
            if (obj == null) {
                return false;
            }
            enableDeep = ci.getTypes().isSameType(obj.asType(), ct);
        }
        return enableDeep;
    }

    public static ErrorDescription arrayToString(HintContext ctx) {
        TreePath arrayRef = ctx.getVariables().get("$v");
        boolean deep = ArrayStringConversions.canContainArrays(ctx.getInfo(), arrayRef);
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_ToStringCalledOnArray(), new ArraysToStringFix(false, true, ctx.getInfo(), ctx.getPath()).toEditorFix(), deep ? new ArraysToStringFix(true, true, ctx.getInfo(), ctx.getPath()).toEditorFix() : null);
    }

    public static ErrorDescription printPrintStream(HintContext ctx) {
        return ArrayStringConversions.printStreamWriter(ctx, Bundle.TEXT_ArrayPrintedOnStream());
    }

    public static ErrorDescription printlnPrintStream(HintContext ctx) {
        TreePath arrayRef = ctx.getVariables().get("$v");
        TypeMirror m = ctx.getInfo().getTrees().getTypeMirror(arrayRef);
        if (!Utilities.isValidType(m) || m.getKind() == TypeKind.NULL) {
            return null;
        }
        return ArrayStringConversions.printPrintStream(ctx);
    }

    public static List<ErrorDescription> formatPrintStream(HintContext ctx) {
        return ArrayStringConversions.arrayFormatted(ctx, Bundle.TEXT_ArrayFormatParameter());
    }

    public static List<ErrorDescription> printfPrintStream(HintContext ctx) {
        return ArrayStringConversions.arrayFormatted(ctx, Bundle.TEXT_ArrayFormatParameter());
    }

    public static ErrorDescription printPrintWriter(HintContext ctx) {
        return ArrayStringConversions.printStreamWriter(ctx, Bundle.TEXT_ArrayPrintedOnWriter());
    }

    public static ErrorDescription printlnPrintWriter(HintContext ctx) {
        return ArrayStringConversions.printPrintWriter(ctx);
    }

    public static List<ErrorDescription> printfPrintWriter(HintContext ctx) {
        return ArrayStringConversions.arrayFormatted(ctx, Bundle.TEXT_ArrayFormatParameter());
    }

    public static List<ErrorDescription> formatPrintWriter(HintContext ctx) {
        return ArrayStringConversions.arrayFormatted(ctx, Bundle.TEXT_ArrayFormatParameter());
    }

    private static ErrorDescription printStreamWriter(HintContext ctx, String text) {
        TreePath arrayRef = ctx.getVariables().get("$v");
        boolean deep = ArrayStringConversions.canContainArrays(ctx.getInfo(), arrayRef);
        return ErrorDescriptionFactory.forTree(ctx, arrayRef, text, new ArraysToStringFix(false, false, ctx.getInfo(), arrayRef).toEditorFix(), deep ? new ArraysToStringFix(true, false, ctx.getInfo(), arrayRef).toEditorFix() : null);
    }

    private static List<ErrorDescription> arrayFormatted(HintContext ctx, String text) {
        if (ctx.getPath().getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        ArrayList<ErrorDescription> ret = new ArrayList<ErrorDescription>(2);
        CompilationInfo ci = ctx.getInfo();
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        TreePath arrayRef = ctx.getVariables().get("$v");
        TypeMirror m = ctx.getInfo().getTrees().getTypeMirror(arrayRef);
        if (!Utilities.isValidType(m) || m.getKind() == TypeKind.NULL) {
            return null;
        }
        Element e = ci.getTrees().getElement(ctx.getPath());
        if (e == null || !(e instanceof ExecutableElement)) {
            return null;
        }
        ExecutableElement el = (ExecutableElement)e;
        boolean isVarArgs = el.isVarArgs();
        for (int index = mit.getArguments().indexOf(arrayRef.getLeaf()); index < mit.getArguments().size(); ++index) {
            TypeMirror argType;
            Tree arg = mit.getArguments().get(index);
            TreePath argPath = new TreePath(ctx.getPath(), arg);
            if (arg != arrayRef.getLeaf() && ((argType = ci.getTrees().getTypeMirror(argPath)) == null || argType.getKind() != TypeKind.ARRAY) || arg.getKind() == Tree.Kind.NULL_LITERAL) continue;
            if (isVarArgs && index == el.getParameters().size() - 1 && index == mit.getArguments().size() - 1) {
                argType = ci.getTrees().getTypeMirror(argPath);
                if (ci.getTypes().isSameType(argType, el.getParameters().get(el.getParameters().size() - 1).asType())) continue;
            }
            boolean deep = ArrayStringConversions.canContainArrays(ctx.getInfo(), argPath);
            ret.add(ErrorDescriptionFactory.forTree(ctx, argPath, text, new ArraysToStringFix(false, false, ctx.getInfo(), argPath).toEditorFix(), deep ? new ArraysToStringFix(true, false, ctx.getInfo(), argPath).toEditorFix() : null));
        }
        return ret;
    }

    public static List<ErrorDescription> messageFormatStatic(HintContext ctx) {
        return ArrayStringConversions.arrayFormatted(ctx, Bundle.TEXT_ArrayFormatParameter());
    }

    public static List<ErrorDescription> messageFormatInstance(HintContext ctx) {
        return ArrayStringConversions.arrayFormatted(ctx, Bundle.TEXT_ArrayFormatParameter());
    }

    public static List<ErrorDescription> stringFormat(HintContext ctx) {
        return ArrayStringConversions.arrayFormatted(ctx, Bundle.TEXT_ArrayFormatParameter());
    }

    public static ErrorDescription stringConcatenation(HintContext ctx) {
        TreePath vPath = ctx.getVariables().get("$v");
        TypeMirror m = ctx.getInfo().getTrees().getTypeMirror(vPath);
        if (!Utilities.isValidType(m) || m.getKind() == TypeKind.NULL) {
            return null;
        }
        boolean deep = ArrayStringConversions.canContainArrays(ctx.getInfo(), vPath);
        return ErrorDescriptionFactory.forTree(ctx, vPath, Bundle.TEXT_ArrayConcatenatedToString(), new ArraysToStringFix(false, false, ctx.getInfo(), vPath).toEditorFix(), deep ? new ArraysToStringFix(true, false, ctx.getInfo(), vPath).toEditorFix() : null);
    }

    private static final class ArraysToStringFix
    extends JavaFix {
        private final boolean deep;
        private final boolean arraySelect;

        public ArraysToStringFix(boolean deep, boolean arraySelect, CompilationInfo info, TreePath tp) {
            super(info, tp);
            this.deep = deep;
            this.arraySelect = arraySelect;
        }

        @Override
        protected String getText() {
            return this.deep ? Bundle.FIX_WrapUsingArraysAsDeepList() : Bundle.FIX_WrapUsingArraysAsList();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            ExpressionTree arrayExpr;
            TreeMaker maker = ctx.getWorkingCopy().getTreeMaker();
            Tree t = ctx.getPath().getLeaf();
            if (this.arraySelect) {
                if (t.getKind() != Tree.Kind.METHOD_INVOCATION) {
                    return;
                }
                MethodInvocationTree mtt = (MethodInvocationTree)ctx.getPath().getLeaf();
                if (mtt.getMethodSelect().getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                MemberSelectTree selector = (MemberSelectTree)mtt.getMethodSelect();
                arrayExpr = selector.getExpression();
            } else {
                arrayExpr = (ExpressionTree)t;
            }
            MemberSelectTree ms = maker.MemberSelect(maker.QualIdent("java.util.Arrays"), this.deep ? "deepToString" : "toString");
            MethodInvocationTree nue = maker.MethodInvocation(Collections.emptyList(), ms, Collections.singletonList(arrayExpr));
            ctx.getWorkingCopy().rewrite(t, nue);
        }
    }
}

