/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Objects;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.PathMatcherFactory;
import org.apache.maven.impl.PathSelector;

@Named
@Singleton
public class DefaultPathMatcherFactory
implements PathMatcherFactory {
    @Nonnull
    public PathMatcher createPathMatcher(@Nonnull Path baseDirectory, Collection<String> includes, Collection<String> excludes, boolean useDefaultExcludes) {
        Objects.requireNonNull(baseDirectory, "baseDirectory cannot be null");
        return PathSelector.of(baseDirectory, includes, excludes, useDefaultExcludes);
    }

    @Nonnull
    public PathMatcher createExcludeOnlyMatcher(@Nonnull Path baseDirectory, Collection<String> excludes, boolean useDefaultExcludes) {
        return this.createPathMatcher(baseDirectory, null, excludes, useDefaultExcludes);
    }

    @Nonnull
    public PathMatcher deriveDirectoryMatcher(@Nonnull PathMatcher fileMatcher) {
        PathSelector selector;
        PathMatcher pathMatcher = Objects.requireNonNull(fileMatcher);
        if (pathMatcher instanceof PathSelector && (selector = (PathSelector)pathMatcher).canFilterDirectories()) {
            return selector::couldHoldSelected;
        }
        return PathSelector.INCLUDES_ALL;
    }

    @Nonnull
    public PathMatcher includesAll() {
        return PathSelector.INCLUDES_ALL;
    }
}

