/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.Node;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.impl.AbstractNode;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.MappedList;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;

public class DefaultNode
extends AbstractNode {
    @Nonnull
    protected final InternalSession session;
    @Nonnull
    protected final DependencyNode node;
    protected final boolean verbose;

    public DefaultNode(@Nonnull InternalSession session, @Nonnull DependencyNode node, boolean verbose) {
        this.session = session;
        this.node = node;
        this.verbose = verbose;
    }

    @Override
    DependencyNode getDependencyNode() {
        return this.node;
    }

    public org.apache.maven.api.Artifact getArtifact() {
        return this.node.getArtifact() != null ? this.session.getArtifact(this.node.getArtifact()) : null;
    }

    public org.apache.maven.api.Dependency getDependency() {
        return this.node.getDependency() != null ? this.session.getDependency(this.node.getDependency()) : null;
    }

    public List<Node> getChildren() {
        return new MappedList<Node, DependencyNode>(this.node.getChildren(), n -> this.session.getNode((DependencyNode)n, this.verbose));
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return new MappedList<RemoteRepository, org.eclipse.aether.repository.RemoteRepository>(this.node.getRepositories(), this.session::getRemoteRepository);
    }

    public Optional<RemoteRepository> getRepository() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nonnull
    public String asString() {
        String originalScope;
        String preManagedScope;
        StringBuilder sb = new StringBuilder();
        DependencyNode node = this.getDependencyNode();
        Artifact artifact = node.getArtifact();
        Dependency dependency = node.getDependency();
        if (!this.verbose) {
            sb.append(artifact);
            if (dependency != null) {
                sb.append(":").append(dependency.getScope());
            }
            return sb.toString();
        }
        ArrayList<String> details = new ArrayList<String>();
        DependencyNode winner = (DependencyNode)node.getData().get("conflict.winner");
        String winnerVersion = winner != null ? winner.getArtifact().getBaseVersion() : null;
        boolean included = winnerVersion == null;
        String preManagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node);
        if (preManagedVersion != null) {
            details.add("version managed from " + preManagedVersion);
        }
        if ((preManagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)node)) != null) {
            details.add("scope managed from " + preManagedScope);
        }
        if ((originalScope = (String)node.getData().get("conflict.originalScope")) != null && !originalScope.equals(dependency.getScope())) {
            details.add("scope updated from " + originalScope);
        }
        if (!included) {
            if (Objects.equals(winnerVersion, artifact.getVersion())) {
                details.add("omitted for duplicate");
            } else {
                details.add("omitted for conflict with " + winnerVersion);
            }
        }
        if (!included) {
            sb.append('(');
        }
        sb.append(artifact);
        if (dependency != null) {
            sb.append(":").append(dependency.getScope());
        }
        if (!details.isEmpty()) {
            sb.append(included ? " (" : " - ");
            DefaultNode.appendDetails(sb, details);
            if (included) {
                sb.append(')');
            }
        }
        if (!included) {
            sb.append(')');
        }
        return sb.toString();
    }

    private static void appendDetails(StringBuilder sb, List<String> details) {
        boolean first = true;
        for (String detail : details) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(detail);
        }
    }
}

