/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.Objects;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.Exclusion;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.DependencyCoordinatesFactory;
import org.apache.maven.api.services.DependencyCoordinatesFactoryRequest;
import org.apache.maven.impl.DefaultDependencyCoordinates;
import org.apache.maven.impl.ImplUtils;
import org.apache.maven.impl.InternalSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;

@Named
@Singleton
public class DefaultDependencyCoordinatesFactory
implements DependencyCoordinatesFactory {
    @Nonnull
    public DependencyCoordinates create(@Nonnull DependencyCoordinatesFactoryRequest request) {
        Objects.requireNonNull(request, "request");
        InternalSession session = InternalSession.from((Session)request.getSession());
        ArtifactType type = null;
        if (request.getType() != null) {
            type = session.getSession().getArtifactTypeRegistry().get(request.getType());
        }
        if (request.getCoordinatesString() != null) {
            return new DefaultDependencyCoordinates(session, new Dependency((Artifact)new DefaultArtifact(request.getCoordinatesString()), request.getScope(), Boolean.valueOf(request.isOptional()), ImplUtils.map(request.getExclusions(), this::toExclusion)));
        }
        return new DefaultDependencyCoordinates(session, new Dependency((Artifact)new DefaultArtifact(request.getGroupId(), request.getArtifactId(), request.getClassifier(), request.getExtension(), request.getVersion(), type), request.getScope(), Boolean.valueOf(request.isOptional()), ImplUtils.map(request.getExclusions(), this::toExclusion)));
    }

    private org.eclipse.aether.graph.Exclusion toExclusion(Exclusion exclusion) {
        return new org.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }
}

