/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractor;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporter;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporterException;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.jdk.JdkTransporterCloser;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdkTransporter
extends AbstractTransporter
implements HttpTransporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkTransporter.class);
    private static final DateTimeFormatter RFC7231 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    private static final long MODIFICATION_THRESHOLD = 60000L;
    private final ChecksumExtractor checksumExtractor;
    private final PathProcessor pathProcessor;
    private final URI baseUri;
    private final HttpClient client;
    private final Map<String, String> headers;
    private final int connectTimeout;
    private final int requestTimeout;
    private final Boolean expectContinue;
    private final Semaphore maxConcurrentRequests;

    JdkTransporter(RepositorySystemSession session, RemoteRepository repository, int javaVersion, ChecksumExtractor checksumExtractor, PathProcessor pathProcessor) throws NoTransporterException {
        Map configuredHeaders;
        this.checksumExtractor = checksumExtractor;
        this.pathProcessor = pathProcessor;
        try {
            URI uri = new URI(repository.getUrl()).parseServerAuthority();
            if (uri.isOpaque()) {
                throw new URISyntaxException(repository.getUrl(), "URL must not be opaque");
            }
            if (uri.getRawFragment() != null || uri.getRawQuery() != null) {
                throw new URISyntaxException(repository.getUrl(), "URL must not have fragment or query");
            }
            Object path = uri.getPath();
            if (path == null) {
                path = "/";
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            this.baseUri = URI.create(uri.getScheme() + "://" + uri.getRawAuthority() + (String)path);
        }
        catch (URISyntaxException e) {
            throw new NoTransporterException(repository, e.getMessage(), (Throwable)e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String userAgent = ConfigUtils.getString((RepositorySystemSession)session, (String)"Aether", (String[])new String[]{"aether.transport.http.userAgent"});
        if (userAgent != null) {
            headers.put("User-Agent", userAgent);
        }
        if ((configuredHeaders = ConfigUtils.getMap((RepositorySystemSession)session, Collections.emptyMap(), (String[])new String[]{"aether.transport.http.headers." + repository.getId(), "aether.transport.http.headers"})) != null) {
            configuredHeaders.forEach((k, v) -> headers.put(String.valueOf(k), v != null ? String.valueOf(v) : null));
        }
        headers.put("Cache-Control", "no-cache, no-store");
        this.connectTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)30000, (String[])new String[]{"aether.transport.http.connectTimeout." + repository.getId(), "aether.transport.http.connectTimeout"});
        this.requestTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)1800000, (String[])new String[]{"aether.transport.http.requestTimeout." + repository.getId(), "aether.transport.http.requestTimeout"});
        String expectContinueConf = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.transport.http.expectContinue." + repository.getId(), "aether.transport.http.expectContinue"});
        if (javaVersion > 19) {
            this.expectContinue = expectContinueConf == null ? null : Boolean.valueOf(Boolean.parseBoolean(expectContinueConf));
        } else {
            this.expectContinue = null;
            if (expectContinueConf != null) {
                LOGGER.warn("Configuration for Expect-Continue set but is ignored on Java versions below 20 (current java version is {}) due https://bugs.openjdk.org/browse/JDK-8286171", (Object)javaVersion);
            }
        }
        String httpsSecurityMode = ConfigUtils.getString((RepositorySystemSession)session, (String)"default", (String[])new String[]{"aether.transport.https.securityMode." + repository.getId(), "aether.transport.https.securityMode"});
        if (!"default".equals(httpsSecurityMode) && !"insecure".equals(httpsSecurityMode)) {
            throw new IllegalArgumentException("Unsupported '" + httpsSecurityMode + "' HTTPS security mode.");
        }
        boolean insecure = "insecure".equals(httpsSecurityMode);
        this.maxConcurrentRequests = new Semaphore(ConfigUtils.getInteger((RepositorySystemSession)session, (int)100, (String[])new String[]{"aether.transport.jdk.maxConcurrentRequests." + repository.getId(), "aether.transport.jdk.maxConcurrentRequests"}));
        this.headers = headers;
        this.client = this.createClient(session, repository, insecure);
    }

    private URI resolve(TransportTask task) {
        return this.baseUri.resolve(task.getLocation());
    }

    private ConnectException enhance(ConnectException connectException) {
        ConnectException result = new ConnectException("Connection to " + this.baseUri.toASCIIString() + " refused");
        result.initCause(connectException);
        return result;
    }

    public int classify(Throwable error) {
        if (error instanceof HttpTransporterException && ((HttpTransporterException)error).getStatusCode() == 404) {
            return 1;
        }
        return 0;
    }

    protected void implPeek(PeekTask task) throws Exception {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(this.resolve((TransportTask)task)).method("HEAD", HttpRequest.BodyPublishers.noBody());
        this.headers.forEach(request::setHeader);
        try {
            HttpResponse<Void> response = this.send(request.build(), HttpResponse.BodyHandlers.discarding());
            if (response.statusCode() >= 300) {
                throw new HttpTransporterException(response.statusCode());
            }
        }
        catch (ConnectException e) {
            throw this.enhance(e);
        }
    }

    /*
     * Exception decompiling
     */
    protected void implGet(GetTask task) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [33[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Function<String, String> headerGetter(HttpResponse<?> response) {
        return s -> response.headers().firstValue((String)s).orElse(null);
    }

    private void closeBody(HttpResponse<InputStream> streamHttpResponse) throws IOException {
        InputStream body;
        if (streamHttpResponse != null && (body = streamHttpResponse.body()) != null) {
            body.close();
        }
    }

    protected void implPut(PutTask task) throws Exception {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(this.resolve((TransportTask)task));
        if (this.expectContinue != null) {
            request = request.expectContinue(this.expectContinue);
        }
        this.headers.forEach(request::setHeader);
        try (PathProcessor.TempFile tempFile = this.pathProcessor.newTempFile();){
            this.utilPut(task, Files.newOutputStream(tempFile.getPath(), new OpenOption[0]), true);
            request.PUT(HttpRequest.BodyPublishers.ofFile(tempFile.getPath()));
            try {
                HttpResponse<Void> response = this.send(request.build(), HttpResponse.BodyHandlers.discarding());
                if (response.statusCode() >= 300) {
                    throw new HttpTransporterException(response.statusCode());
                }
            }
            catch (ConnectException e) {
                throw this.enhance(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws Exception {
        this.maxConcurrentRequests.acquire();
        try {
            HttpResponse<T> httpResponse = this.client.send(request, responseBodyHandler);
            return httpResponse;
        }
        finally {
            this.maxConcurrentRequests.release();
        }
    }

    protected void implClose() {
        if (this.client != null) {
            JdkTransporterCloser.closer(this.client).run();
        }
    }

    private HttpClient createClient(RepositorySystemSession session, RemoteRepository repository, boolean insecure) throws RuntimeException {
        final HashMap<Authenticator.RequestorType, PasswordAuthentication> authentications = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();
        SSLContext sslContext = null;
        try (AuthenticationContext repoAuthContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository);){
            if (repoAuthContext != null) {
                sslContext = (SSLContext)repoAuthContext.get("ssl.context", SSLContext.class);
                String username = repoAuthContext.get("username");
                String password = repoAuthContext.get("password");
                authentications.put(Authenticator.RequestorType.SERVER, new PasswordAuthentication(username, password.toCharArray()));
            }
        }
        if (sslContext == null) {
            try {
                if (insecure) {
                    sslContext = SSLContext.getInstance("TLS");
                    X509ExtendedTrustManager tm = new X509ExtendedTrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }
                    };
                    sslContext.init(null, new X509TrustManager[]{tm}, null);
                } else {
                    sslContext = SSLContext.getDefault();
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException("SSL Context setup failure", e);
            }
        }
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.valueOf(ConfigUtils.getString((RepositorySystemSession)session, (String)"HTTP_1_1", (String[])new String[]{"aether.transport.jdk.httpVersion." + repository.getId(), "aether.transport.jdk.httpVersion"}))).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(this.connectTimeout)).sslContext(sslContext);
        if (insecure) {
            SSLParameters sslParameters = sslContext.getDefaultSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(null);
            builder.sslParameters(sslParameters);
        }
        JdkTransporter.setLocalAddress(builder, () -> JdkTransporter.getHttpLocalAddress(session, repository));
        if (repository.getProxy() != null) {
            ProxySelector proxy = ProxySelector.of(new InetSocketAddress(repository.getProxy().getHost(), repository.getProxy().getPort()));
            builder.proxy(proxy);
            try (AuthenticationContext proxyAuthContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);){
                if (proxyAuthContext != null) {
                    String username = proxyAuthContext.get("username");
                    String password = proxyAuthContext.get("password");
                    authentications.put(Authenticator.RequestorType.PROXY, new PasswordAuthentication(username, password.toCharArray()));
                }
            }
        }
        if (!authentications.isEmpty()) {
            builder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return (PasswordAuthentication)authentications.get((Object)this.getRequestorType());
                }
            });
        }
        return builder.build();
    }

    private static InetAddress getHttpLocalAddress(RepositorySystemSession session, RemoteRepository repository) {
        String bindAddress = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{"aether.transport.http.localAddress." + repository.getId(), "aether.transport.http.localAddress"});
        if (bindAddress == null) {
            return null;
        }
        try {
            return InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("Given bind address (" + bindAddress + ") cannot be resolved for remote repository " + String.valueOf(repository), uhe);
        }
    }

    private static void setLocalAddress(HttpClient.Builder builder, Supplier<InetAddress> addressSupplier) {
        try {
            InetAddress address = addressSupplier.get();
            if (address == null) {
                return;
            }
            Method mtd = builder.getClass().getDeclaredMethod("localAddress", InetAddress.class);
            if (!mtd.canAccess(builder)) {
                mtd.setAccessible(true);
            }
            mtd.invoke((Object)builder, address);
        }
        catch (NoSuchMethodException address) {
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static /* synthetic */ void lambda$implGet$1(Integer statusCode, String reasonPhrase) throws HttpTransporterException {
        throw new HttpTransporterException(statusCode.intValue());
    }
}

