/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.model.BaseObject;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.WrapperList;

@Generated
public class Plugin
extends ConfigurationContainer
implements Serializable,
Cloneable {
    public Plugin() {
        this(org.apache.maven.api.model.Plugin.newInstance());
    }

    public Plugin(org.apache.maven.api.model.Plugin delegate) {
        this(delegate, (BaseObject)null);
    }

    public Plugin(org.apache.maven.api.model.Plugin delegate, BaseObject parent) {
        super((org.apache.maven.api.model.ConfigurationContainer)delegate, parent);
    }

    @Override
    public Plugin clone() {
        return new Plugin(this.getDelegate());
    }

    public org.apache.maven.api.model.Plugin getDelegate() {
        return (org.apache.maven.api.model.Plugin)super.getDelegate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Plugin)) {
            return false;
        }
        Plugin that = (Plugin)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public String getGroupId() {
        return this.getDelegate().getGroupId();
    }

    public void setGroupId(String groupId) {
        if (!Objects.equals(groupId, this.getGroupId())) {
            this.update(this.getDelegate().withGroupId(groupId));
        }
    }

    public String getArtifactId() {
        return this.getDelegate().getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        if (!Objects.equals(artifactId, this.getArtifactId())) {
            this.update(this.getDelegate().withArtifactId(artifactId));
        }
    }

    public String getVersion() {
        return this.getDelegate().getVersion();
    }

    public void setVersion(String version) {
        if (!Objects.equals(version, this.getVersion())) {
            this.update(this.getDelegate().withVersion(version));
        }
    }

    public String getExtensions() {
        return this.getDelegate().getExtensions();
    }

    public void setExtensions(String extensions) {
        if (!Objects.equals(extensions, this.getExtensions())) {
            this.update(this.getDelegate().withExtensions(extensions));
        }
    }

    @Nonnull
    public List<PluginExecution> getExecutions() {
        return new WrapperList<PluginExecution, org.apache.maven.api.model.PluginExecution>(() -> this.getDelegate().getExecutions(), l -> this.update(this.getDelegate().withExecutions((Collection)l)), d -> new PluginExecution((org.apache.maven.api.model.PluginExecution)d, (BaseObject)this), PluginExecution::getDelegate);
    }

    public void setExecutions(List<PluginExecution> executions) {
        if (executions == null) {
            executions = Collections.emptyList();
        }
        if (!Objects.equals(executions, this.getExecutions())) {
            this.update(this.getDelegate().withExecutions((Collection)executions.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            executions.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addExecution(PluginExecution execution) {
        this.update(this.getDelegate().withExecutions((Collection)Stream.concat(this.getDelegate().getExecutions().stream(), Stream.of(execution.getDelegate())).collect(Collectors.toList())));
        execution.childrenTracking = this::replace;
    }

    public void removeExecution(PluginExecution execution) {
        this.update(this.getDelegate().withExecutions((Collection)this.getDelegate().getExecutions().stream().filter(e -> !Objects.equals(e, execution)).collect(Collectors.toList())));
        execution.childrenTracking = null;
    }

    @Nonnull
    public List<Dependency> getDependencies() {
        return new WrapperList<Dependency, org.apache.maven.api.model.Dependency>(() -> this.getDelegate().getDependencies(), l -> this.update(this.getDelegate().withDependencies((Collection)l)), d -> new Dependency((org.apache.maven.api.model.Dependency)d, (BaseObject)this), Dependency::getDelegate);
    }

    public void setDependencies(List<Dependency> dependencies) {
        if (dependencies == null) {
            dependencies = Collections.emptyList();
        }
        if (!Objects.equals(dependencies, this.getDependencies())) {
            this.update(this.getDelegate().withDependencies((Collection)dependencies.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            dependencies.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addDependency(Dependency dependency) {
        this.update(this.getDelegate().withDependencies((Collection)Stream.concat(this.getDelegate().getDependencies().stream(), Stream.of(dependency.getDelegate())).collect(Collectors.toList())));
        dependency.childrenTracking = this::replace;
    }

    public void removeDependency(Dependency dependency) {
        this.update(this.getDelegate().withDependencies((Collection)this.getDelegate().getDependencies().stream().filter(e -> !Objects.equals(e, dependency)).collect(Collectors.toList())));
        dependency.childrenTracking = null;
    }

    @Override
    public InputLocation getLocation(Object key) {
        org.apache.maven.api.model.InputLocation loc = this.getDelegate().getLocation(key);
        return loc != null ? new InputLocation(loc) : null;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        this.update(org.apache.maven.api.model.Plugin.newBuilder((org.apache.maven.api.model.Plugin)this.getDelegate(), (boolean)true).location(key, location != null ? location.toApiLocation() : null).build());
    }

    @Override
    public InputLocation getImportedFrom() {
        org.apache.maven.api.model.InputLocation loc = this.getDelegate().getImportedFrom();
        return loc != null ? new InputLocation(loc) : null;
    }

    @Override
    public void setImportedFrom(InputLocation location) {
        this.update(org.apache.maven.api.model.Plugin.newBuilder((org.apache.maven.api.model.Plugin)this.getDelegate(), (boolean)true).importedFrom(location != null ? location.toApiLocation() : null).build());
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.getDelegate().getLocationKeys();
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (this.getDelegate().getExecutions().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getExecutions());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.PluginExecution)newDelegate : d);
            this.update(this.getDelegate().withExecutions(list));
            return true;
        }
        if (this.getDelegate().getDependencies().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getDependencies());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.Dependency)newDelegate : d);
            this.update(this.getDelegate().withDependencies(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.model.Plugin> pluginToApiV4(List<Plugin> list) {
        return list != null ? new WrapperList<org.apache.maven.api.model.Plugin, Plugin>(list, Plugin::getDelegate, Plugin::new) : null;
    }

    public static List<Plugin> pluginToApiV3(List<org.apache.maven.api.model.Plugin> list) {
        return list != null ? new WrapperList<Plugin, org.apache.maven.api.model.Plugin>(list, Plugin::new, Plugin::getDelegate) : null;
    }

    public boolean isExtensions() {
        return this.getExtensions() != null ? Boolean.parseBoolean(this.getExtensions()) : false;
    }

    public void setExtensions(boolean extensions) {
        this.setExtensions(String.valueOf(extensions));
    }

    @Deprecated
    public void flushExecutionMap() {
    }

    public Map<String, PluginExecution> getExecutionsAsMap() {
        return this.getExecutions().stream().collect(Collectors.toMap(exec -> exec.getId(), exec -> exec));
    }

    public String getId() {
        return new StringBuilder(128).append(this.getGroupId() == null ? "[unknown-group-id]" : this.getGroupId()).append(":").append(this.getArtifactId() == null ? "[unknown-artifact-id]" : this.getArtifactId()).append(":").append(this.getVersion() == null ? "[unknown-version]" : this.getVersion()).toString();
    }

    public String getKey() {
        return Plugin.constructKey(this.getGroupId(), this.getArtifactId());
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }
}

