/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.RepositoryAwareRequest;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.api.services.Source;

@Experimental
@Immutable
public interface ProjectBuilderRequest
extends RepositoryAwareRequest {
    @Nonnull
    public Optional<Path> getPath();

    @Nonnull
    public Optional<Source> getSource();

    public boolean isAllowStubModel();

    public boolean isRecursive();

    public boolean isProcessPlugins();

    @Override
    @Nullable
    public List<RemoteRepository> getRepositories();

    @Nonnull
    public static ProjectBuilderRequest build(@Nonnull Session session, @Nonnull Source source) {
        return ProjectBuilderRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).source(Objects.requireNonNull(source, "source cannot be null")).build();
    }

    @Nonnull
    public static ProjectBuilderRequest build(@Nonnull Session session, @Nonnull Path path) {
        return ProjectBuilderRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).path(Objects.requireNonNull(path, "path cannot be null")).build();
    }

    @Nonnull
    public static ProjectBuilderRequestBuilder builder() {
        return new ProjectBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class ProjectBuilderRequestBuilder {
        Session session;
        RequestTrace trace;
        Path path;
        Source source;
        boolean allowStubModel;
        boolean recursive;
        boolean processPlugins = true;
        List<RemoteRepository> repositories;

        ProjectBuilderRequestBuilder() {
        }

        public ProjectBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ProjectBuilderRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        public ProjectBuilderRequestBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public ProjectBuilderRequestBuilder source(Source source) {
            this.source = source;
            return this;
        }

        public ProjectBuilderRequestBuilder processPlugins(boolean processPlugins) {
            this.processPlugins = processPlugins;
            return this;
        }

        public ProjectBuilderRequestBuilder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories;
            return this;
        }

        public ProjectBuilderRequest build() {
            return new DefaultProjectBuilderRequest(this.session, this.trace, this.path, this.source, this.allowStubModel, this.recursive, this.processPlugins, this.repositories);
        }

        private static class DefaultProjectBuilderRequest
        extends BaseRequest<Session>
        implements ProjectBuilderRequest {
            private final Path path;
            private final Source source;
            private final boolean allowStubModel;
            private final boolean recursive;
            private final boolean processPlugins;
            private final List<RemoteRepository> repositories;

            DefaultProjectBuilderRequest(@Nonnull Session session, @Nullable RequestTrace trace, @Nullable Path path, @Nullable Source source, boolean allowStubModel, boolean recursive, boolean processPlugins, @Nullable List<RemoteRepository> repositories) {
                super(session, trace);
                this.path = path;
                this.source = source;
                this.allowStubModel = allowStubModel;
                this.recursive = recursive;
                this.processPlugins = processPlugins;
                this.repositories = this.validate(repositories);
            }

            @Override
            @Nonnull
            public Optional<Path> getPath() {
                return Optional.ofNullable(this.path);
            }

            @Override
            @Nonnull
            public Optional<Source> getSource() {
                return Optional.ofNullable(this.source);
            }

            @Override
            public boolean isAllowStubModel() {
                return this.allowStubModel;
            }

            @Override
            public boolean isRecursive() {
                return this.recursive;
            }

            @Override
            public boolean isProcessPlugins() {
                return this.processPlugins;
            }

            @Override
            public List<RemoteRepository> getRepositories() {
                return this.repositories;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultProjectBuilderRequest)) return false;
                DefaultProjectBuilderRequest that = (DefaultProjectBuilderRequest)o;
                if (this.allowStubModel != that.allowStubModel) return false;
                if (this.recursive != that.recursive) return false;
                if (this.processPlugins != that.processPlugins) return false;
                if (!Objects.equals(this.path, that.path)) return false;
                if (!Objects.equals(this.source, that.source)) return false;
                if (!Objects.equals(this.repositories, that.repositories)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.path, this.source, this.allowStubModel, this.recursive, this.processPlugins, this.repositories);
            }

            @Override
            public String toString() {
                return "ProjectBuilderRequest[path=" + String.valueOf(this.path) + ", source=" + String.valueOf(this.source) + ", allowStubModel=" + this.allowStubModel + ", recursive=" + this.recursive + ", processPlugins=" + this.processPlugins + ", repositories=" + String.valueOf(this.repositories) + "]";
            }
        }
    }
}

