/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.RepositoryAwareRequest;
import org.apache.maven.api.services.RequestTrace;

@Experimental
@Immutable
public interface DependencyResolverRequest
extends RepositoryAwareRequest {
    @Nonnull
    public RequestType getRequestType();

    @Nonnull
    public Optional<Project> getProject();

    @Nonnull
    public Optional<Artifact> getRootArtifact();

    @Nonnull
    public Optional<DependencyCoordinates> getRoot();

    @Nonnull
    public Collection<DependencyCoordinates> getDependencies();

    @Nonnull
    public Collection<DependencyCoordinates> getManagedDependencies();

    public boolean getVerbose();

    @Nonnull
    public PathScope getPathScope();

    @Nullable
    public Predicate<PathType> getPathTypeFilter();

    @Nullable
    public Version getTargetVersion();

    @Nonnull
    public static DependencyResolverRequestBuilder builder() {
        return new DependencyResolverRequestBuilder();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, Artifact rootArtifact) {
        return DependencyResolverRequest.build(session, requestType, rootArtifact, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, Artifact rootArtifact, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).requestType(requestType).rootArtifact(rootArtifact).pathScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, Project project) {
        return DependencyResolverRequest.build(session, requestType, project, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, Project project, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).requestType(requestType).project(project).pathScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, DependencyCoordinates dependency) {
        return DependencyResolverRequest.build(session, requestType, dependency, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, DependencyCoordinates dependency, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).requestType(requestType).dependency(dependency).pathScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, List<DependencyCoordinates> dependencies) {
        return DependencyResolverRequest.build(session, requestType, dependencies, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, RequestType requestType, List<DependencyCoordinates> dependencies, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).requestType(requestType).dependencies(dependencies).pathScope(scope).build();
    }

    @NotThreadSafe
    public static class DependencyResolverRequestBuilder {
        Session session;
        RequestTrace trace;
        RequestType requestType;
        Project project;
        Artifact rootArtifact;
        DependencyCoordinates root;
        List<DependencyCoordinates> dependencies = Collections.emptyList();
        List<DependencyCoordinates> managedDependencies = Collections.emptyList();
        boolean verbose;
        PathScope pathScope;
        Predicate<PathType> pathTypeFilter;
        Version targetVersion;
        List<RemoteRepository> repositories;

        DependencyResolverRequestBuilder() {
        }

        @Nonnull
        public DependencyResolverRequestBuilder session(@Nonnull Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder requestType(@Nonnull RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder project(@Nullable Project project) {
            this.project = project;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder rootArtifact(@Nullable Artifact rootArtifact) {
            this.rootArtifact = rootArtifact;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder root(@Nonnull DependencyCoordinates root) {
            this.root = root;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder dependencies(@Nullable List<DependencyCoordinates> dependencies) {
            this.dependencies = dependencies != null ? dependencies : Collections.emptyList();
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder dependency(@Nullable DependencyCoordinates dependency) {
            if (dependency != null) {
                if (this.dependencies.isEmpty()) {
                    this.dependencies = new ArrayList<DependencyCoordinates>();
                }
                this.dependencies.add(dependency);
            }
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder managedDependencies(@Nullable List<DependencyCoordinates> managedDependencies) {
            this.managedDependencies = managedDependencies != null ? managedDependencies : Collections.emptyList();
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder managedDependency(@Nullable DependencyCoordinates managedDependency) {
            if (managedDependency != null) {
                if (this.managedDependencies.isEmpty()) {
                    this.managedDependencies = new ArrayList<DependencyCoordinates>();
                }
                this.managedDependencies.add(managedDependency);
            }
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathScope(@Nullable PathScope pathScope) {
            this.pathScope = pathScope;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathTypeFilter(@Nonnull Predicate<PathType> pathTypeFilter) {
            this.pathTypeFilter = pathTypeFilter;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathTypeFilter(@Nonnull Collection<? extends PathType> desiredTypes) {
            return this.pathTypeFilter(desiredTypes::contains);
        }

        @Nonnull
        public DependencyResolverRequestBuilder targetVersion(@Nullable Version target) {
            this.targetVersion = target;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder repositories(@Nonnull List<RemoteRepository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public DependencyResolverRequest build() {
            return new DefaultDependencyResolverRequest(this.session, this.trace, this.requestType, this.project, this.rootArtifact, this.root, this.dependencies, this.managedDependencies, this.verbose, this.pathScope, this.pathTypeFilter, this.targetVersion, this.repositories);
        }

        static class DefaultDependencyResolverRequest
        extends BaseRequest<Session>
        implements DependencyResolverRequest {
            private static final Predicate<PathType> DEFAULT_FILTER = new AlwaysTrueFilter();
            private final RequestType requestType;
            private final Project project;
            private final Artifact rootArtifact;
            private final DependencyCoordinates root;
            private final Collection<DependencyCoordinates> dependencies;
            private final Collection<DependencyCoordinates> managedDependencies;
            private final boolean verbose;
            private final PathScope pathScope;
            private final Predicate<PathType> pathTypeFilter;
            private final Version targetVersion;
            private final List<RemoteRepository> repositories;

            DefaultDependencyResolverRequest(@Nonnull Session session, @Nullable RequestTrace trace, @Nonnull RequestType requestType, @Nullable Project project, @Nullable Artifact rootArtifact, @Nullable DependencyCoordinates root, @Nonnull Collection<DependencyCoordinates> dependencies, @Nonnull Collection<DependencyCoordinates> managedDependencies, boolean verbose, @Nullable PathScope pathScope, @Nullable Predicate<PathType> pathTypeFilter, @Nullable Version targetVersion, @Nullable List<RemoteRepository> repositories) {
                super(session, trace);
                this.requestType = Objects.requireNonNull(requestType, "requestType cannot be null");
                this.project = project;
                this.rootArtifact = rootArtifact;
                this.root = root;
                this.dependencies = List.copyOf(Objects.requireNonNull(dependencies, "dependencies cannot be null"));
                this.managedDependencies = List.copyOf(Objects.requireNonNull(managedDependencies, "managedDependencies cannot be null"));
                this.verbose = verbose;
                this.pathScope = Objects.requireNonNull(pathScope, "pathScope cannot be null");
                this.pathTypeFilter = pathTypeFilter != null ? pathTypeFilter : DEFAULT_FILTER;
                this.targetVersion = targetVersion;
                this.repositories = this.validate(repositories);
                if (verbose && requestType != RequestType.COLLECT) {
                    throw new IllegalArgumentException("verbose cannot only be true when collecting dependencies");
                }
            }

            @Override
            @Nonnull
            public RequestType getRequestType() {
                return this.requestType;
            }

            @Override
            @Nonnull
            public Optional<Project> getProject() {
                return Optional.ofNullable(this.project);
            }

            @Override
            @Nonnull
            public Optional<Artifact> getRootArtifact() {
                return Optional.ofNullable(this.rootArtifact);
            }

            @Override
            @Nonnull
            public Optional<DependencyCoordinates> getRoot() {
                return Optional.ofNullable(this.root);
            }

            @Override
            @Nonnull
            public Collection<DependencyCoordinates> getDependencies() {
                return this.dependencies;
            }

            @Override
            @Nonnull
            public Collection<DependencyCoordinates> getManagedDependencies() {
                return this.managedDependencies;
            }

            @Override
            public boolean getVerbose() {
                return this.verbose;
            }

            @Override
            public PathScope getPathScope() {
                return this.pathScope;
            }

            @Override
            public Predicate<PathType> getPathTypeFilter() {
                return this.pathTypeFilter;
            }

            @Override
            public Version getTargetVersion() {
                return this.targetVersion;
            }

            @Override
            public List<RemoteRepository> getRepositories() {
                return this.repositories;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultDependencyResolverRequest)) return false;
                DefaultDependencyResolverRequest that = (DefaultDependencyResolverRequest)o;
                if (this.verbose != that.verbose) return false;
                if (this.requestType != that.requestType) return false;
                if (!Objects.equals(this.project, that.project)) return false;
                if (!Objects.equals(this.rootArtifact, that.rootArtifact)) return false;
                if (!Objects.equals(this.root, that.root)) return false;
                if (!Objects.equals(this.dependencies, that.dependencies)) return false;
                if (!Objects.equals(this.managedDependencies, that.managedDependencies)) return false;
                if (!Objects.equals(this.pathScope, that.pathScope)) return false;
                if (!Objects.equals(this.pathTypeFilter, that.pathTypeFilter)) return false;
                if (!Objects.equals(this.targetVersion, that.targetVersion)) return false;
                if (!Objects.equals(this.repositories, that.repositories)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(new Object[]{this.requestType, this.project, this.rootArtifact, this.root, this.dependencies, this.managedDependencies, this.verbose, this.pathScope, this.pathTypeFilter, this.targetVersion, this.repositories});
            }

            @Override
            public String toString() {
                return "DependencyResolverRequest[requestType=" + String.valueOf((Object)this.requestType) + ", project=" + String.valueOf(this.project) + ", rootArtifact=" + String.valueOf(this.rootArtifact) + ", root=" + String.valueOf(this.root) + ", dependencies=" + String.valueOf(this.dependencies) + ", managedDependencies=" + String.valueOf(this.managedDependencies) + ", verbose=" + this.verbose + ", pathScope=" + String.valueOf(this.pathScope) + ", pathTypeFilter=" + String.valueOf(this.pathTypeFilter) + ", targetVersion=" + String.valueOf(this.targetVersion) + ", repositories=" + String.valueOf(this.repositories) + "]";
            }

            static final class AlwaysTrueFilter
            implements Predicate<PathType> {
                AlwaysTrueFilter() {
                }

                @Override
                public boolean test(PathType pathType) {
                    return true;
                }

                public boolean equals(Object obj) {
                    return obj instanceof AlwaysTrueFilter;
                }

                public int hashCode() {
                    return AlwaysTrueFilter.class.hashCode();
                }

                public String toString() {
                    return "AlwaysTrueFilter[]";
                }
            }
        }
    }

    public static enum RequestType {
        COLLECT,
        FLATTEN,
        RESOLVE;

    }
}

