/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Notifier;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class CiManagement
implements Serializable,
InputLocationTracker {
    final String system;
    final String url;
    final List<Notifier> notifiers;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected CiManagement(Builder builder) {
        String string = builder.system != null ? builder.system : (this.system = builder.base != null ? builder.base.system : null);
        String string2 = builder.url != null ? builder.url : (this.url = builder.base != null ? builder.base.url : null);
        this.notifiers = ImmutableCollections.copy(builder.notifiers != null ? builder.notifiers : (builder.base != null ? builder.base.notifiers : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getSystem() {
        return this.system;
    }

    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public List<Notifier> getNotifiers() {
        return this.notifiers;
    }

    @Override
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return CiManagement.newBuilder(this);
    }

    @Nonnull
    public CiManagement withSystem(String system) {
        return CiManagement.newBuilder(this, true).system(system).build();
    }

    @Nonnull
    public CiManagement withUrl(String url) {
        return CiManagement.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public CiManagement withNotifiers(Collection<Notifier> notifiers) {
        return CiManagement.newBuilder(this, true).notifiers(notifiers).build();
    }

    @Nonnull
    public static CiManagement newInstance() {
        return CiManagement.newInstance(true);
    }

    @Nonnull
    public static CiManagement newInstance(boolean withDefaults) {
        return CiManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return CiManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(CiManagement from) {
        return CiManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(CiManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        CiManagement base;
        String system;
        String url;
        Collection<Notifier> notifiers;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(CiManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
                this.notifiers = base.notifiers;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder notifiers(Collection<Notifier> notifiers) {
            this.notifiers = notifiers;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public CiManagement build() {
            if (!(this.base == null || this.system != null && this.system != this.base.system || this.url != null && this.url != this.base.url || this.notifiers != null && this.notifiers != this.base.notifiers)) {
                return this.base;
            }
            return new CiManagement(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

