/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Language;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.impl.DefaultSourceRoot;
import org.apache.maven.lifecycle.internal.DefaultProjectArtifactFactory;
import org.apache.maven.model.BaseObject;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.ConnectedResource;
import org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProject
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProject.class);
    public static final String EMPTY_PROJECT_GROUP_ID = "unknown";
    public static final String EMPTY_PROJECT_ARTIFACT_ID = "empty-project";
    public static final String EMPTY_PROJECT_VERSION = "0";
    private Model model;
    private MavenProject parent;
    private File file;
    private File basedir;
    private Path rootDirectory;
    private Set<Artifact> resolvedArtifacts;
    private ArtifactFilter artifactFilter;
    private Set<Artifact> artifacts;
    private Artifact parentArtifact;
    private Set<Artifact> pluginArtifacts;
    @Deprecated
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Deprecated
    private List<ArtifactRepository> pluginArtifactRepositories;
    private List<RemoteRepository> remoteProjectRepositories;
    private List<RemoteRepository> remotePluginRepositories;
    private List<Artifact> attachedArtifacts = new ArrayList<Artifact>();
    private MavenProject executionProject;
    private List<MavenProject> collectedProjects;
    Set<SourceRoot> sources = new LinkedHashSet<SourceRoot>();
    @Deprecated
    private ArtifactRepository releaseArtifactRepository;
    @Deprecated
    private ArtifactRepository snapshotArtifactRepository;
    private List<Profile> activeProfiles = new ArrayList<Profile>();
    private Map<String, List<String>> injectedProfileIds = new LinkedHashMap<String, List<String>>();
    @Deprecated
    private Set<Artifact> dependencyArtifacts;
    private Artifact artifact;
    private Map<String, Artifact> artifactMap;
    private Model originalModel;
    private Map<String, Artifact> pluginArtifactMap;
    @Deprecated
    private Set<Artifact> reportArtifacts;
    @Deprecated
    private Map<String, Artifact> reportArtifactMap;
    @Deprecated
    private Set<Artifact> extensionArtifacts;
    @Deprecated
    private Map<String, Artifact> extensionArtifactMap;
    private Map<String, Artifact> managedVersionMap;
    private Map<String, MavenProject> projectReferences = new HashMap<String, MavenProject>();
    private boolean executionRoot;
    private File parentFile;
    private Map<String, Object> context;
    private ClassRealm classRealm;
    private DependencyFilter extensionDependencyFilter;
    private final Set<String> lifecyclePhases = Collections.synchronizedSet(new LinkedHashSet());
    private ProjectBuildingRequest projectBuilderConfiguration;
    private Map<String, String> moduleAdjustments;

    public MavenProject() {
        Model model = new Model();
        model.setGroupId(EMPTY_PROJECT_GROUP_ID);
        model.setArtifactId(EMPTY_PROJECT_ARTIFACT_ID);
        model.setVersion(EMPTY_PROJECT_VERSION);
        this.setModel(model);
    }

    public MavenProject(org.apache.maven.api.model.Model model) {
        this(new Model(model));
    }

    public MavenProject(Model model) {
        this.setModel(model);
    }

    public MavenProject(MavenProject project) {
        this.deepCopy(project);
    }

    public File getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(File parentFile) {
        this.parentFile = parentFile;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Model getModel() {
        return this.model;
    }

    public MavenProject getParent() {
        return this.parent;
    }

    public void setParent(MavenProject parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.basedir = file != null ? file.getParentFile() : null;
    }

    public void setPomFile(File file) {
        this.file = file;
    }

    @Deprecated(since="4.0.0")
    public File getBasedir() {
        return this.basedir;
    }

    public Path getBaseDirectory() {
        return this.getBasedir().toPath();
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.getModel().setDependencies(dependencies);
    }

    public List<Dependency> getDependencies() {
        return this.getModel().getDependencies();
    }

    public DependencyManagement getDependencyManagement() {
        return this.getModel().getDependencyManagement();
    }

    public void addSourceRoot(SourceRoot source) {
        this.sources.add(source);
    }

    public void addSourceRoot(@Nonnull ProjectScope scope, @Nonnull Language language, @Nonnull Path directory) {
        directory = this.getBaseDirectory().resolve(Objects.requireNonNull(directory, "directory cannot be null")).normalize();
        this.addSourceRoot((SourceRoot)new DefaultSourceRoot(scope, language, directory));
    }

    public void addSourceRoot(@Nonnull ProjectScope scope, @Nonnull Language language, @Nonnull String directory) {
        if (!(directory = Objects.requireNonNull(directory, "directory cannot be null").trim()).isBlank()) {
            Path path = this.getBaseDirectory().resolve(directory).normalize();
            this.addSourceRoot(scope, language, path);
        }
    }

    public void removeSourceRoot(@Nonnull ProjectScope scope, @Nonnull Language language, @Nonnull Path directory) {
        Path path = this.getBaseDirectory().resolve(Objects.requireNonNull(directory, "directory cannot be null")).normalize();
        this.sources.removeIf(source -> source.scope() == scope && source.language() == language && source.directory().equals(path));
    }

    public void removeSourceRoot(@Nonnull ProjectScope scope, @Nonnull Language language, @Nonnull String directory) {
        if (!(directory = Objects.requireNonNull(directory, "directory cannot be null").trim()).isBlank()) {
            this.removeSourceRoot(scope, language, Path.of(directory, new String[0]));
        }
    }

    @Deprecated(since="4.0.0")
    public void addCompileSourceRoot(String path) {
        this.addSourceRoot(ProjectScope.MAIN, Language.JAVA_FAMILY, path);
    }

    @Deprecated(since="4.0.0")
    public void removeCompileSourceRoot(String path) {
        this.removeSourceRoot(ProjectScope.MAIN, Language.JAVA_FAMILY, path);
    }

    @Deprecated(since="4.0.0")
    public void addTestCompileSourceRoot(String path) {
        this.addSourceRoot(ProjectScope.TEST, Language.JAVA_FAMILY, path);
    }

    public void removeTestCompileSourceRoot(String path) {
        this.removeSourceRoot(ProjectScope.TEST, Language.JAVA_FAMILY, path);
    }

    public Collection<SourceRoot> getSourceRoots() {
        return Collections.unmodifiableCollection(this.sources);
    }

    public Stream<SourceRoot> getEnabledSourceRoots(ProjectScope scope, Language language) {
        Stream<SourceRoot> stream = this.sources.stream().filter(SourceRoot::enabled);
        if (scope != null) {
            stream = stream.filter(source -> scope.equals((Object)source.scope()));
        }
        if (language != null) {
            stream = stream.filter(source -> language.equals((Object)source.language()));
        }
        return stream;
    }

    @Deprecated
    private List<String> getSourceRootDirs(ProjectScope scope, Language language) {
        return this.getEnabledSourceRoots(scope, language).map(source -> source.directory().toString()).toList();
    }

    @Deprecated(since="4.0.0")
    public List<String> getCompileSourceRoots() {
        return this.getSourceRootDirs(ProjectScope.MAIN, Language.JAVA_FAMILY);
    }

    @Deprecated(since="4.0.0")
    public List<String> getTestCompileSourceRoots() {
        return this.getSourceRootDirs(ProjectScope.TEST, Language.JAVA_FAMILY);
    }

    private static boolean isCompilePathElement(String scope) {
        return "compile".equals(scope) || "provided".equals(scope) || "system".equals(scope);
    }

    private static boolean isRuntimePathElement(String scope) {
        return "compile".equals(scope) || "runtime".equals(scope);
    }

    private static boolean isTestPathElement(String scope) {
        return true;
    }

    private List<String> getClasspathElements(Predicate<String> scopeFilter, boolean includeTestDir) throws DependencyResolutionRequiredException {
        String d;
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size() + 2);
        if (includeTestDir && (d = this.getBuild().getTestOutputDirectory()) != null) {
            list.add(d);
        }
        if ((d = this.getBuild().getOutputDirectory()) != null) {
            list.add(d);
        }
        for (Artifact a : this.getArtifacts()) {
            ArtifactHandler h;
            File f = a.getFile();
            if (f == null || !scopeFilter.test(a.getScope()) || !(h = a.getArtifactHandler()).isAddedToClasspath()) continue;
            list.add(f.getPath());
        }
        return list;
    }

    @Deprecated
    public List<String> getCompileClasspathElements() throws DependencyResolutionRequiredException {
        return this.getClasspathElements(MavenProject::isCompilePathElement, false);
    }

    @Deprecated
    public List<String> getTestClasspathElements() throws DependencyResolutionRequiredException {
        return this.getClasspathElements(MavenProject::isTestPathElement, true);
    }

    @Deprecated
    public List<String> getRuntimeClasspathElements() throws DependencyResolutionRequiredException {
        return this.getClasspathElements(MavenProject::isRuntimePathElement, false);
    }

    public void setModelVersion(String pomVersion) {
        this.getModel().setModelVersion(pomVersion);
    }

    public String getModelVersion() {
        return this.getModel().getModelVersion();
    }

    public String getId() {
        return this.getModel().getId();
    }

    public void setGroupId(String groupId) {
        this.getModel().setGroupId(groupId);
    }

    public String getGroupId() {
        String groupId = this.getModel().getGroupId();
        if (groupId == null && this.getModel().getParent() != null) {
            groupId = this.getModel().getParent().getGroupId();
        }
        return groupId;
    }

    public void setArtifactId(String artifactId) {
        this.getModel().setArtifactId(artifactId);
    }

    public String getArtifactId() {
        return this.getModel().getArtifactId();
    }

    public void setName(String name) {
        this.getModel().setName(name);
    }

    public String getName() {
        if (this.getModel().getName() != null) {
            return this.getModel().getName();
        }
        return this.getArtifactId();
    }

    public void setVersion(String version) {
        this.getModel().setVersion(version);
    }

    public String getVersion() {
        String version = this.getModel().getVersion();
        if (version == null && this.getModel().getParent() != null) {
            version = this.getModel().getParent().getVersion();
        }
        return version;
    }

    public String getPackaging() {
        return this.getModel().getPackaging();
    }

    public void setPackaging(String packaging) {
        this.getModel().setPackaging(packaging);
    }

    public void setInceptionYear(String inceptionYear) {
        this.getModel().setInceptionYear(inceptionYear);
    }

    public String getInceptionYear() {
        return this.getModel().getInceptionYear();
    }

    public void setUrl(String url) {
        this.getModel().setUrl(url);
    }

    public String getUrl() {
        return this.getModel().getUrl();
    }

    public Prerequisites getPrerequisites() {
        return this.getModel().getPrerequisites();
    }

    public void setIssueManagement(IssueManagement issueManagement) {
        this.getModel().setIssueManagement(issueManagement);
    }

    public CiManagement getCiManagement() {
        return this.getModel().getCiManagement();
    }

    public void setCiManagement(CiManagement ciManagement) {
        this.getModel().setCiManagement(ciManagement);
    }

    public IssueManagement getIssueManagement() {
        return this.getModel().getIssueManagement();
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.getModel().setDistributionManagement(distributionManagement);
    }

    public DistributionManagement getDistributionManagement() {
        return this.getModel().getDistributionManagement();
    }

    public void setDescription(String description) {
        this.getModel().setDescription(description);
    }

    public String getDescription() {
        return this.getModel().getDescription();
    }

    public void setOrganization(Organization organization) {
        this.getModel().setOrganization(organization);
    }

    public Organization getOrganization() {
        return this.getModel().getOrganization();
    }

    public void setScm(Scm scm) {
        this.getModel().setScm(scm);
    }

    public Scm getScm() {
        return this.getModel().getScm();
    }

    public void setMailingLists(List<MailingList> mailingLists) {
        this.getModel().setMailingLists(mailingLists);
    }

    public List<MailingList> getMailingLists() {
        return this.getModel().getMailingLists();
    }

    public void addMailingList(MailingList mailingList) {
        this.getModel().addMailingList(mailingList);
    }

    public void setDevelopers(List<Developer> developers) {
        this.getModel().setDevelopers(developers);
    }

    public List<Developer> getDevelopers() {
        return this.getModel().getDevelopers();
    }

    public void addDeveloper(Developer developer) {
        this.getModel().addDeveloper(developer);
    }

    public void setContributors(List<Contributor> contributors) {
        this.getModel().setContributors(contributors);
    }

    public List<Contributor> getContributors() {
        return this.getModel().getContributors();
    }

    public void addContributor(Contributor contributor) {
        this.getModel().addContributor(contributor);
    }

    public void setBuild(Build build) {
        this.getModel().setBuild(build);
    }

    public Build getBuild() {
        return this.getModelBuild();
    }

    @Deprecated(since="4.0.0")
    public List<Resource> getResources() {
        return this.getResources(ProjectScope.MAIN);
    }

    @Deprecated(since="4.0.0")
    public List<Resource> getTestResources() {
        return this.getResources(ProjectScope.TEST);
    }

    private List<Resource> getResources(final ProjectScope scope) {
        return new AbstractSequentialList<Resource>(){

            private Stream<SourceRoot> sources() {
                return MavenProject.this.getEnabledSourceRoots(scope, Language.RESOURCES);
            }

            @Override
            public ListIterator<Resource> listIterator(int index) {
                return this.sources().map(sourceRoot -> MavenProject.this.toConnectedResource((SourceRoot)sourceRoot, scope)).toList().listIterator(index);
            }

            @Override
            public int size() {
                return Math.toIntExact(this.sources().count());
            }

            @Override
            public boolean isEmpty() {
                return this.sources().findAny().isEmpty();
            }

            @Override
            public boolean add(Resource resource) {
                MavenProject.this.addResource(scope, resource);
                return true;
            }
        };
    }

    private static Resource toResource(SourceRoot sourceRoot) {
        return new Resource(org.apache.maven.api.model.Resource.newBuilder().directory(sourceRoot.directory().toString()).includes((Collection)sourceRoot.includes()).excludes((Collection)sourceRoot.excludes()).filtering(Boolean.toString(sourceRoot.stringFiltering())).targetPath((String)sourceRoot.targetPath().map(Path::toString).orElse(null)).build());
    }

    private Resource toConnectedResource(SourceRoot sourceRoot, ProjectScope scope) {
        return new ConnectedResource(sourceRoot, scope, this);
    }

    private void addResource(ProjectScope scope, Resource resource) {
        this.addSourceRoot((SourceRoot)new DefaultSourceRoot(this.getBaseDirectory(), scope, resource.getDelegate()));
    }

    @Deprecated(since="4.0.0")
    public void addResource(Resource resource) {
        this.addResource(ProjectScope.MAIN, resource);
    }

    @Deprecated(since="4.0.0")
    public void addTestResource(Resource testResource) {
        this.addResource(ProjectScope.TEST, testResource);
    }

    public void setLicenses(List<License> licenses) {
        this.getModel().setLicenses(licenses);
    }

    public List<License> getLicenses() {
        return this.getModel().getLicenses();
    }

    public void addLicense(License license) {
        this.getModel().addLicense(license);
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts = artifacts;
        this.artifactMap = null;
    }

    public Set<Artifact> getArtifacts() {
        if (this.artifacts == null) {
            if (this.artifactFilter == null || this.resolvedArtifacts == null) {
                this.artifacts = new LinkedHashSet<Artifact>();
            } else {
                this.artifacts = new LinkedHashSet<Artifact>(this.resolvedArtifacts.size() * 2);
                for (Artifact artifact : this.resolvedArtifacts) {
                    if (!this.artifactFilter.include(artifact)) continue;
                    this.artifacts.add(artifact);
                }
            }
        }
        return this.artifacts;
    }

    public Map<String, Artifact> getArtifactMap() {
        if (this.artifactMap == null) {
            this.artifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getArtifacts());
        }
        return this.artifactMap;
    }

    public void setPluginArtifacts(Set<Artifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
        this.pluginArtifactMap = null;
    }

    public Set<Artifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        if (this.pluginArtifactMap == null) {
            this.pluginArtifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getPluginArtifacts());
        }
        return this.pluginArtifactMap;
    }

    public void setParentArtifact(Artifact parentArtifact) {
        this.parentArtifact = parentArtifact;
    }

    public Artifact getParentArtifact() {
        return this.parentArtifact;
    }

    public List<Repository> getRepositories() {
        return this.getModel().getRepositories();
    }

    public List<Plugin> getBuildPlugins() {
        if (this.getModel().getBuild() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.getModel().getBuild().getPlugins());
    }

    public List<String> getModules() {
        if (!this.getModel().getDelegate().getSubprojects().isEmpty()) {
            return this.getModel().getDelegate().getSubprojects();
        }
        return this.getModel().getModules();
    }

    public PluginManagement getPluginManagement() {
        PluginManagement pluginMgmt = null;
        Build build = this.getModel().getBuild();
        if (build != null) {
            pluginMgmt = build.getPluginManagement();
        }
        return pluginMgmt;
    }

    private Build getModelBuild() {
        Build build = this.getModel().getBuild();
        if (build == null) {
            build = new Build();
            this.getModel().setBuild(build);
        }
        return build;
    }

    @Deprecated
    public void setRemoteArtifactRepositories(List<ArtifactRepository> remoteArtifactRepositories) {
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.remoteProjectRepositories = RepositoryUtils.toRepos(this.getRemoteArtifactRepositories());
    }

    @Deprecated
    public List<ArtifactRepository> getRemoteArtifactRepositories() {
        if (this.remoteArtifactRepositories == null) {
            this.remoteArtifactRepositories = new ArrayList<ArtifactRepository>();
        }
        return this.remoteArtifactRepositories;
    }

    @Deprecated
    public void setPluginArtifactRepositories(List<ArtifactRepository> pluginArtifactRepositories) {
        this.pluginArtifactRepositories = pluginArtifactRepositories;
        this.remotePluginRepositories = RepositoryUtils.toRepos(this.getPluginArtifactRepositories());
    }

    @Deprecated
    public List<ArtifactRepository> getPluginArtifactRepositories() {
        if (this.pluginArtifactRepositories == null) {
            this.pluginArtifactRepositories = new ArrayList<ArtifactRepository>();
        }
        return this.pluginArtifactRepositories;
    }

    @Deprecated
    public ArtifactRepository getDistributionManagementArtifactRepository() {
        return this.getArtifact().isSnapshot() && this.getSnapshotArtifactRepository() != null ? this.getSnapshotArtifactRepository() : this.getReleaseArtifactRepository();
    }

    public List<Repository> getPluginRepositories() {
        return this.getModel().getPluginRepositories();
    }

    public List<RemoteRepository> getRemoteProjectRepositories() {
        if (this.remoteProjectRepositories == null) {
            this.remoteProjectRepositories = new ArrayList<RemoteRepository>();
        }
        return this.remoteProjectRepositories;
    }

    public List<RemoteRepository> getRemotePluginRepositories() {
        if (this.remotePluginRepositories == null) {
            this.remotePluginRepositories = new ArrayList<RemoteRepository>();
        }
        return this.remotePluginRepositories;
    }

    public void setActiveProfiles(List<Profile> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public List<Profile> getActiveProfiles() {
        return this.activeProfiles;
    }

    public void setInjectedProfileIds(String source, List<String> injectedProfileIds) {
        if (injectedProfileIds != null) {
            this.injectedProfileIds.put(source, new ArrayList<String>(injectedProfileIds));
        } else {
            this.injectedProfileIds.remove(source);
        }
    }

    public Map<String, List<String>> getInjectedProfileIds() {
        return this.injectedProfileIds;
    }

    public void addAttachedArtifact(Artifact artifact) throws DuplicateArtifactAttachmentException {
        int index = this.attachedArtifacts.indexOf(artifact);
        if (index >= 0) {
            LOGGER.warn("artifact '{}' already attached, replacing previous instance", (Object)artifact);
            this.attachedArtifacts.set(index, artifact);
        } else {
            this.attachedArtifacts.add(artifact);
        }
    }

    public List<Artifact> getAttachedArtifacts() {
        if (this.attachedArtifacts == null) {
            this.attachedArtifacts = new ArrayList<Artifact>();
        }
        return Collections.unmodifiableList(this.attachedArtifacts);
    }

    public Xpp3Dom getGoalConfiguration(String pluginGroupId, String pluginArtifactId, String executionId, String goalId) {
        Xpp3Dom dom = null;
        if (this.getBuildPlugins() != null) {
            block0: for (Plugin plugin : this.getBuildPlugins()) {
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                dom = (Xpp3Dom)plugin.getConfiguration();
                if (executionId == null) break;
                for (PluginExecution execution : plugin.getExecutions()) {
                    if (!executionId.equals(execution.getId())) continue;
                    dom = (Xpp3Dom)execution.getConfiguration();
                    break block0;
                }
            }
        }
        if (dom != null) {
            dom = new Xpp3Dom(dom);
        }
        return dom;
    }

    public MavenProject getExecutionProject() {
        return this.executionProject == null ? this : this.executionProject;
    }

    public void setExecutionProject(MavenProject executionProject) {
        this.executionProject = executionProject;
    }

    public List<MavenProject> getCollectedProjects() {
        return this.collectedProjects;
    }

    public void setCollectedProjects(List<MavenProject> collectedProjects) {
        this.collectedProjects = collectedProjects;
    }

    @Deprecated
    public Set<Artifact> getDependencyArtifacts() {
        return this.dependencyArtifacts;
    }

    @Deprecated
    public void setDependencyArtifacts(Set<Artifact> dependencyArtifacts) {
        this.dependencyArtifacts = dependencyArtifacts;
    }

    @Deprecated
    public void setReleaseArtifactRepository(ArtifactRepository releaseArtifactRepository) {
        this.releaseArtifactRepository = releaseArtifactRepository;
    }

    @Deprecated
    public void setSnapshotArtifactRepository(ArtifactRepository snapshotArtifactRepository) {
        this.snapshotArtifactRepository = snapshotArtifactRepository;
    }

    public void setOriginalModel(Model originalModel) {
        this.originalModel = originalModel;
    }

    public Model getOriginalModel() {
        return this.originalModel;
    }

    public void setManagedVersionMap(Map<String, Artifact> map) {
        this.managedVersionMap = map;
    }

    public Map<String, Artifact> getManagedVersionMap() {
        return this.managedVersionMap;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MavenProject) {
            MavenProject that = (MavenProject)other;
            return Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getVersion(), that.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    public List<Extension> getBuildExtensions() {
        Build build = this.getBuild();
        if (build == null || build.getExtensions() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(build.getExtensions());
    }

    public void addProjectReference(MavenProject project) {
        this.projectReferences.put(MavenProject.getProjectReferenceId(project.getGroupId(), project.getArtifactId(), project.getVersion()), project);
    }

    public Properties getProperties() {
        return this.getModel().getProperties();
    }

    public List<String> getFilters() {
        return this.getBuild().getFilters();
    }

    public Map<String, MavenProject> getProjectReferences() {
        return this.projectReferences;
    }

    public boolean isExecutionRoot() {
        return this.executionRoot;
    }

    public void setExecutionRoot(boolean executionRoot) {
        this.executionRoot = executionRoot;
    }

    public String getDefaultGoal() {
        return this.getBuild() != null ? this.getBuild().getDefaultGoal() : null;
    }

    public Plugin getPlugin(String pluginKey) {
        org.apache.maven.api.model.Plugin plugin = (org.apache.maven.api.model.Plugin)this.getBuild().getDelegate().getPluginsAsMap().get(pluginKey);
        return plugin != null ? new Plugin(plugin, (BaseObject)this.getBuild()) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("MavenProject: ");
        sb.append(this.getGroupId());
        sb.append(':');
        sb.append(this.getArtifactId());
        sb.append(':');
        sb.append(this.getVersion());
        if (this.getFile() != null) {
            sb.append(" @ ");
            sb.append(this.getFile().getPath());
        }
        return sb.toString();
    }

    public MavenProject clone() {
        MavenProject clone;
        try {
            clone = (MavenProject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
        clone.deepCopy(this);
        return clone;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    protected void setAttachedArtifacts(List<Artifact> attachedArtifacts) {
        this.attachedArtifacts = attachedArtifacts;
    }

    @Deprecated
    private void setSourceRootDirs(ProjectScope scope, Language language, List<String> roots) {
        this.sources.removeIf(source -> scope.equals((Object)source.scope()) && language.equals((Object)source.language()));
        Path directory = this.getBaseDirectory();
        for (String root : roots) {
            this.addSourceRoot((SourceRoot)new DefaultSourceRoot(scope, language, directory.resolve(root)));
        }
    }

    @Deprecated(since="4.0.0")
    protected void setCompileSourceRoots(List<String> compileSourceRoots) {
        this.setSourceRootDirs(ProjectScope.MAIN, Language.JAVA_FAMILY, compileSourceRoots);
    }

    @Deprecated(since="4.0.0")
    protected void setTestCompileSourceRoots(List<String> testCompileSourceRoots) {
        this.setSourceRootDirs(ProjectScope.TEST, Language.JAVA_FAMILY, testCompileSourceRoots);
    }

    protected ArtifactRepository getReleaseArtifactRepository() {
        return this.releaseArtifactRepository;
    }

    protected ArtifactRepository getSnapshotArtifactRepository() {
        return this.snapshotArtifactRepository;
    }

    private void deepCopy(MavenProject project) {
        this.file = project.file;
        this.basedir = project.basedir;
        if (project.getDependencyArtifacts() != null) {
            this.setDependencyArtifacts(Collections.unmodifiableSet(project.getDependencyArtifacts()));
        }
        if (project.getArtifacts() != null) {
            this.setArtifacts(Collections.unmodifiableSet(project.getArtifacts()));
        }
        if (project.getParentFile() != null) {
            this.parentFile = new File(project.getParentFile().getAbsolutePath());
        }
        if (project.getPluginArtifacts() != null) {
            this.setPluginArtifacts(Collections.unmodifiableSet(project.getPluginArtifacts()));
        }
        if (project.getReportArtifacts() != null) {
            this.setReportArtifacts(Collections.unmodifiableSet(project.getReportArtifacts()));
        }
        if (project.getExtensionArtifacts() != null) {
            this.setExtensionArtifacts(Collections.unmodifiableSet(project.getExtensionArtifacts()));
        }
        this.setParentArtifact(project.getParentArtifact());
        if (project.getRemoteArtifactRepositories() != null) {
            this.setRemoteArtifactRepositories(Collections.unmodifiableList(project.getRemoteArtifactRepositories()));
        }
        if (project.getPluginArtifactRepositories() != null) {
            this.setPluginArtifactRepositories(Collections.unmodifiableList(project.getPluginArtifactRepositories()));
        }
        if (project.getActiveProfiles() != null) {
            this.setActiveProfiles(Collections.unmodifiableList(project.getActiveProfiles()));
        }
        if (project.getAttachedArtifacts() != null) {
            this.setAttachedArtifacts(new ArrayList<Artifact>(project.getAttachedArtifacts()));
        }
        this.sources = new LinkedHashSet<SourceRoot>(project.sources);
        if (project.getModel() != null) {
            this.setModel(project.getModel().clone());
        }
        if (project.getOriginalModel() != null) {
            this.setOriginalModel(project.getOriginalModel());
        }
        this.setExecutionRoot(project.isExecutionRoot());
        if (project.getArtifact() != null) {
            this.setArtifact(ArtifactUtils.copyArtifact((Artifact)project.getArtifact()));
        }
        if (project.getManagedVersionMap() != null) {
            this.setManagedVersionMap(project.getManagedVersionMap());
        }
        this.lifecyclePhases.addAll(project.lifecyclePhases);
    }

    private static String getProjectReferenceId(String groupId, String artifactId, String version) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(groupId).append(':').append(artifactId).append(':').append(version);
        return buffer.toString();
    }

    public void setContextValue(String key, Object value) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        if (value != null) {
            this.context.put(key, value);
        } else {
            this.context.remove(key);
        }
    }

    public Object getContextValue(String key) {
        if (this.context == null) {
            return null;
        }
        return this.context.get(key);
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public ClassRealm getClassRealm() {
        return this.classRealm;
    }

    public void setExtensionDependencyFilter(DependencyFilter extensionDependencyFilter) {
        this.extensionDependencyFilter = extensionDependencyFilter;
    }

    public DependencyFilter getExtensionDependencyFilter() {
        return this.extensionDependencyFilter;
    }

    public void setResolvedArtifacts(Set<Artifact> artifacts) {
        this.resolvedArtifacts = artifacts != null ? artifacts : Collections.emptySet();
        this.artifacts = null;
        this.artifactMap = null;
    }

    public void setArtifactFilter(ArtifactFilter artifactFilter) {
        this.artifactFilter = artifactFilter;
        this.artifacts = null;
        this.artifactMap = null;
    }

    public boolean hasLifecyclePhase(String phase) {
        return this.lifecyclePhases.contains(phase);
    }

    public void addLifecyclePhase(String lifecyclePhase) {
        this.lifecyclePhases.add(lifecyclePhase);
    }

    @Deprecated
    public String getModulePathAdjustment(MavenProject moduleProject) throws IOException {
        String module = moduleProject.getArtifactId();
        File moduleFile = moduleProject.getFile();
        if (moduleFile != null) {
            File moduleDir = moduleFile.getCanonicalFile().getParentFile();
            module = moduleDir.getName();
        }
        if (this.moduleAdjustments == null) {
            this.moduleAdjustments = new HashMap<String, String>();
            List<String> modules = this.getModules();
            if (modules != null) {
                for (String modulePath : modules) {
                    int lastSlash;
                    String moduleName = modulePath;
                    if (moduleName.endsWith("/") || moduleName.endsWith("\\")) {
                        moduleName = moduleName.substring(0, moduleName.length() - 1);
                    }
                    if ((lastSlash = moduleName.lastIndexOf(47)) < 0) {
                        lastSlash = moduleName.lastIndexOf(92);
                    }
                    String adjustment = null;
                    if (lastSlash > -1) {
                        moduleName = moduleName.substring(lastSlash + 1);
                        adjustment = modulePath.substring(0, lastSlash);
                    }
                    this.moduleAdjustments.put(moduleName, adjustment);
                }
            }
        }
        return this.moduleAdjustments.get(module);
    }

    @Deprecated
    public Set<Artifact> createArtifacts(ArtifactFactory artifactFactory, String inheritedScope, ArtifactFilter filter) throws InvalidDependencyVersionException {
        return DefaultProjectArtifactFactory.createArtifacts(artifactFactory, this.getModel().getDependencies(), inheritedScope, filter, this);
    }

    @Deprecated
    protected void setScriptSourceRoots(List<String> scriptSourceRoots) {
        this.setSourceRootDirs(ProjectScope.MAIN, Language.SCRIPT, scriptSourceRoots);
    }

    @Deprecated
    public void addScriptSourceRoot(String path) {
        this.addSourceRoot(ProjectScope.MAIN, Language.SCRIPT, path);
    }

    @Deprecated
    public List<String> getScriptSourceRoots() {
        return this.getSourceRootDirs(ProjectScope.MAIN, Language.SCRIPT);
    }

    @Deprecated
    public List<Artifact> getCompileArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !MavenProject.isCompilePathElement(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    @Deprecated
    public List<Dependency> getCompileDependencies() {
        Set<Artifact> artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        for (Artifact a : this.getArtifacts()) {
            if (!MavenProject.isCompilePathElement(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    public List<Artifact> getTestArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath()) continue;
            list.add(a);
        }
        return list;
    }

    @Deprecated
    public List<Dependency> getTestDependencies() {
        Set<Artifact> artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        for (Artifact a : this.getArtifacts()) {
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    public List<Dependency> getRuntimeDependencies() {
        Set<Artifact> artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        for (Artifact a : this.getArtifacts()) {
            if (!MavenProject.isRuntimePathElement(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    public List<Artifact> getRuntimeArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !MavenProject.isRuntimePathElement(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    @Deprecated
    public List<String> getSystemClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size());
        String d = this.getBuild().getOutputDirectory();
        if (d != null) {
            list.add(d);
        }
        for (Artifact a : this.getArtifacts()) {
            File f;
            if (!a.getArtifactHandler().isAddedToClasspath() || !"system".equals(a.getScope()) || (f = a.getFile()) == null) continue;
            list.add(f.getPath());
        }
        return list;
    }

    @Deprecated
    public List<Artifact> getSystemArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"system".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    @Deprecated
    public List<Dependency> getSystemDependencies() {
        Set<Artifact> artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        for (Artifact a : this.getArtifacts()) {
            if (!"system".equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    public void setReporting(Reporting reporting) {
        this.getModel().setReporting(reporting);
    }

    @Deprecated
    public Reporting getReporting() {
        return this.getModel().getReporting();
    }

    @Deprecated
    public void setReportArtifacts(Set<Artifact> reportArtifacts) {
        this.reportArtifacts = reportArtifacts;
        this.reportArtifactMap = null;
    }

    @Deprecated
    public Set<Artifact> getReportArtifacts() {
        return this.reportArtifacts;
    }

    @Deprecated
    public Map<String, Artifact> getReportArtifactMap() {
        if (this.reportArtifactMap == null) {
            this.reportArtifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getReportArtifacts());
        }
        return this.reportArtifactMap;
    }

    @Deprecated
    public void setExtensionArtifacts(Set<Artifact> extensionArtifacts) {
        this.extensionArtifacts = extensionArtifacts;
        this.extensionArtifactMap = null;
    }

    @Deprecated
    public Set<Artifact> getExtensionArtifacts() {
        return this.extensionArtifacts;
    }

    @Deprecated
    public Map<String, Artifact> getExtensionArtifactMap() {
        if (this.extensionArtifactMap == null) {
            this.extensionArtifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getExtensionArtifacts());
        }
        return this.extensionArtifactMap;
    }

    @Deprecated
    public List<ReportPlugin> getReportPlugins() {
        if (this.getModel().getReporting() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.getModel().getReporting().getPlugins());
    }

    @Deprecated
    public Xpp3Dom getReportConfiguration(String pluginGroupId, String pluginArtifactId, String reportSetId) {
        Xpp3Dom dom = null;
        if (this.getReportPlugins() != null) {
            for (ReportPlugin plugin : this.getReportPlugins()) {
                Xpp3Dom executionConfiguration;
                ReportSet reportSet;
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                dom = (Xpp3Dom)plugin.getConfiguration();
                if (reportSetId == null || (reportSet = (ReportSet)plugin.getReportSetsAsMap().get(reportSetId)) == null || (executionConfiguration = (Xpp3Dom)reportSet.getConfiguration()) == null) break;
                Xpp3Dom newDom = new Xpp3Dom(executionConfiguration);
                dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)newDom, (Xpp3Dom)dom);
                break;
            }
        }
        if (dom != null) {
            dom = new Xpp3Dom(dom);
        }
        return dom;
    }

    @Deprecated
    public void attachArtifact(String type, String classifier, File file) {
    }

    @Deprecated
    public void writeModel(Writer writer) throws IOException {
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write(writer, this.getModel());
    }

    @Deprecated
    public void writeOriginalModel(Writer writer) throws IOException {
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write(writer, this.getOriginalModel());
    }

    @Deprecated
    public Artifact replaceWithActiveArtifact(Artifact pluginArtifact) {
        return pluginArtifact;
    }

    @Deprecated
    public ProjectBuildingRequest getProjectBuildingRequest() {
        return this.projectBuilderConfiguration;
    }

    @Deprecated
    public void setProjectBuildingRequest(ProjectBuildingRequest projectBuildingRequest) {
        this.projectBuilderConfiguration = projectBuildingRequest;
    }

    public Path getRootDirectory() {
        if (this.rootDirectory == null) {
            throw new IllegalStateException("Unable to find the root directory. Create a .mvn directory in the root directory or add the root=\"true\" attribute on the root project's model to identify it.");
        }
        return this.rootDirectory;
    }

    public void setRootDirectory(Path rootDirectory) {
        this.rootDirectory = rootDirectory;
    }
}

