/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.offline;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.RepositoryOfflineException;

public final class OfflineRepositoryConnector
implements RepositoryConnector {
    private final RepositorySystemSession session;
    private final RemoteRepository remoteRepository;
    private final OfflineController offlineController;
    private final RepositoryConnector delegate;

    public OfflineRepositoryConnector(RepositorySystemSession session, RemoteRepository remoteRepository, OfflineController offlineController, RepositoryConnector delegate) {
        this.session = Objects.requireNonNull(session);
        this.remoteRepository = Objects.requireNonNull(remoteRepository);
        this.offlineController = Objects.requireNonNull(offlineController);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public void close() {
        this.delegate.close();
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        try {
            Utils.checkOffline(this.session, this.offlineController, this.remoteRepository);
        }
        catch (RepositoryOfflineException e) {
            if (artifactDownloads != null && !artifactDownloads.isEmpty()) {
                artifactDownloads.forEach(d -> d.setException(new ArtifactTransferException(d.getArtifact(), this.remoteRepository, (Throwable)e)));
            }
            if (metadataDownloads != null && !metadataDownloads.isEmpty()) {
                metadataDownloads.forEach(d -> d.setException(new MetadataTransferException(d.getMetadata(), this.remoteRepository, (Throwable)e)));
            }
            return;
        }
        this.delegate.get(artifactDownloads, metadataDownloads);
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        try {
            Utils.checkOffline(this.session, this.offlineController, this.remoteRepository);
        }
        catch (RepositoryOfflineException e) {
            if (artifactUploads != null && !artifactUploads.isEmpty()) {
                artifactUploads.forEach(d -> d.setException(new ArtifactTransferException(d.getArtifact(), this.remoteRepository, (Throwable)e)));
            }
            if (metadataUploads != null && !metadataUploads.isEmpty()) {
                metadataUploads.forEach(d -> d.setException(new MetadataTransferException(d.getMetadata(), this.remoteRepository, (Throwable)e)));
            }
            return;
        }
        this.delegate.put(artifactUploads, metadataUploads);
    }

    public String toString() {
        return "offline( " + this.delegate.toString() + " )";
    }
}

