/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.util.Set;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotIndex;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotPartition;

public class MavibotPartitionFactory
implements PartitionFactory {
    public MavibotPartition createPartition(SchemaManager schemaManager, DnFactory dnFactory, String id, String suffix, int cacheSize, File workingDirectory) throws Exception {
        MavibotPartition partition = new MavibotPartition(schemaManager, dnFactory);
        partition.setId(id);
        partition.setSuffixDn(new Dn(new String[]{suffix}));
        partition.setCacheSize(cacheSize);
        partition.setPartitionPath(workingDirectory.toURI());
        return partition;
    }

    @Override
    public void addIndex(Partition partition, String attributeId, int cacheSize) throws Exception {
        if (!(partition instanceof MavibotPartition)) {
            throw new IllegalArgumentException("Partition must be a MavibotPartition");
        }
        MavibotPartition mavibotPartition = (MavibotPartition)partition;
        Set indexedAttributes = mavibotPartition.getIndexedAttributes();
        MavibotIndex index = new MavibotIndex(attributeId, false);
        index.setCacheSize(cacheSize);
        indexedAttributes.add(index);
        mavibotPartition.setIndexedAttributes(indexedAttributes);
    }
}

