/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiMetricData;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A metric represents a specific metric monitored by the Cloudera Management Services, and a list of values matching a user query. <p> These fields are available only in the \"full\" view: <ul> <li>displayName</li> <li>description</li> </ul>")
public class ApiMetric {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="context")
    private String context = null;
    @SerializedName(value="unit")
    private String unit = null;
    @SerializedName(value="data")
    private List<ApiMetricData> data = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;

    public ApiMetric name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the metric.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiMetric context(String context) {
        this.context = context;
        return this;
    }

    @Schema(description="Context the metric is associated with.")
    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public ApiMetric unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Schema(description="Unit of the metric values.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public ApiMetric data(List<ApiMetricData> data) {
        this.data = data;
        return this;
    }

    public ApiMetric addDataItem(ApiMetricData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<ApiMetricData>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Schema(description="List of readings retrieved from the monitors.")
    public List<ApiMetricData> getData() {
        return this.data;
    }

    public void setData(List<ApiMetricData> data) {
        this.data = data;
    }

    public ApiMetric displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="Requires \"full\" view. User-friendly display name for the metric.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiMetric description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Requires \"full\" view. Description of the metric.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiMetric apiMetric = (ApiMetric)o;
        return Objects.equals(this.name, apiMetric.name) && Objects.equals(this.context, apiMetric.context) && Objects.equals(this.unit, apiMetric.unit) && Objects.equals(this.data, apiMetric.data) && Objects.equals(this.displayName, apiMetric.displayName) && Objects.equals(this.description, apiMetric.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.context, this.unit, this.data, this.displayName, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiMetric {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

