/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.plang;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import org.apache.knox.gateway.plang.AbstractSyntaxTree;
import org.apache.knox.gateway.plang.SyntaxException;

public class Parser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractSyntaxTree parse(String str) {
        if (str == null) return null;
        if (str.trim().equals("")) {
            return null;
        }
        try (PushbackReader reader = new PushbackReader(new StringReader(str));){
            AbstractSyntaxTree ast = this.parse(reader);
            String rest = this.peek(reader);
            if (rest != null) {
                throw new SyntaxException("Unexpected closing " + rest);
            }
            AbstractSyntaxTree abstractSyntaxTree = ast;
            return abstractSyntaxTree;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AbstractSyntaxTree parse(PushbackReader reader) throws IOException {
        String token = this.nextToken(reader);
        if ("(".equals(token)) {
            AbstractSyntaxTree children = new AbstractSyntaxTree(token);
            while (!")".equals(this.peek(reader))) {
                children.addChild(this.parse(reader));
            }
            this.nextToken(reader);
            return children;
        }
        if (")".equals(token)) {
            throw new SyntaxException("Unexpected closing )");
        }
        if ("".equals(token)) {
            throw new SyntaxException("Missing closing )");
        }
        return new AbstractSyntaxTree(token);
    }

    private String nextToken(PushbackReader reader) throws IOException {
        String chr = this.peek(reader);
        if ("'".equals(chr)) {
            return this.parseString(reader);
        }
        if ("(".equals(chr) || ")".equals(chr)) {
            return String.valueOf((char)reader.read());
        }
        return this.parseAtom(reader);
    }

    private String parseAtom(PushbackReader reader) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int chr = reader.read();
        while (chr != -1 && !Character.isWhitespace(chr) && 41 != chr) {
            buffer.append((char)chr);
            chr = reader.read();
        }
        if (chr == 41) {
            reader.unread(41);
        }
        return buffer.toString();
    }

    private String parseString(PushbackReader reader) throws IOException {
        StringBuilder str = new StringBuilder();
        str.append((char)reader.read());
        int chr = reader.read();
        while (chr != -1 && 39 != chr) {
            str.append((char)chr);
            chr = reader.read();
        }
        if (chr == -1) {
            throw new SyntaxException("Unterminated string");
        }
        return str.append("'").toString();
    }

    private String peek(PushbackReader reader) throws IOException {
        int chr = reader.read();
        while (chr != -1 && Character.isWhitespace(chr)) {
            chr = reader.read();
        }
        if (chr == -1) {
            return null;
        }
        reader.unread(chr);
        return String.valueOf((char)chr);
    }
}

