/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.azure;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.immutables.value.Generated;

@Generated(from="AzureStorageConfigurationInfo", generator="Immutables")
public final class ImmutableAzureStorageConfigurationInfo
extends AzureStorageConfigurationInfo {
    private final ImmutableList<String> allowedLocations;
    private final String tenantId;
    @Nullable
    private final String multiTenantAppName;
    @Nullable
    private final String consentUrl;
    private transient int hashCode;

    private ImmutableAzureStorageConfigurationInfo(ImmutableList<String> allowedLocations, String tenantId, @Nullable String multiTenantAppName, @Nullable String consentUrl) {
        this.allowedLocations = allowedLocations;
        this.tenantId = tenantId;
        this.multiTenantAppName = multiTenantAppName;
        this.consentUrl = consentUrl;
    }

    @JsonProperty
    public ImmutableList<String> getAllowedLocations() {
        return this.allowedLocations;
    }

    @Override
    @JsonProperty(required=true)
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getMultiTenantAppName() {
        return this.multiTenantAppName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getConsentUrl() {
        return this.consentUrl;
    }

    public final ImmutableAzureStorageConfigurationInfo withAllowedLocations(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableAzureStorageConfigurationInfo.validate(new ImmutableAzureStorageConfigurationInfo((ImmutableList<String>)newValue, this.tenantId, this.multiTenantAppName, this.consentUrl));
    }

    public final ImmutableAzureStorageConfigurationInfo withAllowedLocations(Iterable<String> elements) {
        if (this.allowedLocations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableAzureStorageConfigurationInfo.validate(new ImmutableAzureStorageConfigurationInfo((ImmutableList<String>)newValue, this.tenantId, this.multiTenantAppName, this.consentUrl));
    }

    public final ImmutableAzureStorageConfigurationInfo withTenantId(String value) {
        String newValue = Objects.requireNonNull(value, "tenantId");
        if (this.tenantId.equals(newValue)) {
            return this;
        }
        return ImmutableAzureStorageConfigurationInfo.validate(new ImmutableAzureStorageConfigurationInfo(this.allowedLocations, newValue, this.multiTenantAppName, this.consentUrl));
    }

    public final ImmutableAzureStorageConfigurationInfo withMultiTenantAppName(@Nullable String value) {
        if (Objects.equals(this.multiTenantAppName, value)) {
            return this;
        }
        return ImmutableAzureStorageConfigurationInfo.validate(new ImmutableAzureStorageConfigurationInfo(this.allowedLocations, this.tenantId, value, this.consentUrl));
    }

    public final ImmutableAzureStorageConfigurationInfo withConsentUrl(@Nullable String value) {
        if (Objects.equals(this.consentUrl, value)) {
            return this;
        }
        return ImmutableAzureStorageConfigurationInfo.validate(new ImmutableAzureStorageConfigurationInfo(this.allowedLocations, this.tenantId, this.multiTenantAppName, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAzureStorageConfigurationInfo && this.equalsByValue((ImmutableAzureStorageConfigurationInfo)another);
    }

    private boolean equalsByValue(ImmutableAzureStorageConfigurationInfo another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.allowedLocations.equals(another.allowedLocations) && this.tenantId.equals(another.tenantId) && Objects.equals(this.multiTenantAppName, another.multiTenantAppName) && Objects.equals(this.consentUrl, another.consentUrl);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.allowedLocations.hashCode();
        h += (h << 5) + this.tenantId.hashCode();
        h += (h << 5) + Objects.hashCode(this.multiTenantAppName);
        h += (h << 5) + Objects.hashCode(this.consentUrl);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AzureStorageConfigurationInfo").omitNullValues().add("allowedLocations", this.allowedLocations).add("tenantId", (Object)this.tenantId).add("multiTenantAppName", (Object)this.multiTenantAppName).add("consentUrl", (Object)this.consentUrl).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAzureStorageConfigurationInfo fromJson(Json json) {
        Builder builder = ImmutableAzureStorageConfigurationInfo.builder();
        if (json._allowedLocations != null) {
            builder.addAllAllowedLocations(json._allowedLocations);
        }
        if (json._tenantId != null) {
            builder.tenantId(json._tenantId);
        }
        if (json._multiTenantAppName != null) {
            builder.multiTenantAppName(json._multiTenantAppName);
        }
        if (json._consentUrl != null) {
            builder.consentUrl(json._consentUrl);
        }
        return builder.build();
    }

    private static ImmutableAzureStorageConfigurationInfo validate(ImmutableAzureStorageConfigurationInfo instance) {
        instance.check();
        return instance;
    }

    public static ImmutableAzureStorageConfigurationInfo copyOf(AzureStorageConfigurationInfo instance) {
        if (instance instanceof ImmutableAzureStorageConfigurationInfo) {
            return (ImmutableAzureStorageConfigurationInfo)instance;
        }
        return ImmutableAzureStorageConfigurationInfo.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableAzureStorageConfigurationInfo.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AzureStorageConfigurationInfo", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TENANT_ID = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<String> allowedLocations = ImmutableList.builder();
        private String tenantId;
        private String multiTenantAppName;
        private String consentUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PolarisStorageConfigurationInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AzureStorageConfigurationInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            PolarisStorageConfigurationInfo instance;
            long bits = 0L;
            if (object instanceof PolarisStorageConfigurationInfo) {
                instance = (PolarisStorageConfigurationInfo)object;
                this.addAllAllowedLocations(instance.getAllowedLocations());
            }
            if (object instanceof AzureStorageConfigurationInfo) {
                instance = (AzureStorageConfigurationInfo)object;
                String multiTenantAppNameValue = ((AzureStorageConfigurationInfo)instance).getMultiTenantAppName();
                if (multiTenantAppNameValue != null) {
                    this.multiTenantAppName(multiTenantAppNameValue);
                }
                this.tenantId(((AzureStorageConfigurationInfo)instance).getTenantId());
                String consentUrlValue = ((AzureStorageConfigurationInfo)instance).getConsentUrl();
                if (consentUrlValue != null) {
                    this.consentUrl(consentUrlValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedLocation(String element) {
            this.allowedLocations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllowedLocations(String ... elements) {
            this.allowedLocations.add((Object[])elements);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder allowedLocations(Iterable<String> elements) {
            this.allowedLocations = ImmutableList.builder();
            return this.addAllAllowedLocations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllowedLocations(Iterable<String> elements) {
            this.allowedLocations.addAll(elements);
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder tenantId(String tenantId) {
            this.tenantId = Objects.requireNonNull(tenantId, "tenantId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder multiTenantAppName(@Nullable String multiTenantAppName) {
            this.multiTenantAppName = multiTenantAppName;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder consentUrl(@Nullable String consentUrl) {
            this.consentUrl = consentUrl;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 1L;
            this.allowedLocations = ImmutableList.builder();
            this.tenantId = null;
            this.multiTenantAppName = null;
            this.consentUrl = null;
            return this;
        }

        public ImmutableAzureStorageConfigurationInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableAzureStorageConfigurationInfo.validate(new ImmutableAzureStorageConfigurationInfo((ImmutableList<String>)this.allowedLocations.build(), this.tenantId, this.multiTenantAppName, this.consentUrl));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tenantId");
            }
            return "Cannot build AzureStorageConfigurationInfo, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="AzureStorageConfigurationInfo", generator="Immutables")
    static final class Json
    extends AzureStorageConfigurationInfo {
        @JsonIgnore
        List<String> _allowedLocations = ImmutableList.of();
        @JsonIgnore
        String _tenantId;
        @JsonIgnore
        String _multiTenantAppName;
        @JsonIgnore
        String _consentUrl;

        Json() {
        }

        @JsonProperty
        public void setAllowedLocations(List<String> allowedLocations) {
            this._allowedLocations = allowedLocations;
        }

        @JsonProperty(required=true)
        public void setTenantId(String tenantId) {
            this._tenantId = tenantId;
        }

        @JsonProperty
        public void setMultiTenantAppName(@Nullable String multiTenantAppName) {
            this._multiTenantAppName = multiTenantAppName;
        }

        @JsonProperty
        public void setConsentUrl(@Nullable String consentUrl) {
            this._consentUrl = consentUrl;
        }

        @Override
        public List<String> getAllowedLocations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTenantId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMultiTenantAppName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getConsentUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

