/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.CurrentContextFactory;

public final class ArcInitConfig {
    public static final ArcInitConfig DEFAULT = ArcInitConfig.builder().build();
    private final boolean strictCompatibility;
    private final CurrentContextFactory currentContextFactory;
    private final boolean testMode;

    public static Builder builder() {
        return new Builder();
    }

    private ArcInitConfig(Builder builder) {
        this.currentContextFactory = builder.currentContextFactory;
        this.strictCompatibility = builder.strictCompatibility;
        this.testMode = builder.testMode;
    }

    public boolean isStrictCompatibility() {
        return this.strictCompatibility;
    }

    public CurrentContextFactory getCurrentContextFactory() {
        return this.currentContextFactory;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public static class Builder {
        private boolean strictCompatibility;
        private CurrentContextFactory currentContextFactory;
        private boolean testMode;

        private Builder() {
        }

        public Builder setStrictCompatibility(boolean strictCompatibility) {
            this.strictCompatibility = strictCompatibility;
            return this;
        }

        public Builder setCurrentContextFactory(CurrentContextFactory currentContextFactory) {
            this.currentContextFactory = currentContextFactory;
            return this;
        }

        public Builder setTestMode(boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public ArcInitConfig build() {
            return new ArcInitConfig(this);
        }
    }
}

