/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisAuthorizerFactory;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.extension.auth.opa.OpaAuthorizationConfig;
import org.apache.polaris.extension.auth.opa.OpaHttpClientFactory;
import org.apache.polaris.extension.auth.opa.OpaPolarisAuthorizer;
import org.apache.polaris.extension.auth.opa.token.BearerTokenProvider;
import org.apache.polaris.extension.auth.opa.token.FileBearerTokenProvider;
import org.apache.polaris.extension.auth.opa.token.StaticBearerTokenProvider;
import org.apache.polaris.nosql.async.AsyncExec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="opa")
class OpaPolarisAuthorizerFactory
implements PolarisAuthorizerFactory {
    private static final Logger logger = LoggerFactory.getLogger(OpaPolarisAuthorizerFactory.class);
    private final OpaAuthorizationConfig opaConfig;
    private final Clock clock;
    private final ObjectMapper objectMapper;
    private final AsyncExec asyncExec;
    private CloseableHttpClient httpClient;
    private BearerTokenProvider bearerTokenProvider;

    @Inject
    public OpaPolarisAuthorizerFactory(OpaAuthorizationConfig opaConfig, Clock clock, AsyncExec asyncExec) {
        this.opaConfig = opaConfig;
        this.clock = clock;
        this.asyncExec = asyncExec;
        this.objectMapper = new ObjectMapper();
    }

    OpaAuthorizationConfig getConfig() {
        return this.opaConfig;
    }

    @PostConstruct
    public void initialize() {
        this.opaConfig.validate();
        this.httpClient = this.createHttpClient();
        this.setupAuthentication(this.opaConfig.auth());
    }

    public PolarisAuthorizer create(RealmConfig realmConfig) {
        URI policyUri = this.opaConfig.policyUri().orElseThrow(() -> new IllegalStateException("OPA policy URI must be configured via polaris.authorization.opa.policy-uri"));
        return new OpaPolarisAuthorizer(policyUri, this.httpClient, this.objectMapper, this.bearerTokenProvider);
    }

    @PreDestroy
    public void cleanup() {
        if (this.bearerTokenProvider != null) {
            try {
                this.bearerTokenProvider.close();
                logger.debug("Bearer token provider closed successfully");
            }
            catch (Exception e) {
                logger.warn("Error closing bearer token provider: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
                logger.debug("HTTP client closed successfully");
            }
            catch (IOException e) {
                logger.warn("Error closing HTTP client: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private CloseableHttpClient createHttpClient() {
        try {
            return OpaHttpClientFactory.createHttpClient(this.opaConfig.http());
        }
        catch (Exception e) {
            return HttpClients.custom().build();
        }
    }

    private void setupAuthentication(OpaAuthorizationConfig.AuthenticationConfig authConfig) {
        switch (authConfig.type()) {
            case BEARER: {
                if (authConfig.bearer().isEmpty()) {
                    throw new IllegalStateException("Bearer configuration is required when type is 'bearer'");
                }
                this.bearerTokenProvider = this.createBearerTokenProvider(authConfig.bearer().get());
                break;
            }
            case NONE: {
                this.bearerTokenProvider = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported authentication type: " + String.valueOf((Object)authConfig.type()));
            }
        }
    }

    private BearerTokenProvider createBearerTokenProvider(OpaAuthorizationConfig.BearerTokenConfig bearerToken) {
        if (bearerToken.staticToken().isPresent()) {
            OpaAuthorizationConfig.BearerTokenConfig.StaticTokenConfig staticConfig = bearerToken.staticToken().get();
            return new StaticBearerTokenProvider(staticConfig.value());
        }
        if (bearerToken.fileBased().isPresent()) {
            OpaAuthorizationConfig.BearerTokenConfig.FileBasedConfig fileConfig = bearerToken.fileBased().get();
            Duration refreshInterval = fileConfig.refreshInterval().orElse(Duration.ofMinutes(5L));
            boolean jwtExpirationRefresh = fileConfig.jwtExpirationRefresh().orElse(true);
            Duration jwtExpirationBuffer = fileConfig.jwtExpirationBuffer().orElse(Duration.ofMinutes(1L));
            return new FileBearerTokenProvider(fileConfig.path(), refreshInterval, jwtExpirationRefresh, jwtExpirationBuffer, Duration.ofSeconds(5L), this.asyncExec, this.clock::instant);
        }
        throw new IllegalStateException("No bearer token configuration found. Must specify either 'static-token' or 'file-based'");
    }
}

