/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.Set;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.persistence.dao.entity.ScopedCredentialsResult;
import org.apache.polaris.core.storage.PolarisCredentialVendor;

public class StorageCredentialsVendor {
    private final PolarisCredentialVendor polarisCredentialVendor;
    private final CallContext callContext;

    public StorageCredentialsVendor(PolarisCredentialVendor polarisCredentialVendor, CallContext callContext) {
        this.polarisCredentialVendor = polarisCredentialVendor;
        this.callContext = callContext;
    }

    public RealmContext getRealmContext() {
        return this.callContext.getRealmContext();
    }

    public RealmConfig getRealmConfig() {
        return this.callContext.getRealmConfig();
    }

    @Nonnull
    public ScopedCredentialsResult getSubscopedCredsForEntity(@Nonnull PolarisEntity entity, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        return this.polarisCredentialVendor.getSubscopedCredsForEntity(this.callContext.getPolarisCallContext(), entity.getCatalogId(), entity.getId(), entity.getType(), allowListOperation, allowedReadLocations, allowedWriteLocations, refreshCredentialsEndpoint);
    }

    public StorageCredentialsVendor() {
    }
}

