/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nonnull;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.apache.polaris.service.catalog.io.DefaultFileIOFactory;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.catalog.io.WasbTranslatingFileIO;

@ApplicationScoped
@Identifier(value="wasb")
public class WasbTranslatingFileIOFactory
implements FileIOFactory {
    private final FileIOFactory defaultFileIOFactory;

    @Inject
    public WasbTranslatingFileIOFactory(StorageCredentialCache storageCredentialCache, MetaStoreManagerFactory metaStoreManagerFactory) {
        this.defaultFileIOFactory = new DefaultFileIOFactory(storageCredentialCache, metaStoreManagerFactory);
    }

    @Override
    public FileIO loadFileIO(@Nonnull CallContext callContext, @Nonnull String ioImplClassName, @Nonnull Map<String, String> properties, @Nonnull TableIdentifier identifier, @Nonnull Set<String> tableLocations, @Nonnull Set<PolarisStorageActions> storageActions, @Nonnull PolarisResolvedPathWrapper resolvedEntityPath) {
        return new WasbTranslatingFileIO(this.defaultFileIOFactory.loadFileIO(callContext, ioImplClassName, properties, identifier, tableLocations, storageActions, resolvedEntityPath));
    }
}

