/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.config.model.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.bifromq.starter.config.model.EngineConfig;

public class EngineConfigDeserializer
extends StdDeserializer<EngineConfig> {
    public EngineConfigDeserializer() {
        super(EngineConfig.class);
    }

    public EngineConfig deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        EngineConfig cfg = new EngineConfig();
        if (node.has("type") && node.get("type").isTextual()) {
            cfg.setType(node.get("type").asText());
        }
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            String k = (String)e.getKey();
            if ("type".equals(k)) continue;
            JsonNode v = (JsonNode)e.getValue();
            cfg.put(k, this.toJava(v));
        }
        return cfg;
    }

    public EngineConfig deserialize(JsonParser p, DeserializationContext ctxt, EngineConfig intoValue) throws IOException {
        if (intoValue == null) {
            return this.deserialize(p, ctxt);
        }
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.has("type") && node.get("type").isTextual()) {
            intoValue.setType(node.get("type").asText());
        }
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            String k = (String)e.getKey();
            if ("type".equals(k)) continue;
            JsonNode v = (JsonNode)e.getValue();
            intoValue.put(k, this.toJava(v));
        }
        return intoValue;
    }

    private Object toJava(JsonNode v) {
        if (v == null || v.isNull()) {
            return null;
        }
        if (v.isBoolean()) {
            return v.booleanValue();
        }
        if (v.isInt()) {
            return v.intValue();
        }
        if (v.isLong()) {
            return v.longValue();
        }
        if (v.isFloatingPointNumber()) {
            return v.doubleValue();
        }
        if (v.isTextual()) {
            return v.textValue();
        }
        return v.toString();
    }
}

