/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.regex.Pattern;
import org.apache.calcite.linq4j.function.Predicate1;

public class LikePattern {
    private static final String ANY = "%";
    public final String pattern;

    public LikePattern(String pattern) {
        if (pattern == null) {
            pattern = ANY;
        }
        this.pattern = pattern;
    }

    public String toString() {
        return "LikePattern[" + this.pattern + "]";
    }

    public Predicate1<String> matcher() {
        return LikePattern.matcher(this.pattern);
    }

    public static LikePattern any() {
        return new LikePattern(ANY);
    }

    public static Predicate1<String> matcher(String likePattern) {
        if (likePattern == null || likePattern.equals(ANY)) {
            return v1 -> true;
        }
        Pattern regex = LikePattern.likeToRegex(likePattern);
        return v1 -> regex.matcher((CharSequence)v1).matches();
    }

    public static Pattern likeToRegex(String pattern) {
        StringBuilder buf = new StringBuilder("^");
        char[] charArray = pattern.toCharArray();
        int slash = -2;
        block6: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (slash == i - 1) {
                buf.append('[').append(c).append(']');
                continue;
            }
            switch (c) {
                case '\\': {
                    slash = i;
                    continue block6;
                }
                case '%': {
                    buf.append(".*");
                    continue block6;
                }
                case '[': {
                    buf.append("\\[");
                    continue block6;
                }
                case ']': {
                    buf.append("\\]");
                    continue block6;
                }
                default: {
                    buf.append('[').append(c).append(']');
                }
            }
        }
        buf.append("$");
        return Pattern.compile(buf.toString());
    }
}

