/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import org.apache.ignite.internal.network.serialization.BuiltInType;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.ClassDescriptorFactory;
import org.apache.ignite.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.Classes;
import org.apache.ignite.internal.network.serialization.marshal.ProxyMarshaller;
import org.apache.ignite.internal.util.StringIntrospection;
import org.jetbrains.annotations.Nullable;

class LocalDescriptors {
    private final ClassDescriptorRegistry localRegistry;
    private final ClassDescriptorFactory descriptorFactory;

    LocalDescriptors(ClassDescriptorRegistry localRegistry, ClassDescriptorFactory descriptorFactory) {
        this.localRegistry = localRegistry;
        this.descriptorFactory = descriptorFactory;
    }

    ClassDescriptor getOrCreateDescriptor(@Nullable Object object) {
        if (object == null) {
            return this.localRegistry.getNullDescriptor();
        }
        if (object instanceof String && StringIntrospection.supportsFastGetLatin1Bytes((String)((String)object))) {
            return this.localRegistry.getBuiltInDescriptor(BuiltInType.STRING_LATIN1);
        }
        return this.getOrCreateDescriptor(object.getClass());
    }

    private ClassDescriptor getOrCreateDescriptor(Class<?> objectClass) {
        ClassDescriptor descriptor = this.resolveDescriptor(objectClass);
        if (descriptor != null) {
            return descriptor;
        }
        Class<?> normalizedClass = this.normalizeClass(objectClass);
        return this.descriptorFactory.create(normalizedClass);
    }

    @Nullable
    private ClassDescriptor resolveDescriptor(Class<?> objectClass) {
        if (ProxyMarshaller.isProxyClass(objectClass)) {
            return this.localRegistry.getProxyDescriptor();
        }
        Class<?> normalizedClass = this.normalizeClass(objectClass);
        return this.localRegistry.getDescriptor(normalizedClass);
    }

    private Class<?> normalizeClass(Class<?> objectClass) {
        if (Classes.isRuntimeEnum(objectClass)) {
            return Classes.enumClassAsInSourceCode(objectClass);
        }
        return objectClass;
    }
}

