/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.search.SearchKeywordResolver;
import org.apache.myfaces.core.api.shared.ComponentUtils;

public class FormSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String FORM_KEYWORD = "form";

    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        expressionContext.invokeContextCallback((UIComponent)ComponentUtils.findClosest(UIForm.class, (UIComponent)current));
    }

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return FORM_KEYWORD.equalsIgnoreCase(keyword);
    }

    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return searchExpressionContext.getExpressionHints() != null && searchExpressionContext.getExpressionHints().contains(SearchExpressionHint.RESOLVE_CLIENT_SIDE);
    }

    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return false;
    }
}

