/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomee.security.cdi.BasicAuthenticationMechanism;
import org.apache.tomee.security.cdi.CustomFormAuthenticationMechanism;
import org.apache.tomee.security.cdi.DefaultAuthenticationMechanism;
import org.apache.tomee.security.cdi.FormAuthenticationMechanism;

@ApplicationScoped
public class TomEESecurityServletAuthenticationMechanismMapper {
    private final Map<String, HttpAuthenticationMechanism> servletAuthenticationMapper = new ConcurrentHashMap<String, HttpAuthenticationMechanism>();
    @Inject
    private Instance<HttpAuthenticationMechanism> authenticationMechanisms;
    @Inject
    private DefaultAuthenticationMechanism defaultAuthenticationMechanism;

    public void init(@Observes @Initialized(value=ApplicationScoped.class) ServletContext context) {
        Map servletRegistrations = context.getServletRegistrations();
        servletRegistrations.forEach((servletName, servletRegistration) -> {
            try {
                Class<?> servletClass = Thread.currentThread().getContextClassLoader().loadClass((String)servletName);
                if (servletClass.isAnnotationPresent(BasicAuthenticationMechanismDefinition.class)) {
                    this.servletAuthenticationMapper.put((String)servletName, (HttpAuthenticationMechanism)CDI.current().select(BasicAuthenticationMechanism.class, new Annotation[0]).get());
                }
                if (servletClass.isAnnotationPresent(FormAuthenticationMechanismDefinition.class)) {
                    this.servletAuthenticationMapper.put((String)servletName, (HttpAuthenticationMechanism)CDI.current().select(FormAuthenticationMechanism.class, new Annotation[0]).get());
                }
                if (servletClass.isAnnotationPresent(CustomFormAuthenticationMechanismDefinition.class)) {
                    this.servletAuthenticationMapper.put((String)servletName, (HttpAuthenticationMechanism)CDI.current().select(CustomFormAuthenticationMechanism.class, new Annotation[0]).get());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
        Set availableBeans = this.authenticationMechanisms.stream().collect(Collectors.toSet());
        availableBeans.removeAll(this.servletAuthenticationMapper.values());
        availableBeans.remove(this.defaultAuthenticationMechanism);
        if (availableBeans.size() == 1) {
            this.defaultAuthenticationMechanism.setDelegate((HttpAuthenticationMechanism)availableBeans.iterator().next());
        } else {
            if (availableBeans.size() > 1) {
                throw new IllegalStateException("Multiple HttpAuthenticationMechanism found " + availableBeans.stream().map(b -> StringUtils.substringBefore((String)b.getClass().getSimpleName(), (String)"$$")).collect(Collectors.toList()) + " without a @WebServlet association. Deploy a single one for the application, or associate it with a @WebServlet.");
            }
            if (this.servletAuthenticationMapper.size() == 1) {
                this.defaultAuthenticationMechanism.setDelegate(this.servletAuthenticationMapper.values().iterator().next());
            }
        }
    }

    public HttpAuthenticationMechanism getCurrentAuthenticationMechanism(HttpMessageContext httpMessageContext) {
        HttpServletRequest request = httpMessageContext.getRequest();
        if (request.getRequestURI().endsWith("j_security_check")) {
            return (HttpAuthenticationMechanism)CDI.current().select(FormAuthenticationMechanism.class, new Annotation[0]).get();
        }
        String servletName = request.getHttpServletMapping().getServletName();
        return this.servletAuthenticationMapper.getOrDefault(servletName, this.defaultAuthenticationMechanism);
    }
}

