/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.http;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class MediaTypeAssert
extends AbstractObjectAssert<MediaTypeAssert, MediaType> {
    public MediaTypeAssert(@Nullable String actual) {
        this(StringUtils.hasText((String)actual) ? MediaType.parseMediaType((String)actual) : null);
    }

    public MediaTypeAssert(@Nullable MediaType mediaType) {
        super((Object)mediaType, MediaTypeAssert.class);
        this.as("Media type", new Object[0]);
    }

    public MediaTypeAssert isEqualTo(String mediaType) {
        return (MediaTypeAssert)this.isEqualTo(this.parseMediaType(mediaType));
    }

    public MediaTypeAssert isNotEqualTo(String mediaType) {
        return (MediaTypeAssert)this.isNotEqualTo(this.parseMediaType(mediaType));
    }

    public MediaTypeAssert isCompatibleWith(MediaType mediaType) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((MediaType)this.actual)).withFailMessage("Expecting null to be compatible with '%s'", new Object[]{mediaType})).isNotNull();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)mediaType).withFailMessage("Expecting '%s' to be compatible with null", new Object[]{this.actual})).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MediaType)this.actual).isCompatibleWith(mediaType)).as("check media type '%s' is compatible with '%s'", new Object[]{((MediaType)this.actual).toString(), mediaType.toString()})).isTrue();
        return this;
    }

    public MediaTypeAssert isCompatibleWith(String mediaType) {
        return this.isCompatibleWith(this.parseMediaType(mediaType));
    }

    private MediaType parseMediaType(String value) {
        try {
            return MediaType.parseMediaType((String)value);
        }
        catch (InvalidMediaTypeException ex) {
            throw Failures.instance().failure((AssertionInfo)this.info, (ErrorMessageFactory)new ShouldBeValidMediaType(value, ex.getMessage()));
        }
    }

    private static final class ShouldBeValidMediaType
    extends BasicErrorMessageFactory {
        private ShouldBeValidMediaType(String mediaType, String errorMessage) {
            super("%nExpecting:%n  %s%nTo be a valid media type but got:%n  %s%n", new Object[]{mediaType, errorMessage});
        }
    }
}

