/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.jcr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.naming.NamingException;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.sling.jcr.api.SlingRepository;

public class RepositoryUtil {
    public static final String ADMIN_NAME = "admin";
    public static final String ADMIN_PASSWORD = "admin";
    public static final String HOME_DIR = "target/repository";
    public static final String CONFIG_FILE = "jackrabbit-test-config.xml";
    private static SlingRepository repository;
    private static Session adminSession;

    public static void startRepository() throws RepositoryException {
        if (adminSession == null) {
            InputStream ins = RepositoryUtil.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
            if (ins == null) {
                throw new RepositoryException("Cannot get jackrabbit-test-config.xml");
            }
            File configFile = new File(HOME_DIR, "repository.xml");
            configFile.getParentFile().mkdirs();
            FileOutputStream out = null;
            try {
                int rd;
                out = new FileOutputStream(configFile);
                byte[] buf = new byte[1024];
                while ((rd = ins.read(buf)) >= 0) {
                    out.write(buf, 0, rd);
                }
            }
            catch (IOException ioe) {
                throw new RepositoryException("Cannot copy configuration file to " + String.valueOf(configFile));
            }
            finally {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (System.getProperty("derby.stream.error.file") == null) {
                String derbyLog = "target/repository/derby.log";
                System.setProperty("derby.stream.error.file", derbyLog);
            }
            File f = new File(HOME_DIR);
            repository = new RepositoryWrapper(JcrUtils.getRepository((String)f.toURI().toString()));
            adminSession = repository.loginAdministrative(null);
        }
    }

    public static void stopRepository() throws NamingException {
        if (adminSession != null) {
            adminSession.logout();
            adminSession = null;
            repository = null;
        }
    }

    public static SlingRepository getRepository() {
        return repository;
    }

    public static boolean registerNodeType(Session session, InputStream source) throws IOException, RepositoryException {
        try {
            CndImporter.registerNodeTypes((Reader)new InputStreamReader(source, "UTF-8"), (Session)session);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void registerSlingNodeTypes(Session adminSession) throws IOException, RepositoryException {
        Class<RepositoryUtil> clazz = RepositoryUtil.class;
        RepositoryUtil.registerNodeType(adminSession, clazz.getResourceAsStream("/SLING-INF/nodetypes/folder.cnd"));
        RepositoryUtil.registerNodeType(adminSession, clazz.getResourceAsStream("/SLING-INF/nodetypes/resource.cnd"));
        RepositoryUtil.registerNodeType(adminSession, clazz.getResourceAsStream("/SLING-INF/nodetypes/vanitypath.cnd"));
    }

    public static final class RepositoryWrapper
    implements SlingRepository {
        protected final Repository wrapped;

        public RepositoryWrapper(Repository r) {
            this.wrapped = r;
        }

        public String getDescriptor(String key) {
            return this.wrapped.getDescriptor(key);
        }

        public String[] getDescriptorKeys() {
            return this.wrapped.getDescriptorKeys();
        }

        public Session login() throws LoginException, RepositoryException {
            return this.wrapped.login();
        }

        public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
            return this.wrapped.login(credentials, workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
        }

        public Session login(Credentials credentials) throws LoginException, RepositoryException {
            return this.wrapped.login(credentials);
        }

        public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
            return this.wrapped.login(workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
        }

        public String getDefaultWorkspace() {
            return "default";
        }

        public Session loginAdministrative(String workspaceName) throws RepositoryException {
            SimpleCredentials credentials = new SimpleCredentials("admin", "admin".toCharArray());
            return this.login((Credentials)credentials, workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
        }

        public Value getDescriptorValue(String key) {
            return this.wrapped.getDescriptorValue(key);
        }

        public Value[] getDescriptorValues(String key) {
            return this.wrapped.getDescriptorValues(key);
        }

        public boolean isSingleValueDescriptor(String key) {
            return this.wrapped.isSingleValueDescriptor(key);
        }

        public boolean isStandardDescriptor(String key) {
            return this.wrapped.isStandardDescriptor(key);
        }

        public Session loginService(String subServiceName, String workspace) throws LoginException, RepositoryException {
            throw new UnsupportedOperationException();
        }

        public Session impersonateFromService(String subServiceName, Credentials credentials, String workspaceName) throws LoginException, RepositoryException {
            throw new UnsupportedOperationException();
        }
    }
}

