/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.CmdTopics;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToMillisConverter;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToSecondsConverter;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations on persistent topics. The persistent-topics has been deprecated in favor of topics"}, hidden=true)
public class CmdPersistentTopics
extends CmdBase {
    private Topics persistentTopics;

    public CmdPersistentTopics(Supplier<PulsarAdmin> admin) {
        super("persistent", admin);
        this.addCommand("list", new ListCmd());
        this.addCommand("list-partitioned-topics", new PartitionedTopicListCmd());
        this.addCommand("permissions", new Permissions());
        this.addCommand("grant-permission", new GrantPermissions());
        this.addCommand("revoke-permission", new RevokePermissions());
        this.addCommand("lookup", new Lookup());
        this.addCommand("bundle-range", new GetBundleRange());
        this.addCommand("delete", new DeleteCmd());
        this.addCommand("unload", new UnloadCmd());
        this.addCommand("truncate", new TruncateCmd());
        this.addCommand("subscriptions", new ListSubscriptions());
        this.addCommand("unsubscribe", new DeleteSubscription());
        this.addCommand("create-subscription", new CreateSubscription());
        this.addCommand("stats", new GetStats());
        this.addCommand("stats-internal", new GetInternalStats());
        this.addCommand("info-internal", new GetInternalInfo());
        this.addCommand("partitioned-stats", new GetPartitionedStats());
        this.addCommand("partitioned-stats-internal", new GetPartitionedStatsInternal());
        this.addCommand("skip", new Skip());
        this.addCommand("skip-all", new SkipAll());
        this.addCommand("expire-messages", new ExpireMessages());
        this.addCommand("expire-messages-all-subscriptions", new ExpireMessagesForAllSubscriptions());
        this.addCommand("create-partitioned-topic", new CreatePartitionedCmd());
        this.addCommand("update-partitioned-topic", new UpdatePartitionedCmd());
        this.addCommand("get-partitioned-topic-metadata", new GetPartitionedTopicMetadataCmd());
        this.addCommand("delete-partitioned-topic", new DeletePartitionedCmd());
        this.addCommand("peek-messages", new PeekMessages());
        this.addCommand("get-message-by-id", new GetMessageById());
        this.addCommand("last-message-id", new GetLastMessageId());
        this.addCommand("reset-cursor", new ResetCursor());
        this.addCommand("terminate", new Terminate());
        this.addCommand("compact", new Compact());
        this.addCommand("compaction-status", new CompactionStatusCmd());
    }

    private Topics getPersistentTopics() {
        if (this.persistentTopics == null) {
            this.persistentTopics = this.getAdmin().topics();
        }
        return this.persistentTopics;
    }

    @CommandLine.Command(description={"Get the list of topics under a namespace."})
    private class ListCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private ListCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = ListCmd.validateNamespace(this.namespaceName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getList(namespace));
        }
    }

    @CommandLine.Command(description={"Get the list of partitioned topics under a namespace."})
    private class PartitionedTopicListCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private PartitionedTopicListCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = PartitionedTopicListCmd.validateNamespace(this.namespaceName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPartitionedTopicList(namespace));
        }
    }

    @CommandLine.Command(description={"Get the permissions on a topic. Retrieve the effective permissions for a topic. These permissions are defined by the permissions set at the namespace level combined (union) with any eventual specific permission set on the topic."})
    private class Permissions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Permissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Permissions.validateTopicName(this.topicName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPermissions(topic));
        }
    }

    @CommandLine.Command(description={"Grant a new permission to a client role on a single topic."})
    private class GrantPermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--role"}, description={"Client role to which grant permissions"}, required=true)
        private String role;
        @CommandLine.Option(names={"--actions"}, description={"Actions to be granted (produce,consume,sources,sinks,functions,packages)"}, required=true)
        private List<String> actions;

        private GrantPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GrantPermissions.validateTopicName(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().grantPermission(topic, this.role, this.getAuthActions(this.actions));
        }
    }

    @CommandLine.Command(description={"Revoke permissions on a topic. Revoke permissions to a client role on a single topic. If the permission was not set at the topic level, but rather at the namespace level, this operation will return an error (HTTP status code 412)."})
    private class RevokePermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--role"}, description={"Client role to which revoke permissions"}, required=true)
        private String role;

        private RevokePermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = RevokePermissions.validateTopicName(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().revokePermissions(topic, this.role);
        }
    }

    @CommandLine.Command(description={"Lookup a topic from the current serving broker"})
    private class Lookup
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Lookup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Lookup.validateTopicName(this.topicName);
            this.print(CmdPersistentTopics.this.getAdmin().lookups().lookupTopic(topic));
        }
    }

    @CommandLine.Command(description={"Get Namespace bundle range of a topic"})
    private class GetBundleRange
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetBundleRange() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetBundleRange.validateTopicName(this.topicName);
            this.print(CmdPersistentTopics.this.getAdmin().lookups().getBundleRange(topic));
        }
    }

    @CommandLine.Command(description={"Delete a topic. The topic cannot be deleted if there's any active subscription or producers connected to it."})
    private class DeleteCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--force"}, description={"Close all producer/consumer/replicator and delete topic forcefully"})
        private boolean force = false;

        private DeleteCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = DeleteCmd.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().delete(persistentTopic, this.force);
        }
    }

    @CommandLine.Command(description={"Unload a topic."})
    private class UnloadCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private UnloadCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = UnloadCmd.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().unload(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Truncate a topic. \n\t\tThe truncate operation will move all cursors to the end of the topic and delete all inactive ledgers. "})
    private class TruncateCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private TruncateCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = TruncateCmd.validateTopicName(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().truncate(topic);
        }
    }

    @CommandLine.Command(description={"Get the list of subscriptions on the topic"})
    private class ListSubscriptions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private ListSubscriptions() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = ListSubscriptions.validatePersistentTopic(this.topicName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getSubscriptions(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Delete a durable subscriber from a topic. The subscription cannot be deleted if there are any active consumers attached to it"})
    private class DeleteSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-f", "--force"}, description={"Disconnect and close all consumers and delete subscription forcefully"})
        private boolean force = false;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be deleted"}, required=true)
        private String subName;

        private DeleteSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = DeleteSubscription.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().deleteSubscription(persistentTopic, this.subName, this.force);
        }
    }

    @CommandLine.Command(description={"Create a new subscription on a topic"})
    private class CreateSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription name"}, required=true)
        private String subscriptionName;
        @CommandLine.Option(names={"--messageId", "-m"}, description={"messageId where to create the subscription. It can be either 'latest', 'earliest' or (ledgerId:entryId)"}, required=false)
        private String messageIdStr = "latest";
        @CommandLine.Option(names={"--property", "-p"}, description={"key value pair properties(-p a=b -p c=d)"}, required=false)
        private Map<String, String> properties;

        private CreateSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = CreateSubscription.validatePersistentTopic(this.topicName);
            MessageId messageId = this.messageIdStr.equals("latest") ? MessageId.latest : (this.messageIdStr.equals("earliest") ? MessageId.earliest : CreateSubscription.validateMessageIdString(this.messageIdStr));
            CmdPersistentTopics.this.getPersistentTopics().createSubscription(persistentTopic, this.subscriptionName, messageId, false, this.properties);
        }
    }

    @CommandLine.Command(description={"Get the stats for the topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period."})
    private class GetStats
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-gpb", "--get-precise-backlog"}, description={"Set true to get precise backlog"})
        private boolean getPreciseBacklog = false;

        private GetStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetStats.validatePersistentTopic(this.topicName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getStats(persistentTopic, this.getPreciseBacklog));
        }
    }

    @CommandLine.Command(description={"Get the internal stats for the topic"})
    private class GetInternalStats
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-m", "--metadata"}, description={"Flag to include ledger metadata"})
        private boolean metadata = false;

        private GetInternalStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInternalStats.validatePersistentTopic(this.topicName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getInternalStats(persistentTopic, this.metadata));
        }
    }

    @CommandLine.Command(description={"Get the internal metadata info for the topic"})
    private class GetInternalInfo
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetInternalInfo() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInternalInfo.validatePersistentTopic(this.topicName);
            String result = CmdPersistentTopics.this.getPersistentTopics().getInternalInfo(persistentTopic);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((Object)result));
        }
    }

    @CommandLine.Command(description={"Get the stats for the partitioned topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period."})
    private class GetPartitionedStats
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--per-partition"}, description={"Get per partition stats"})
        private boolean perPartition = false;

        private GetPartitionedStats() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = GetPartitionedStats.validatePersistentTopic(this.topicName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPartitionedStats(persistentTopic, this.perPartition));
        }
    }

    @CommandLine.Command(description={"Get the stats-internal for the partitioned topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period."})
    private class GetPartitionedStatsInternal
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetPartitionedStatsInternal() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = GetPartitionedStatsInternal.validatePersistentTopic(this.topicName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPartitionedInternalStats(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Skip some messages for the subscription"})
    private class Skip
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be skip messages on"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-n", "--count"}, description={"Number of messages to skip"}, required=true)
        private long numMessages;

        private Skip() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Skip.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().skipMessages(persistentTopic, this.subName, this.numMessages);
        }
    }

    @CommandLine.Command(description={"Skip all the messages for the subscription"})
    private class SkipAll
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be cleared"}, required=true)
        private String subName;

        private SkipAll() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SkipAll.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().skipAllMessages(persistentTopic, this.subName);
        }
    }

    @CommandLine.Command(description={"Expire messages that older than given expiry time (in seconds) for the subscription"})
    private class ExpireMessages
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be skip messages on"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-t", "--expireTime"}, description={"Expire messages older than time in seconds (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w)"}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long expireTimeInSeconds;

        private ExpireMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ExpireMessages.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().expireMessages(persistentTopic, this.subName, this.expireTimeInSeconds.longValue());
        }
    }

    @CommandLine.Command(description={"Expire messages that older than given expiry time (in seconds) for all subscriptions"})
    private class ExpireMessagesForAllSubscriptions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-t", "--expireTime"}, description={"Expire messages older than time in seconds (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w)"}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long expireTimeInSeconds;

        private ExpireMessagesForAllSubscriptions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ExpireMessagesForAllSubscriptions.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().expireMessagesForAllSubscriptions(persistentTopic, this.expireTimeInSeconds.longValue());
        }
    }

    @CommandLine.Command(description={"Create a partitioned topic. The partitioned topic has to be created before creating a producer on it."})
    private class CreatePartitionedCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-p", "--partitions"}, description={"Number of partitions for the topic"}, required=true)
        private int numPartitions;

        private CreatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = CreatePartitionedCmd.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().createPartitionedTopic(persistentTopic, this.numPartitions);
        }
    }

    @CommandLine.Command(description={"Update existing partitioned topic. New updating number of partitions must be greater than existing number of partitions."})
    private class UpdatePartitionedCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-p", "--partitions"}, description={"Number of partitions for the topic"}, required=true)
        private int numPartitions;

        private UpdatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = UpdatePartitionedCmd.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().updatePartitionedTopic(persistentTopic, this.numPartitions);
        }
    }

    @CommandLine.Command(description={"Get the partitioned topic metadata. If the topic is not created or is a non-partitioned topic, it returns empty topic with 0 partitions"})
    private class GetPartitionedTopicMetadataCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetPartitionedTopicMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = GetPartitionedTopicMetadataCmd.validatePersistentTopic(this.topicName);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPartitionedTopicMetadata(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Delete a partitioned topic. It will also delete all the partitions of the topic if it exists."})
    private class DeletePartitionedCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--force"}, description={"Close all producer/consumer/replicator and delete topic forcefully"})
        private boolean force = false;

        private DeletePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = DeletePartitionedCmd.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().deletePartitionedTopic(persistentTopic, this.force);
        }
    }

    @CommandLine.Command(description={"Peek some messages for the subscription"})
    private class PeekMessages
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to get messages from"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-n", "--count"}, description={"Number of messages (default 1)"}, required=false)
        private int numMessages = 1;

        private PeekMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = PeekMessages.validatePersistentTopic(this.topicName);
            List messages = CmdPersistentTopics.this.getPersistentTopics().peekMessages(persistentTopic, this.subName, this.numMessages);
            CmdTopics.printMessages(messages, false, this);
        }
    }

    @CommandLine.Command(description={"Get message by its ledgerId and entryId"})
    private class GetMessageById
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://property/cluster/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-l", "--ledgerId"}, description={"ledger id pointing to the desired ledger"}, required=true)
        private long ledgerId;
        @CommandLine.Option(names={"-e", "--entryId"}, description={"entry id pointing to the desired entry"}, required=true)
        private long entryId;

        private GetMessageById() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageById.validatePersistentTopic(this.topicName);
            Message message = CmdPersistentTopics.this.getPersistentTopics().getMessageById(persistentTopic, this.ledgerId, this.entryId);
            ByteBuf date = Unpooled.wrappedBuffer((byte[])message.getData());
            System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)date));
        }
    }

    @CommandLine.Command(description={"Get last message Id of the topic"})
    private class GetLastMessageId
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://property/cluster/namespace/topic"}, arity="1")
        private String topicName;

        private GetLastMessageId() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetLastMessageId.validatePersistentTopic(this.topicName);
            MessageId messageId = CmdPersistentTopics.this.getPersistentTopics().getLastMessageId(persistentTopic);
            this.print(messageId);
        }
    }

    @CommandLine.Command(description={"Reset position for subscription to position closest to timestamp or messageId"})
    private class ResetCursor
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to reset position on"}, required=true)
        private String subName;
        @CommandLine.Option(names={"--time", "-t"}, description={"time in minutes to reset back to (or minutes, hours,days,weeks eg: 100m, 3h, 2d, 5w)"}, required=false, converter={TimeUnitToMillisConverter.class})
        private Long resetTimeInMillis = null;
        @CommandLine.Option(names={"--messageId", "-m"}, description={"messageId to reset back to (ledgerId:entryId)"}, required=false)
        private String resetMessageIdStr;

        private ResetCursor() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ResetCursor.validatePersistentTopic(this.topicName);
            if (StringUtils.isNotBlank((CharSequence)this.resetMessageIdStr)) {
                MessageId messageId = ResetCursor.validateMessageIdString(this.resetMessageIdStr);
                CmdPersistentTopics.this.getPersistentTopics().resetCursor(persistentTopic, this.subName, messageId);
            } else if (Objects.nonNull(this.resetTimeInMillis)) {
                long timestamp = System.currentTimeMillis() - this.resetTimeInMillis;
                CmdPersistentTopics.this.getPersistentTopics().resetCursor(persistentTopic, this.subName, timestamp);
            } else {
                throw new PulsarAdminException("Either Timestamp (--time) or Position (--position) has to be provided to reset cursor");
            }
        }
    }

    @CommandLine.Command(description={"Terminate a topic and don't allow any more messages to be published"})
    private class Terminate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Terminate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Terminate.validatePersistentTopic(this.topicName);
            try {
                MessageId lastMessageId = (MessageId)CmdPersistentTopics.this.getPersistentTopics().terminateTopicAsync(persistentTopic).get();
                System.out.println("Topic successfully terminated at " + String.valueOf(lastMessageId));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @CommandLine.Command(description={"Compact a topic"})
    private class Compact
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Compact() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Compact.validatePersistentTopic(this.topicName);
            CmdPersistentTopics.this.getPersistentTopics().triggerCompaction(persistentTopic);
            System.out.println("Topic compaction requested for " + persistentTopic);
        }
    }

    @CommandLine.Command(description={"Status of compaction on a topic"})
    private class CompactionStatusCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-w", "--wait-complete"}, description={"Wait for compaction to complete"}, required=false)
        private boolean wait = false;

        private CompactionStatusCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = CompactionStatusCmd.validatePersistentTopic(this.topicName);
            try {
                LongRunningProcessStatus status = CmdPersistentTopics.this.getPersistentTopics().compactionStatus(persistentTopic);
                while (this.wait && status.status == LongRunningProcessStatus.Status.RUNNING) {
                    Thread.sleep(1000L);
                    status = CmdPersistentTopics.this.getPersistentTopics().compactionStatus(persistentTopic);
                }
                switch (status.status) {
                    case NOT_RUN: {
                        System.out.println("Compaction has not been run for " + persistentTopic + " since broker startup");
                        break;
                    }
                    case RUNNING: {
                        System.out.println("Compaction is currently running");
                        break;
                    }
                    case SUCCESS: {
                        System.out.println("Compaction was a success");
                        break;
                    }
                    case ERROR: {
                        System.out.println("Error in compaction");
                        throw new PulsarAdminException("Error compacting: " + status.lastError);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }
}

