/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.pm.PatternCompiler;
import org.netbeans.spi.java.hints.HintContext;

public class MatcherUtilities {
    public static boolean matches(@NonNull HintContext ctx, @NonNull TreePath variable, @NonNull String pattern) {
        return MatcherUtilities.matches(ctx, variable, pattern, null, null, null);
    }

    public static boolean matches(@NonNull HintContext ctx, @NonNull TreePath variable, @NonNull String pattern, boolean fillInVariablesHack) {
        return MatcherUtilities.matches(ctx, variable, pattern, ctx.getVariables(), ctx.getMultiVariables(), ctx.getVariableNames(), fillInVariablesHack ? ctx.getConstraints() : Map.of());
    }

    public static boolean matches(@NonNull HintContext ctx, @NonNull TreePath variable, @NonNull String pattern, Map<String, TreePath> outVariables, Map<String, Collection<? extends TreePath>> outMultiVariables, Map<String, String> outVariables2Names) {
        return MatcherUtilities.matches(ctx, variable, pattern, outVariables, outMultiVariables, outVariables2Names, Map.of());
    }

    public static boolean matches(@NonNull HintContext ctx, @NonNull TreePath variable, @NonNull String pattern, Map<String, TreePath> outVariables, Map<String, Collection<? extends TreePath>> outMultiVariables, Map<String, String> outVariables2Names, Map<String, TypeMirror> variable2Type) {
        Pattern p = PatternCompiler.compile(ctx.getInfo(), pattern, variable2Type, List.of());
        HashMap<String, TreePath> variables = new HashMap<String, TreePath>(ctx.getVariables());
        HashMap<String, Collection<? extends TreePath>> multiVariables = new HashMap<String, Collection<? extends TreePath>>(ctx.getMultiVariables());
        HashMap<String, String> variables2Names = new HashMap<String, String>(ctx.getVariableNames());
        Collection<? extends Occurrence> occurrences = Matcher.create(ctx.getInfo()).setCancel(new AtomicBoolean()).setPresetVariable(variables, multiVariables, variables2Names).setSearchRoot(variable).setTreeTopSearch().match(p);
        if (occurrences.iterator().hasNext()) {
            Occurrence od = (Occurrence)occurrences.iterator().next();
            MatcherUtilities.outVariables(outVariables, od.getVariables(), ctx.getVariables());
            MatcherUtilities.outVariables(outMultiVariables, od.getMultiVariables(), ctx.getMultiVariables());
            MatcherUtilities.outVariables(outVariables2Names, od.getVariables2Names(), ctx.getVariableNames());
            return true;
        }
        return false;
    }

    public static boolean matches(@NonNull HintContext ctx, @NonNull Collection<? extends TreePath> variable, @NonNull String pattern, Map<String, TreePath> outVariables, Map<String, Collection<? extends TreePath>> outMultiVariables, Map<String, String> outVariables2Names) {
        List<Tree> patternTrees;
        Scope s = Utilities.constructScope(ctx.getInfo(), Map.of());
        Tree patternTree = Utilities.parseAndAttribute(ctx.getInfo(), pattern, s);
        if (Utilities.isFakeBlock(patternTree)) {
            List<? extends StatementTree> statements = ((BlockTree)patternTree).getStatements();
            patternTrees = statements.subList(1, statements.size() - 1);
        } else {
            patternTrees = List.of(patternTree);
        }
        if (variable.size() != patternTrees.size()) {
            return false;
        }
        Map<String, TreePath> variables = new HashMap<String, TreePath>(ctx.getVariables());
        Map<String, Collection<? extends TreePath>> multiVariables = new HashMap<String, Collection<? extends TreePath>>(ctx.getMultiVariables());
        Map<String, String> variables2Names = new HashMap<String, String>(ctx.getVariableNames());
        Iterator<? extends TreePath> variableIt = variable.iterator();
        Iterator<Tree> patternTreesIt = patternTrees.iterator();
        while (variableIt.hasNext() && patternTreesIt.hasNext()) {
            TreePath patternTreePath = new TreePath(new TreePath(ctx.getInfo().getCompilationUnit()), patternTreesIt.next());
            Pattern p = Pattern.createPatternWithFreeVariables(patternTreePath, Map.of());
            Collection<? extends Occurrence> occurrences = Matcher.create(ctx.getInfo()).setCancel(new AtomicBoolean()).setPresetVariable(variables, multiVariables, variables2Names).setSearchRoot(variableIt.next()).setTreeTopSearch().match(p);
            if (!occurrences.iterator().hasNext()) {
                return false;
            }
            Occurrence od = (Occurrence)occurrences.iterator().next();
            variables = od.getVariables();
            multiVariables = od.getMultiVariables();
            variables2Names = od.getVariables2Names();
        }
        if (variableIt.hasNext() == patternTreesIt.hasNext()) {
            MatcherUtilities.outVariables(outVariables, variables, ctx.getVariables());
            MatcherUtilities.outVariables(outMultiVariables, multiVariables, ctx.getMultiVariables());
            MatcherUtilities.outVariables(outVariables2Names, variables2Names, ctx.getVariableNames());
            return true;
        }
        return false;
    }

    private static <T> void outVariables(Map<String, T> outMap, Map<String, T> currentValues, Map<String, T> origValues) {
        if (outMap == null) {
            return;
        }
        currentValues.keySet().removeAll(origValues.keySet());
        outMap.putAll(currentValues);
    }
}

