/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.ArrayList;
import java.util.Collections;
import jpt.sun.source.tree.AnnotationTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.annotation.processing.AbstractProcessor;
import jpt30.annotation.processing.Processor;
import jpt30.annotation.processing.SupportedSourceVersion;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import jpt30.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;

public class AnnotationProcessors {
    private static final String PROCESSOR_TYPE = Processor.class.getName();
    private static final String ABSTRACT_PROCESSOR_TYPE = AbstractProcessor.class.getName();
    private static final String SUPPORTED_SOURCE_TYPE = SupportedSourceVersion.class.getName();
    private static final String SOURCE_VERSION_TYPE = SourceVersion.class.getName();
    private static final String METHOD_SUPPORTED_SOURCE_VERSION = "getSupportedSourceVersion";

    private AnnotationProcessors() {
    }

    public static ErrorDescription oGSA(HintContext ctx) {
        Element clazz = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (clazz == null || !clazz.getKind().isClass()) {
            return null;
        }
        TypeElement ap = ctx.getInfo().getElements().getTypeElement("jpt30.annotation.processing.AbstractProcessor");
        if (ap == null) {
            return null;
        }
        Types types = ctx.getInfo().getTypes();
        if (!types.isSubtype(types.erasure(clazz.asType()), types.erasure(ap.asType()))) {
            return null;
        }
        for (ExecutableElement ee : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
            MethodTree t;
            if (!ee.getSimpleName().contentEquals("getSupportedAnnotationTypes") || !ee.getParameters().isEmpty() || (t = ctx.getInfo().getTrees().getTree(ee)) == null) continue;
            return ErrorDescriptionFactory.forName(ctx, t, Bundle.ERR_AnnotationProcessors_overridingGetSupportedAnnotations(), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription annotatedByObsoleteSource(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        ProcessorHintSupport helper = new ProcessorHintSupport(ctx.getInfo(), ctx.getPath());
        if (!helper.initialize()) {
            return null;
        }
        if (!helper.canOverrideAbstract(true)) {
            return null;
        }
        SupportedSourceVersion ssv = helper.getProcessor().getAnnotation(SupportedSourceVersion.class);
        SourceVersion current = info.getSourceVersion();
        if (ssv != null) {
            SourceVersion declared = ssv.value();
            if (declared.compareTo(current) >= 0) {
                return null;
            }
            TreePath rewriteAt = helper.findSupportedAnnotation();
            if (rewriteAt == null) {
                return null;
            }
            return ErrorDescriptionFactory.forTree(ctx, rewriteAt, Bundle.HINT_AnnoProcessor_DeclaredSourceObsolete(), new OverrideReturnLatest(info, helper.getProcessorPath(), false).toEditorFix(), new OverrideReturnLatest(info, helper.getProcessorPath(), true).toEditorFix(), AnnotationProcessors.changeToCurrentSource(ctx, helper, info.getSourceVersion()));
        }
        TreePath path = helper.getProcessorPath();
        return ErrorDescriptionFactory.forTree(ctx, path, Bundle.HINT_AnnoProcessor_NoSupportedSource(), new OverrideReturnLatest(info, path, false).toEditorFix(), new OverrideReturnLatest(info, path, true).toEditorFix(), new DeclareCurrentSourceFix(info, path, info.getSourceVersion()).toEditorFix());
    }

    static Fix changeToCurrentSource(HintContext ctx, ProcessorHintSupport support, SourceVersion target) {
        TreePath rewriteAt = support.findSupportedAnnotation();
        if (rewriteAt == null) {
            return null;
        }
        String msg = ctx.getInfo().getSourceVersion().compareTo(target) == 0 ? Bundle.FIX_AnnoProcessor_SpecificSourceLevel(AnnotationProcessors.levelToString(target)) : Bundle.FIX_AnnoProcessor_UseProjectSourceLevel(AnnotationProcessors.levelToString(target));
        return JavaFixUtilities.rewriteFix(ctx, msg, rewriteAt, "@jpt30.annotation.processing.SupportedSourceVersion(jpt30.lang.model.SourceVersion." + target.name() + ")");
    }

    public static String levelToString(SourceVersion l) {
        String s = l.name();
        switch (l) {
            case RELEASE_0: {
                return "1";
            }
            case RELEASE_1: {
                return "1.1";
            }
            case RELEASE_2: 
            case RELEASE_3: 
            case RELEASE_4: {
                return "1." + s.charAt(s.length() - 1);
            }
        }
        int under = s.lastIndexOf(95);
        return s.substring(under + 1);
    }

    public static class ProcessorHintSupport {
        private final CompilationInfo info;
        private final TreePath processorPath;
        private TypeElement baseProcessor;
        private TypeMirror baseProcessorType;
        private TypeElement abstractProcessor;
        private TypeMirror abstractProcessorType;
        private TypeElement supportedSource;
        private TypeMirror supportedSourceType;
        private TypeElement processor;
        private ExecutableElement abstractGetSupported;
        private ExecutableElement overridenGetSupported;

        public ProcessorHintSupport(CompilationInfo info, TreePath path) {
            this.info = info;
            this.processorPath = path;
        }

        public ExecutableElement findOverridenSupportedSource() {
            Element e = this.info.getElementUtilities().getImplementationOf(this.abstractGetSupported, this.processor);
            if (e == null || e.getEnclosingElement() == this.abstractProcessor || e.getKind() != ElementKind.METHOD) {
                return null;
            }
            return (ExecutableElement)e;
        }

        public boolean initialize() {
            Element e = this.info.getTrees().getElement(this.processorPath);
            if (e == null || e.getKind() != ElementKind.CLASS) {
                return false;
            }
            this.processor = (TypeElement)e;
            if (this.processorPath.getLeaf().getKind() != Tree.Kind.CLASS) {
                return false;
            }
            this.abstractProcessor = this.info.getElements().getTypeElement(ABSTRACT_PROCESSOR_TYPE);
            if (!Utilities.isValidElement(this.abstractProcessor)) {
                return false;
            }
            this.abstractProcessorType = this.abstractProcessor.asType();
            this.baseProcessor = this.info.getElements().getTypeElement(PROCESSOR_TYPE);
            if (!Utilities.isValidElement(this.baseProcessor)) {
                return false;
            }
            this.baseProcessorType = this.baseProcessor.asType();
            this.supportedSource = this.info.getElements().getTypeElement(SUPPORTED_SOURCE_TYPE);
            if (!Utilities.isValidElement(this.supportedSource)) {
                return false;
            }
            this.supportedSourceType = this.supportedSource.asType();
            if (!Utilities.isValidType(this.supportedSourceType)) {
                return false;
            }
            ExecutableElement ee = this.findGetSupported(this.abstractProcessor);
            if (ee == null) {
                return false;
            }
            this.abstractGetSupported = ee;
            return this.info.getTypes().isSubtype(this.processor.asType(), this.abstractProcessor.getSuperclass());
        }

        public ExecutableElement findGetSupported(Element clazz) {
            return ElementFilter.methodsIn(clazz.getEnclosedElements()).stream().filter(x -> x.getSimpleName().contentEquals(AnnotationProcessors.METHOD_SUPPORTED_SOURCE_VERSION)).findAny().orElse(null);
        }

        public boolean canOverrideProcessor(boolean checkOverride) {
            if (!this.info.getTypes().isSubtype(this.processor.asType(), this.baseProcessorType)) {
                return false;
            }
            if (!checkOverride) {
                return true;
            }
            ExecutableElement ee = this.findGetSupported(this.baseProcessor);
            if (ee == null) {
                return false;
            }
            Element e = this.info.getElementUtilities().getImplementationOf(ee, this.processor);
            if (e == null) {
                return true;
            }
            if (!Utilities.isValidElement(e) || e.getKind() != ElementKind.METHOD) {
                return false;
            }
            this.overridenGetSupported = (ExecutableElement)e;
            return e.getEnclosingElement() == this.baseProcessor || e.getEnclosingElement() == this.abstractProcessor;
        }

        public boolean canOverrideAbstract(boolean checkOverride) {
            if (!this.info.getTypes().isSubtype(this.processor.asType(), this.abstractProcessorType)) {
                return false;
            }
            if (!checkOverride) {
                return true;
            }
            Element e = this.info.getElementUtilities().getImplementationOf(this.abstractGetSupported, this.processor);
            if (e == null) {
                return true;
            }
            if (!Utilities.isValidElement(e) || e.getKind() != ElementKind.METHOD) {
                return false;
            }
            this.overridenGetSupported = (ExecutableElement)e;
            return e.getEnclosingElement() == this.abstractProcessor;
        }

        public TypeElement getProcessor() {
            return this.processor;
        }

        public TreePath findSupportedAnnotation() {
            ClassTree ct = (ClassTree)this.processorPath.getLeaf();
            TreePath modPath = new TreePath(this.processorPath, ct.getModifiers());
            for (AnnotationTree annotationTree : ct.getModifiers().getAnnotations()) {
                TreePath tp = new TreePath(modPath, annotationTree);
                TypeMirror am = this.info.getTrees().getTypeMirror(tp);
                if (!this.info.getTypes().isSameType(am, this.supportedSourceType)) continue;
                return tp;
            }
            return null;
        }

        public ExecutableElement getOverridenGetSupported() {
            return this.overridenGetSupported;
        }

        public TreePath getProcessorPath() {
            return this.processorPath;
        }

        public void makeGetSupportedOverride(WorkingCopy wc, SourceVersion projectSource, boolean removeSupportedAnnotation) {
            ArrayList<? extends AnnotationTree> annos;
            TreePath tp;
            TreeMaker make = wc.getTreeMaker();
            BlockTree body = make.Block(Collections.singletonList(make.Return(projectSource != null ? make.MemberSelect(make.QualIdent(SOURCE_VERSION_TYPE), projectSource.name()) : make.MethodInvocation(Collections.emptyList(), make.MemberSelect(make.QualIdent(SOURCE_VERSION_TYPE), "latest"), Collections.emptyList()))), false);
            MethodTree overrideMethod = make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(make.Annotation(make.Identifier("Override"), Collections.emptyList()))), (CharSequence)AnnotationProcessors.METHOD_SUPPORTED_SOURCE_VERSION, (Tree)make.QualIdent(SOURCE_VERSION_TYPE), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
            ClassTree ct = (ClassTree)this.getProcessorPath().getLeaf();
            ClassTree nct = make.addClassMember(ct, make.asNew(overrideMethod));
            if (removeSupportedAnnotation && (tp = this.findSupportedAnnotation()) != null && (annos = new ArrayList<AnnotationTree>(nct.getModifiers().getAnnotations())).remove(tp.getLeaf())) {
                make.asRemoved(tp.getLeaf());
                wc.rewrite(nct.getModifiers(), make.Modifiers(nct.getModifiers(), annos));
            }
            wc.rewrite(ct, nct);
        }
    }

    public static class OverrideReturnLatest
    extends JavaFix {
        private final SourceVersion projectSource;

        public OverrideReturnLatest(CompilationInfo info, TreePath tp, boolean project) {
            super(info, tp, OverrideReturnLatest.createSortedText(project));
            this.projectSource = project ? info.getSourceVersion() : null;
        }

        private static String createSortedText(boolean project) {
            return project ? "010:FIX_AnnoProcessor_OverrideProjectSupported" : "000:FIX_AnnoProcessor_OverrideLatestSupported";
        }

        @Override
        protected String getText() {
            return this.projectSource != null ? Bundle.FIX_AnnoProcessor_OverrideProjectSupported(AnnotationProcessors.levelToString(this.projectSource)) : Bundle.FIX_AnnoProcessor_OverrideLatestSupported();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath path = ctx.getPath();
            if (path.getLeaf().getKind() != Tree.Kind.CLASS) {
                return;
            }
            ProcessorHintSupport support = new ProcessorHintSupport(ctx.getWorkingCopy(), path);
            if (!support.initialize()) {
                return;
            }
            support.makeGetSupportedOverride(ctx.getWorkingCopy(), this.projectSource, true);
        }
    }

    private static class DeclareCurrentSourceFix
    extends JavaFix {
        private final SourceVersion target;
        private final boolean project;

        DeclareCurrentSourceFix(CompilationInfo info, TreePath tp, SourceVersion target) {
            super(info, tp);
            this.target = target;
            this.project = target.compareTo(info.getSourceVersion()) == 0;
        }

        @Override
        protected String getText() {
            return this.project ? Bundle.FIX_AnnoProcessor_AddProjectSourceLevel(AnnotationProcessors.levelToString(this.target)) : Bundle.FIX_AnnoProcessor_AddSpecificSourceLevel(AnnotationProcessors.levelToString(this.target));
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath cpath = ctx.getPath();
            if (cpath.getLeaf().getKind() != Tree.Kind.CLASS) {
                return;
            }
            WorkingCopy wc = ctx.getWorkingCopy();
            TreeMaker make = wc.getTreeMaker();
            ClassTree ct = (ClassTree)cpath.getLeaf();
            ModifiersTree mt = ct.getModifiers();
            ModifiersTree nmt = make.Modifiers(mt, Collections.singletonList(make.Annotation(make.QualIdent(SUPPORTED_SOURCE_TYPE), Collections.singletonList(make.MemberSelect(make.QualIdent(SOURCE_VERSION_TYPE), wc.getSourceVersion().name())))));
            wc.rewrite(mt, nmt);
        }
    }
}

