/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.infrastructure.LazyHintComputationFactory;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.filesystems.FileObject;

public class CreatorBasedLazyFixList
implements LazyFixList {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean computed;
    private boolean computing;
    private List<Fix> fixes;
    private FileObject file;
    private String diagnosticKey;
    private String diagnosticMessage;
    private int offset;
    private final Collection<ErrorRule> c;
    private final Map<Class, ErrorRule.Data> class2Data;
    private ErrorRule<?> currentRule;
    public static final List<Fix> CANCELLED = Collections.unmodifiableList(new LinkedList());

    public CreatorBasedLazyFixList(FileObject file, String diagnosticKey, String diagnosticMessage, int offset, Collection<ErrorRule> c, Map<Class, ErrorRule.Data> class2Data) {
        this.file = file;
        this.diagnosticKey = diagnosticKey;
        this.diagnosticMessage = diagnosticMessage;
        this.offset = offset;
        this.c = c;
        this.class2Data = class2Data;
        this.fixes = Collections.emptyList();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public boolean probablyContainsFixes() {
        return true;
    }

    @Override
    public synchronized List<Fix> getFixes() {
        if (!this.computed && !this.computing) {
            LazyHintComputationFactory.addToCompute(this.file, this);
            this.computing = true;
        }
        return this.fixes;
    }

    @Override
    public synchronized boolean isComputed() {
        return this.computed;
    }

    private synchronized void setCurrentRule(ErrorRule currentRule) {
        this.currentRule = currentRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(CompilationInfo info, AtomicBoolean cancelled) {
        CreatorBasedLazyFixList creatorBasedLazyFixList = this;
        synchronized (creatorBasedLazyFixList) {
            if (this.computed) {
                return;
            }
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        TreePath path = info.getTreeUtilities().pathFor(this.offset + 1);
        for (ErrorRule rule : this.c) {
            List<Fix> currentRuleFixes;
            if (cancelled.get()) {
                return;
            }
            this.setCurrentRule(rule);
            ErrorRule.Data<String> data = this.class2Data.get(rule.getClass());
            if (data == null) {
                data = new ErrorRule.Data<String>();
                this.class2Data.put(rule.getClass(), data);
            }
            if ("compiler.err.proc.messager".equals(this.diagnosticKey)) {
                data.setData(this.diagnosticMessage);
            }
            try {
                currentRuleFixes = rule.run(info, this.diagnosticKey, this.offset, path, data);
            }
            catch (Exception ex) {
                Logger.getLogger(CreatorBasedLazyFixList.class.getName()).log(Level.WARNING, rule.getDisplayName() + " rule failed", ex);
                this.setCurrentRule(null);
                continue;
            }
            try {
                if (currentRuleFixes == CANCELLED) {
                    cancelled.set(true);
                    return;
                }
                if (currentRuleFixes == null) continue;
                fixes.addAll(currentRuleFixes);
            }
            finally {
                this.setCurrentRule(null);
            }
        }
        if (cancelled.get()) {
            return;
        }
        CreatorBasedLazyFixList creatorBasedLazyFixList2 = this;
        synchronized (creatorBasedLazyFixList2) {
            this.fixes = fixes;
            this.computed = true;
        }
        this.pcs.firePropertyChange("fixes", null, null);
        this.pcs.firePropertyChange("computed", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        CreatorBasedLazyFixList creatorBasedLazyFixList = this;
        synchronized (creatorBasedLazyFixList) {
            if (this.currentRule != null) {
                this.currentRule.cancel();
            }
        }
    }
}

