/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TupleFilter;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.IndexInfoImpl;

class TabInfoImpl {
    static final int ROWNOTDUPLICATE = -1;
    private IndexInfoImpl[] indexes;
    private long heapConglomerate = -1L;
    private int numIndexesSet;
    private boolean heapSet;
    private final CatalogRowFactory crf;
    private boolean computedStreamStorableHeapColIds = false;
    private int[] streamStorableHeapColIds;

    TabInfoImpl(CatalogRowFactory catalogRowFactory) {
        this.crf = catalogRowFactory;
        int n = catalogRowFactory.getNumIndexes();
        if (n > 0) {
            this.indexes = new IndexInfoImpl[n];
            for (int i = 0; i < n; ++i) {
                this.indexes[i] = new IndexInfoImpl(i, catalogRowFactory);
            }
        }
    }

    long getHeapConglomerate() {
        return this.heapConglomerate;
    }

    void setHeapConglomerate(long l) {
        this.heapConglomerate = l;
        this.heapSet = true;
    }

    long getIndexConglomerate(int n) {
        return this.indexes[n].getConglomerateNumber();
    }

    void setIndexConglomerate(int n, long l) {
        this.indexes[n].setConglomerateNumber(l);
        ++this.numIndexesSet;
    }

    void setIndexConglomerate(ConglomerateDescriptor conglomerateDescriptor) {
        String string = conglomerateDescriptor.getConglomerateName();
        for (int i = 0; i < this.indexes.length; ++i) {
            if (!this.indexes[i].getIndexName().equals(string)) continue;
            this.indexes[i].setConglomerateNumber(conglomerateDescriptor.getConglomerateNumber());
            break;
        }
        ++this.numIndexesSet;
    }

    String getTableName() {
        return this.crf.getCatalogName();
    }

    String getIndexName(int n) {
        return this.indexes[n].getIndexName();
    }

    CatalogRowFactory getCatalogRowFactory() {
        return this.crf;
    }

    boolean isComplete() {
        if (!this.heapSet) {
            return false;
        }
        return this.indexes == null || this.indexes.length == this.numIndexesSet;
    }

    int getIndexColumnCount(int n) {
        return this.indexes[n].getColumnCount();
    }

    IndexRowGenerator getIndexRowGenerator(int n) {
        return this.indexes[n].getIndexRowGenerator();
    }

    void setIndexRowGenerator(int n, IndexRowGenerator indexRowGenerator) {
        this.indexes[n].setIndexRowGenerator(indexRowGenerator);
    }

    int getNumberOfIndexes() {
        if (this.indexes == null) {
            return 0;
        }
        return this.indexes.length;
    }

    int getBaseColumnPosition(int n, int n2) {
        return this.indexes[n].getBaseColumnPosition(n2);
    }

    boolean isIndexUnique(int n) {
        return this.indexes[n].isIndexUnique();
    }

    int insertRow(ExecRow execRow, TransactionController transactionController) throws StandardException {
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.insertRowListImpl(new ExecRow[]{execRow}, transactionController, rowLocationArray);
    }

    int insertRowList(ExecRow[] execRowArray, TransactionController transactionController) throws StandardException {
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.insertRowListImpl(execRowArray, transactionController, rowLocationArray);
    }

    private int insertRowListImpl(ExecRow[] execRowArray, TransactionController transactionController, RowLocation[] rowLocationArray) throws StandardException {
        RowLocation rowLocation;
        int n;
        int n2 = -1;
        int n3 = this.crf.getNumIndexes();
        ConglomerateController[] conglomerateControllerArray = new ConglomerateController[n3];
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4, 6, 4);
        for (n = 0; n < n3; ++n) {
            long l = this.getIndexConglomerate(n);
            if (l <= -1L) continue;
            conglomerateControllerArray[n] = transactionController.openConglomerate(l, false, 4, 6, 4);
        }
        rowLocationArray[0] = rowLocation = conglomerateController.newRowLocationTemplate();
        for (n = 0; n < execRowArray.length; ++n) {
            ExecRow execRow = execRowArray[n];
            conglomerateController.insertAndFetchLocation(execRow.getRowArray(), rowLocation);
            for (int i = 0; i < n3; ++i) {
                ExecIndexRow execIndexRow;
                int n4;
                if (conglomerateControllerArray[i] == null || (n4 = conglomerateControllerArray[i].insert((execIndexRow = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(i), rowLocation, execRow)).getRowArray())) != 1) continue;
                n2 = n;
            }
        }
        for (n = 0; n < n3; ++n) {
            if (conglomerateControllerArray[n] == null) continue;
            conglomerateControllerArray[n].close();
        }
        conglomerateController.close();
        return n2;
    }

    int deleteRow(TransactionController transactionController, ExecIndexRow execIndexRow, int n) throws StandardException {
        return this.deleteRows(transactionController, execIndexRow, 1, null, null, execIndexRow, -1, n, true);
    }

    int deleteRow(TransactionController transactionController, ExecIndexRow execIndexRow, int n, boolean bl) throws StandardException {
        return this.deleteRows(transactionController, execIndexRow, 1, null, null, execIndexRow, -1, n, bl);
    }

    int deleteRows(TransactionController transactionController, ExecIndexRow execIndexRow, int n, Qualifier[][] qualifierArray, TupleFilter tupleFilter, ExecIndexRow execIndexRow2, int n2, int n3) throws StandardException {
        return this.deleteRows(transactionController, execIndexRow, n, qualifierArray, tupleFilter, execIndexRow2, n2, n3, true);
    }

    private int deleteRows(TransactionController transactionController, ExecIndexRow execIndexRow, int n, Qualifier[][] qualifierArray, TupleFilter tupleFilter, ExecIndexRow execIndexRow2, int n2, int n3, boolean bl) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        int n4 = 0;
        boolean bl2 = true;
        RowChanger rowChanger = this.getRowChanger(transactionController, null, execRow);
        int n5 = execIndexRow != null && execIndexRow2 != null ? 6 : 7;
        int n6 = execIndexRow != null && execIndexRow2 != null && execIndexRow == execIndexRow2 ? 4 : 5;
        rowChanger.open(n5, bl);
        DataValueDescriptor[] dataValueDescriptorArray = execIndexRow == null ? null : execIndexRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execIndexRow2 == null ? null : execIndexRow2.getRowArray();
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4 | (bl ? 0 : 128), n5, 4);
        ScanController scanController = transactionController.openScan(this.getIndexConglomerate(n3), false, 4 | (bl ? 0 : 128), n5, n6, null, dataValueDescriptorArray, n, qualifierArray, dataValueDescriptorArray2, n2);
        ExecIndexRow execIndexRow3 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n3), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
        while (scanController.fetchNext(execIndexRow3.getRowArray())) {
            RowLocation rowLocation = (RowLocation)execIndexRow3.getColumn(execIndexRow3.nColumns());
            boolean bl3 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            if (tupleFilter != null) {
                bl2 = tupleFilter.execute(execRow).equals(true);
            }
            if (!bl2) continue;
            rowChanger.deleteRow(execRow, rowLocation);
            ++n4;
        }
        conglomerateController.close();
        scanController.close();
        rowChanger.close();
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecRow getRow(TransactionController transactionController, ExecIndexRow execIndexRow, int n) throws StandardException {
        try (ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 0, 6, 4);){
            ExecRow execRow = this.getRow(transactionController, conglomerateController, execIndexRow, n);
            return execRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowLocation getRowLocation(TransactionController transactionController, ExecIndexRow execIndexRow, int n) throws StandardException {
        try (ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 0, 6, 4);){
            RowLocation[] rowLocationArray = new RowLocation[1];
            ExecRow execRow = this.getRowInternal(transactionController, conglomerateController, execIndexRow, n, rowLocationArray);
            RowLocation rowLocation = rowLocationArray[0];
            return rowLocation;
        }
    }

    ExecRow getRow(TransactionController transactionController, ConglomerateController conglomerateController, ExecIndexRow execIndexRow, int n) throws StandardException {
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.getRowInternal(transactionController, conglomerateController, execIndexRow, n, rowLocationArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecRow getRowInternal(TransactionController transactionController, ConglomerateController conglomerateController, ExecIndexRow execIndexRow, int n, RowLocation[] rowLocationArray) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        ScanController scanController = transactionController.openScan(this.getIndexConglomerate(n), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        ExecIndexRow execIndexRow2 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
        try {
            if (scanController.fetchNext(execIndexRow2.getRowArray())) {
                RowLocation rowLocation;
                rowLocationArray[0] = rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
                boolean bl = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
                ExecRow execRow2 = execRow;
                return execRow2;
            }
            ExecRow execRow3 = null;
            return execRow3;
        }
        finally {
            scanController.close();
        }
    }

    void updateRow(ExecIndexRow execIndexRow, ExecRow execRow, int n, boolean[] blArray, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecRow[] execRowArray = new ExecRow[]{execRow};
        this.updateRow(execIndexRow, execRowArray, n, blArray, nArray, transactionController);
    }

    void updateRow(ExecIndexRow execIndexRow, ExecRow[] execRowArray, int n, boolean[] blArray, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        RowChanger rowChanger = this.getRowChanger(transactionController, nArray, execRow);
        rowChanger.openForUpdate(blArray, 6, true);
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4, 6, 4);
        ScanController scanController = transactionController.openScan(this.getIndexConglomerate(n), false, 4, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        ExecIndexRow execIndexRow2 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
        int n2 = 0;
        while (scanController.fetchNext(execIndexRow2.getRowArray())) {
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            rowChanger.updateRow(execRow, n2 == execRowArray.length - 1 ? execRowArray[n2] : execRowArray[n2++], rowLocation);
        }
        rowChanger.finish();
        conglomerateController.close();
        scanController.close();
        rowChanger.close();
    }

    Properties getCreateHeapProperties() {
        return this.crf.getCreateHeapProperties();
    }

    Properties getCreateIndexProperties(int n) {
        return this.crf.getCreateIndexProperties(n);
    }

    private RowChanger getRowChanger(TransactionController transactionController, int[] nArray, ExecRow execRow) throws StandardException {
        int n = this.crf.getNumIndexes();
        IndexRowGenerator[] indexRowGeneratorArray = new IndexRowGenerator[n];
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            indexRowGeneratorArray[i] = this.getIndexRowGenerator(i);
            lArray[i] = this.getIndexConglomerate(i);
        }
        RowChanger rowChanger = this.crf.getExecutionFactory().getRowChanger(this.getHeapConglomerate(), null, null, indexRowGeneratorArray, lArray, null, null, this.crf.getHeapColumnCount(), transactionController, nArray, this.getStreamStorableHeapColIds(execRow), null);
        return rowChanger;
    }

    private int[] getStreamStorableHeapColIds(ExecRow execRow) throws StandardException {
        if (!this.computedStreamStorableHeapColIds) {
            int n;
            int n2 = 0;
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            for (n = 0; n < dataValueDescriptorArray.length; ++n) {
                if (!(dataValueDescriptorArray[n] instanceof StreamStorable)) continue;
                ++n2;
            }
            if (n2 > 0) {
                this.streamStorableHeapColIds = new int[n2];
                n = 0;
                for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
                    if (!(dataValueDescriptorArray[i] instanceof StreamStorable)) continue;
                    this.streamStorableHeapColIds[n++] = i;
                }
            }
            this.computedStreamStorableHeapColIds = true;
        }
        return this.streamStorableHeapColIds;
    }

    private ExecIndexRow getIndexRowFromHeapRow(IndexRowGenerator indexRowGenerator, RowLocation rowLocation, ExecRow execRow) throws StandardException {
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        return execIndexRow;
    }

    public String toString() {
        return "";
    }
}

