/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.Rest;

public abstract class RestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private AtomicReference<RestContext> context = new AtomicReference();
    private AtomicReference<Exception> initException = new AtomicReference();

    public synchronized void destroy() {
        if (Utils.nn((Object)((Object)this.context.get()))) {
            this.context.get().destroy();
        }
        super.destroy();
    }

    public synchronized RestContext getContext() {
        RestContext rc = this.context.get();
        if (rc == null) {
            throw new InternalServerError("RestContext object not set on resource.", new Object[0]);
        }
        return rc;
    }

    public synchronized String getPath() {
        RestContext context = this.context.get();
        if (Utils.nn((Object)((Object)context))) {
            return context.getFullPath();
        }
        ClassInfoTyped ci = ClassInfo.of(((Object)((Object)this)).getClass());
        return CollectionUtils.rstream((List)AP.find(Rest.class, (ClassInfo)ci, new AnnotationTraversal[0])).map(x -> ((Rest)x.inner()).path()).filter(Utils::ne).map(StringUtils::trimSlashes).findFirst().orElse("");
    }

    public synchronized RestRequest getRequest() {
        return this.getContext().getLocalSession().getOpSession().getRequest();
    }

    public synchronized RestResponse getResponse() {
        return this.getContext().getLocalSession().getOpSession().getResponse();
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            if (Utils.nn((Object)((Object)this.context.get()))) {
                return;
            }
            super.init(servletConfig);
            this.context.set(RestContext.create(((Object)((Object)this)).getClass(), null, servletConfig).init(() -> this).build());
            this.context.get().postInit();
            this.context.get().postInitChildFirst();
        }
        catch (ServletException e) {
            this.initException.set((Exception)((Object)e));
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", Utils.cn((Object)((Object)this)));
            throw e;
        }
        catch (BasicHttpException e) {
            this.initException.set((Exception)((Object)e));
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", Utils.cn((Object)((Object)this)));
        }
        catch (Throwable e) {
            this.initException.set((Exception)new InternalServerError(e));
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", Utils.cn((Object)((Object)this)));
        }
    }

    public void log(Level level, String msg, Object ... args) {
        this.doLog(level, null, Utils.fs((String)msg, (Object[])args));
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        this.doLog(level, cause, Utils.fs((String)msg, (Object[])args));
    }

    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, InternalServerError, IOException {
        try {
            if (Utils.nn((Object)this.initException.get())) {
                throw this.initException.get();
            }
            if (this.context.get() == null) {
                throw new InternalServerError("Servlet {0} not initialized.  init(ServletConfig) was not called.  This can occur if you've overridden this method but didn't call super.init(RestConfig).", new Object[]{Utils.cn((Object)((Object)this))});
            }
            this.getContext().execute((Object)this, r1, r2);
        }
        catch (Throwable e) {
            r2.sendError(500, ThrowableUtils.lm((Throwable)e));
        }
    }

    protected void doLog(Level level, Throwable cause, Supplier<String> msg) {
        Logger logger;
        RestContext c = this.context.get();
        Logger logger2 = logger = c == null ? null : c.getLogger();
        if (logger == null) {
            logger = Logger.getLogger(Utils.cn((Object)((Object)this)));
        }
        logger.log(level, cause, msg);
    }

    protected void setContext(RestContext context) throws ServletException {
        if (this.context.get() == null) {
            super.init(context.getBuilder());
            this.context.set(context);
        }
    }
}

